// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.services.networkfirewall.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.networkfirewall.endpoints.EndpointProvider
import aws.sdk.kotlin.services.networkfirewall.model.AssociateFirewallPolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.AssociateFirewallPolicyResponse
import aws.sdk.kotlin.services.networkfirewall.model.AssociateSubnetsRequest
import aws.sdk.kotlin.services.networkfirewall.model.AssociateSubnetsResponse
import aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallPolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallPolicyResponse
import aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallRequest
import aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallResponse
import aws.sdk.kotlin.services.networkfirewall.model.CreateRuleGroupRequest
import aws.sdk.kotlin.services.networkfirewall.model.CreateRuleGroupResponse
import aws.sdk.kotlin.services.networkfirewall.model.DeleteFirewallPolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.DeleteFirewallPolicyResponse
import aws.sdk.kotlin.services.networkfirewall.model.DeleteFirewallRequest
import aws.sdk.kotlin.services.networkfirewall.model.DeleteFirewallResponse
import aws.sdk.kotlin.services.networkfirewall.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.networkfirewall.model.DeleteRuleGroupRequest
import aws.sdk.kotlin.services.networkfirewall.model.DeleteRuleGroupResponse
import aws.sdk.kotlin.services.networkfirewall.model.DescribeFirewallPolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeFirewallPolicyResponse
import aws.sdk.kotlin.services.networkfirewall.model.DescribeFirewallRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeFirewallResponse
import aws.sdk.kotlin.services.networkfirewall.model.DescribeLoggingConfigurationRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeLoggingConfigurationResponse
import aws.sdk.kotlin.services.networkfirewall.model.DescribeResourcePolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeResourcePolicyResponse
import aws.sdk.kotlin.services.networkfirewall.model.DescribeRuleGroupMetadataRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeRuleGroupMetadataResponse
import aws.sdk.kotlin.services.networkfirewall.model.DescribeRuleGroupRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeRuleGroupResponse
import aws.sdk.kotlin.services.networkfirewall.model.DisassociateSubnetsRequest
import aws.sdk.kotlin.services.networkfirewall.model.DisassociateSubnetsResponse
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallPoliciesRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallPoliciesResponse
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallsRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallsResponse
import aws.sdk.kotlin.services.networkfirewall.model.ListRuleGroupsRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListRuleGroupsResponse
import aws.sdk.kotlin.services.networkfirewall.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.networkfirewall.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.networkfirewall.model.TagResourceRequest
import aws.sdk.kotlin.services.networkfirewall.model.TagResourceResponse
import aws.sdk.kotlin.services.networkfirewall.model.UntagResourceRequest
import aws.sdk.kotlin.services.networkfirewall.model.UntagResourceResponse
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallDescriptionRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallDescriptionResponse
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyResponse
import aws.sdk.kotlin.services.networkfirewall.model.UpdateLoggingConfigurationRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateLoggingConfigurationResponse
import aws.sdk.kotlin.services.networkfirewall.model.UpdateRuleGroupRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateRuleGroupResponse
import aws.sdk.kotlin.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * This is the API Reference for Network Firewall. This guide is for developers who need detailed information about the Network Firewall API actions, data types, and errors.
 * + The REST API requires you to handle connection details, such as calculating signatures, handling request retries, and error handling. For general information about using the Amazon Web Services REST APIs, see [Amazon Web Services APIs](https://docs.aws.amazon.com/general/latest/gr/aws-apis.html). To access Network Firewall using the REST API endpoint: `https://network-firewall.<region>.amazonaws.com `
 * + Alternatively, you can use one of the Amazon Web Services SDKs to access an API that's tailored to the programming language or platform that you're using. For more information, see [Amazon Web Services SDKs](http://aws.amazon.com/tools/#SDKs).
 * + For descriptions of Network Firewall features, including and step-by-step instructions on how to use them through the Network Firewall console, see the [Network Firewall Developer Guide](https://docs.aws.amazon.com/network-firewall/latest/developerguide/).
 *
 * Network Firewall is a stateful, managed, network firewall and intrusion detection and prevention service for Amazon Virtual Private Cloud (Amazon VPC). With Network Firewall, you can filter traffic at the perimeter of your VPC. This includes filtering traffic going to and coming from an internet gateway, NAT gateway, or over VPN or Direct Connect. Network Firewall uses rules that are compatible with Suricata, a free, open source network analysis and threat detection engine. Network Firewall supports Suricata version 5.0.2. For information about Suricata, see the [Suricata website](https://suricata.io/).
 *
 * You can use Network Firewall to monitor and protect your VPC traffic in a number of ways. The following are just a few examples:
 * + Allow domains or IP addresses for known Amazon Web Services service endpoints, such as Amazon S3, and block all other forms of traffic.
 * + Use custom lists of known bad domains to limit the types of domain names that your applications can access.
 * + Perform deep packet inspection on traffic entering or leaving your VPC.
 * + Use stateful protocol detection to filter protocols like HTTPS, regardless of the port used.
 *
 * To enable Network Firewall for your VPCs, you perform steps in both Amazon VPC and in Network Firewall. For information about using Amazon VPC, see [Amazon VPC User Guide](https://docs.aws.amazon.com/vpc/latest/userguide/).
 *
 * To start using Network Firewall, do the following:
 * + (Optional) If you don't already have a VPC that you want to protect, create it in Amazon VPC.
 * + In Amazon VPC, in each Availability Zone where you want to have a firewall endpoint, create a subnet for the sole use of Network Firewall.
 * + In Network Firewall, create stateless and stateful rule groups, to define the components of the network traffic filtering behavior that you want your firewall to have.
 * + In Network Firewall, create a firewall policy that uses your rule groups and specifies additional default traffic filtering behavior.
 * + In Network Firewall, create a firewall and specify your new firewall policy and VPC subnets. Network Firewall creates a firewall endpoint in each subnet that you specify, with the behavior that's defined in the firewall policy.
 * + In Amazon VPC, use ingress routing enhancements to route traffic through the new firewall endpoints.
 */
public interface NetworkFirewallClient : SdkClient {

    override val serviceName: String
        get() = "Network Firewall"
    /**
     * NetworkFirewallClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, NetworkFirewallClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, NetworkFirewallClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): NetworkFirewallClient = DefaultNetworkFirewallClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Network Firewall")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a FirewallPolicy to a Firewall.
     *
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
     */
    public suspend fun associateFirewallPolicy(input: AssociateFirewallPolicyRequest): AssociateFirewallPolicyResponse

    /**
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the Availability Zones that the VPC spans.
     *
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the traffic that's coming into and going out of the zone through the firewall endpoint.
     */
    public suspend fun associateSubnets(input: AssociateSubnetsRequest): AssociateSubnetsResponse

    /**
     * Creates an Network Firewall Firewall and accompanying FirewallStatus for a VPC.
     *
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall Amazon Web Services resource.
     *
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     *
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example UpdateLoggingConfiguration, AssociateSubnets, and UpdateFirewallDeleteProtection.
     *
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations, ListTagsForResource, TagResource, and UntagResource.
     *
     * To retrieve information about firewalls, use ListFirewalls and DescribeFirewall.
     */
    public suspend fun createFirewall(input: CreateFirewallRequest): CreateFirewallResponse

    /**
     * Creates the firewall policy for the firewall according to the specifications.
     *
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful rule groups and other settings. You can use one firewall policy for multiple firewalls.
     */
    public suspend fun createFirewallPolicy(input: CreateFirewallPolicyRequest): CreateFirewallPolicyResponse

    /**
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection, a capacity setting, and tags.
     *
     * You provide your rule group specification in your request using either `RuleGroup` or `Rules`.
     */
    public suspend fun createRuleGroup(input: CreateRuleGroupRequest): CreateRuleGroupResponse

    /**
     * Deletes the specified Firewall and its FirewallStatus. This operation requires the firewall's `DeleteProtection` flag to be `FALSE`. You can't revert this operation.
     *
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you have firewall subnet mappings. Retrieve the subnet mappings by calling DescribeFirewall. You define and update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall safely.
     *
     * To delete a firewall, remove the delete protection if you need to using UpdateFirewallDeleteProtection, then delete the firewall by calling DeleteFirewall.
     */
    public suspend fun deleteFirewall(input: DeleteFirewallRequest = DeleteFirewallRequest {}): DeleteFirewallResponse

    /**
     * Deletes the specified FirewallPolicy.
     */
    public suspend fun deleteFirewallPolicy(input: DeleteFirewallPolicyRequest = DeleteFirewallPolicyRequest {}): DeleteFirewallPolicyResponse

    /**
     * Deletes a resource policy that you created in a PutResourcePolicy request.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes the specified RuleGroup.
     */
    public suspend fun deleteRuleGroup(input: DeleteRuleGroupRequest = DeleteRuleGroupRequest {}): DeleteRuleGroupResponse

    /**
     * Returns the data objects for the specified firewall.
     */
    public suspend fun describeFirewall(input: DescribeFirewallRequest = DescribeFirewallRequest {}): DescribeFirewallResponse

    /**
     * Returns the data objects for the specified firewall policy.
     */
    public suspend fun describeFirewallPolicy(input: DescribeFirewallPolicyRequest = DescribeFirewallPolicyRequest {}): DescribeFirewallPolicyResponse

    /**
     * Returns the logging configuration for the specified firewall.
     */
    public suspend fun describeLoggingConfiguration(input: DescribeLoggingConfigurationRequest = DescribeLoggingConfigurationRequest {}): DescribeLoggingConfigurationResponse

    /**
     * Retrieves a resource policy that you created in a PutResourcePolicy request.
     */
    public suspend fun describeResourcePolicy(input: DescribeResourcePolicyRequest): DescribeResourcePolicyResponse

    /**
     * Returns the data objects for the specified rule group.
     */
    public suspend fun describeRuleGroup(input: DescribeRuleGroupRequest = DescribeRuleGroupRequest {}): DescribeRuleGroupResponse

    /**
     * High-level information about a rule group, returned by operations like create and describe. You can use the information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule group by calling DescribeRuleGroup.
     */
    public suspend fun describeRuleGroupMetadata(input: DescribeRuleGroupMetadataRequest = DescribeRuleGroupMetadataRequest {}): DescribeRuleGroupMetadataResponse

    /**
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets and removes any network filtering protections that the endpoints were providing.
     */
    public suspend fun disassociateSubnets(input: DisassociateSubnetsRequest): DisassociateSubnetsResponse

    /**
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results and the number of firewall policies, a single call might not return the full list.
     */
    public suspend fun listFirewallPolicies(input: ListFirewallPoliciesRequest = ListFirewallPoliciesRequest {}): ListFirewallPoliciesResponse

    /**
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request, this returns only the firewalls for those VPCs.
     *
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full list.
     */
    public suspend fun listFirewalls(input: ListFirewallsRequest = ListFirewallsRequest {}): ListFirewallsResponse

    /**
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and the number of rule groups, a single call might not return the full list.
     */
    public suspend fun listRuleGroups(input: ListRuleGroupsRequest = ListRuleGroupsRequest {}): ListRuleGroupsResponse

    /**
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource Access Manager (RAM) service to manage resource sharing for Network Firewall.
     *
     * Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy, you specify the accounts that you want to share the resource with and the operations that you want the accounts to be able to perform.
     *
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM) operations to access and accept the shared rule group or firewall policy.
     * + [GetResourceShareInvitations](https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html) - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * + [AcceptResourceShareInvitation](https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html) - Accepts the share invitation for a specified resource share.
     *
     * For additional information about resource sharing using RAM, see [Resource Access Manager User Guide](https://docs.aws.amazon.com/ram/latest/userguide/what-is.html).
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Modifies the flag, `DeleteProtection`, which indicates whether it is possible to delete the firewall. If the flag is set to `TRUE`, the firewall is protected against deletion. This setting helps protect against accidentally deleting a firewall that's in use.
     */
    public suspend fun updateFirewallDeleteProtection(input: UpdateFirewallDeleteProtectionRequest): UpdateFirewallDeleteProtectionResponse

    /**
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when you're working with it.
     */
    public suspend fun updateFirewallDescription(input: UpdateFirewallDescriptionRequest = UpdateFirewallDescriptionRequest {}): UpdateFirewallDescriptionResponse

    /**
     * A complex type that contains settings for encryption of your firewall resources.
     */
    public suspend fun updateFirewallEncryptionConfiguration(input: UpdateFirewallEncryptionConfigurationRequest = UpdateFirewallEncryptionConfigurationRequest {}): UpdateFirewallEncryptionConfigurationResponse

    /**
     * Updates the properties of the specified firewall policy.
     */
    public suspend fun updateFirewallPolicy(input: UpdateFirewallPolicyRequest): UpdateFirewallPolicyResponse

    /**
     * Modifies the flag, `ChangeProtection`, which indicates whether it is possible to change the firewall. If the flag is set to `TRUE`, the firewall is protected from changes. This setting helps protect against accidentally changing a firewall that's in use.
     */
    public suspend fun updateFirewallPolicyChangeProtection(input: UpdateFirewallPolicyChangeProtectionRequest): UpdateFirewallPolicyChangeProtectionResponse

    /**
     * Sets the logging configuration for the specified firewall.
     *
     * To change the logging configuration, retrieve the LoggingConfiguration by calling DescribeLoggingConfiguration, then change it and provide the modified object to this update call. You must change the logging configuration one LogDestinationConfig at a time inside the retrieved LoggingConfiguration object.
     *
     * You can perform only one of the following actions in any call to `UpdateLoggingConfiguration`:
     * + Create a new log destination object by adding a single `LogDestinationConfig` array element to `LogDestinationConfigs`.
     * + Delete a log destination object by removing a single `LogDestinationConfig` array element from `LogDestinationConfigs`.
     * + Change the `LogDestination` setting in a single `LogDestinationConfig` array element.
     *
     * You can't change the `LogDestinationType` or `LogType` in a `LogDestinationConfig`. To change these settings, delete the existing `LogDestinationConfig` object and create a new one, using two separate calls to this update operation.
     */
    public suspend fun updateLoggingConfiguration(input: UpdateLoggingConfigurationRequest = UpdateLoggingConfigurationRequest {}): UpdateLoggingConfigurationResponse

    /**
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     *
     * To update a rule group, first call DescribeRuleGroup to retrieve the current RuleGroup object, update the object as needed, and then provide the updated object to this call.
     */
    public suspend fun updateRuleGroup(input: UpdateRuleGroupRequest): UpdateRuleGroupResponse

    /**
     *
     */
    public suspend fun updateSubnetChangeProtection(input: UpdateSubnetChangeProtectionRequest): UpdateSubnetChangeProtectionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun NetworkFirewallClient.withConfig(block: NetworkFirewallClient.Config.Builder.() -> Unit): NetworkFirewallClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultNetworkFirewallClient(newConfig)
}

/**
 * Associates a FirewallPolicy to a Firewall.
 *
 * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
 */
public suspend inline fun NetworkFirewallClient.associateFirewallPolicy(crossinline block: AssociateFirewallPolicyRequest.Builder.() -> Unit): AssociateFirewallPolicyResponse = associateFirewallPolicy(AssociateFirewallPolicyRequest.Builder().apply(block).build())

/**
 * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the Availability Zones that the VPC spans.
 *
 * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the traffic that's coming into and going out of the zone through the firewall endpoint.
 */
public suspend inline fun NetworkFirewallClient.associateSubnets(crossinline block: AssociateSubnetsRequest.Builder.() -> Unit): AssociateSubnetsResponse = associateSubnets(AssociateSubnetsRequest.Builder().apply(block).build())

/**
 * Creates an Network Firewall Firewall and accompanying FirewallStatus for a VPC.
 *
 * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall Amazon Web Services resource.
 *
 * After you create a firewall, you can provide additional settings, like the logging configuration.
 *
 * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example UpdateLoggingConfiguration, AssociateSubnets, and UpdateFirewallDeleteProtection.
 *
 * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations, ListTagsForResource, TagResource, and UntagResource.
 *
 * To retrieve information about firewalls, use ListFirewalls and DescribeFirewall.
 */
public suspend inline fun NetworkFirewallClient.createFirewall(crossinline block: CreateFirewallRequest.Builder.() -> Unit): CreateFirewallResponse = createFirewall(CreateFirewallRequest.Builder().apply(block).build())

/**
 * Creates the firewall policy for the firewall according to the specifications.
 *
 * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful rule groups and other settings. You can use one firewall policy for multiple firewalls.
 */
public suspend inline fun NetworkFirewallClient.createFirewallPolicy(crossinline block: CreateFirewallPolicyRequest.Builder.() -> Unit): CreateFirewallPolicyResponse = createFirewallPolicy(CreateFirewallPolicyRequest.Builder().apply(block).build())

/**
 * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection, a capacity setting, and tags.
 *
 * You provide your rule group specification in your request using either `RuleGroup` or `Rules`.
 */
public suspend inline fun NetworkFirewallClient.createRuleGroup(crossinline block: CreateRuleGroupRequest.Builder.() -> Unit): CreateRuleGroupResponse = createRuleGroup(CreateRuleGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified Firewall and its FirewallStatus. This operation requires the firewall's `DeleteProtection` flag to be `FALSE`. You can't revert this operation.
 *
 * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you have firewall subnet mappings. Retrieve the subnet mappings by calling DescribeFirewall. You define and update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall safely.
 *
 * To delete a firewall, remove the delete protection if you need to using UpdateFirewallDeleteProtection, then delete the firewall by calling DeleteFirewall.
 */
public suspend inline fun NetworkFirewallClient.deleteFirewall(crossinline block: DeleteFirewallRequest.Builder.() -> Unit): DeleteFirewallResponse = deleteFirewall(DeleteFirewallRequest.Builder().apply(block).build())

/**
 * Deletes the specified FirewallPolicy.
 */
public suspend inline fun NetworkFirewallClient.deleteFirewallPolicy(crossinline block: DeleteFirewallPolicyRequest.Builder.() -> Unit): DeleteFirewallPolicyResponse = deleteFirewallPolicy(DeleteFirewallPolicyRequest.Builder().apply(block).build())

/**
 * Deletes a resource policy that you created in a PutResourcePolicy request.
 */
public suspend inline fun NetworkFirewallClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified RuleGroup.
 */
public suspend inline fun NetworkFirewallClient.deleteRuleGroup(crossinline block: DeleteRuleGroupRequest.Builder.() -> Unit): DeleteRuleGroupResponse = deleteRuleGroup(DeleteRuleGroupRequest.Builder().apply(block).build())

/**
 * Returns the data objects for the specified firewall.
 */
public suspend inline fun NetworkFirewallClient.describeFirewall(crossinline block: DescribeFirewallRequest.Builder.() -> Unit): DescribeFirewallResponse = describeFirewall(DescribeFirewallRequest.Builder().apply(block).build())

/**
 * Returns the data objects for the specified firewall policy.
 */
public suspend inline fun NetworkFirewallClient.describeFirewallPolicy(crossinline block: DescribeFirewallPolicyRequest.Builder.() -> Unit): DescribeFirewallPolicyResponse = describeFirewallPolicy(DescribeFirewallPolicyRequest.Builder().apply(block).build())

/**
 * Returns the logging configuration for the specified firewall.
 */
public suspend inline fun NetworkFirewallClient.describeLoggingConfiguration(crossinline block: DescribeLoggingConfigurationRequest.Builder.() -> Unit): DescribeLoggingConfigurationResponse = describeLoggingConfiguration(DescribeLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves a resource policy that you created in a PutResourcePolicy request.
 */
public suspend inline fun NetworkFirewallClient.describeResourcePolicy(crossinline block: DescribeResourcePolicyRequest.Builder.() -> Unit): DescribeResourcePolicyResponse = describeResourcePolicy(DescribeResourcePolicyRequest.Builder().apply(block).build())

/**
 * Returns the data objects for the specified rule group.
 */
public suspend inline fun NetworkFirewallClient.describeRuleGroup(crossinline block: DescribeRuleGroupRequest.Builder.() -> Unit): DescribeRuleGroupResponse = describeRuleGroup(DescribeRuleGroupRequest.Builder().apply(block).build())

/**
 * High-level information about a rule group, returned by operations like create and describe. You can use the information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule group by calling DescribeRuleGroup.
 */
public suspend inline fun NetworkFirewallClient.describeRuleGroupMetadata(crossinline block: DescribeRuleGroupMetadataRequest.Builder.() -> Unit): DescribeRuleGroupMetadataResponse = describeRuleGroupMetadata(DescribeRuleGroupMetadataRequest.Builder().apply(block).build())

/**
 * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets and removes any network filtering protections that the endpoints were providing.
 */
public suspend inline fun NetworkFirewallClient.disassociateSubnets(crossinline block: DisassociateSubnetsRequest.Builder.() -> Unit): DisassociateSubnetsResponse = disassociateSubnets(DisassociateSubnetsRequest.Builder().apply(block).build())

/**
 * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results and the number of firewall policies, a single call might not return the full list.
 */
public suspend inline fun NetworkFirewallClient.listFirewallPolicies(crossinline block: ListFirewallPoliciesRequest.Builder.() -> Unit): ListFirewallPoliciesResponse = listFirewallPolicies(ListFirewallPoliciesRequest.Builder().apply(block).build())

/**
 * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request, this returns only the firewalls for those VPCs.
 *
 * Depending on your setting for max results and the number of firewalls, a single call might not return the full list.
 */
public suspend inline fun NetworkFirewallClient.listFirewalls(crossinline block: ListFirewallsRequest.Builder.() -> Unit): ListFirewallsResponse = listFirewalls(ListFirewallsRequest.Builder().apply(block).build())

/**
 * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and the number of rule groups, a single call might not return the full list.
 */
public suspend inline fun NetworkFirewallClient.listRuleGroups(crossinline block: ListRuleGroupsRequest.Builder.() -> Unit): ListRuleGroupsResponse = listRuleGroups(ListRuleGroupsRequest.Builder().apply(block).build())

/**
 * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
 *
 * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
 */
public suspend inline fun NetworkFirewallClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource Access Manager (RAM) service to manage resource sharing for Network Firewall.
 *
 * Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy, you specify the accounts that you want to share the resource with and the operations that you want the accounts to be able to perform.
 *
 * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM) operations to access and accept the shared rule group or firewall policy.
 * + [GetResourceShareInvitations](https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html) - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
 * + [AcceptResourceShareInvitation](https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html) - Accepts the share invitation for a specified resource share.
 *
 * For additional information about resource sharing using RAM, see [Resource Access Manager User Guide](https://docs.aws.amazon.com/ram/latest/userguide/what-is.html).
 */
public suspend inline fun NetworkFirewallClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
 *
 * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
 */
public suspend inline fun NetworkFirewallClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
 *
 * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
 */
public suspend inline fun NetworkFirewallClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Modifies the flag, `DeleteProtection`, which indicates whether it is possible to delete the firewall. If the flag is set to `TRUE`, the firewall is protected against deletion. This setting helps protect against accidentally deleting a firewall that's in use.
 */
public suspend inline fun NetworkFirewallClient.updateFirewallDeleteProtection(crossinline block: UpdateFirewallDeleteProtectionRequest.Builder.() -> Unit): UpdateFirewallDeleteProtectionResponse = updateFirewallDeleteProtection(UpdateFirewallDeleteProtectionRequest.Builder().apply(block).build())

/**
 * Modifies the description for the specified firewall. Use the description to help you identify the firewall when you're working with it.
 */
public suspend inline fun NetworkFirewallClient.updateFirewallDescription(crossinline block: UpdateFirewallDescriptionRequest.Builder.() -> Unit): UpdateFirewallDescriptionResponse = updateFirewallDescription(UpdateFirewallDescriptionRequest.Builder().apply(block).build())

/**
 * A complex type that contains settings for encryption of your firewall resources.
 */
public suspend inline fun NetworkFirewallClient.updateFirewallEncryptionConfiguration(crossinline block: UpdateFirewallEncryptionConfigurationRequest.Builder.() -> Unit): UpdateFirewallEncryptionConfigurationResponse = updateFirewallEncryptionConfiguration(UpdateFirewallEncryptionConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the properties of the specified firewall policy.
 */
public suspend inline fun NetworkFirewallClient.updateFirewallPolicy(crossinline block: UpdateFirewallPolicyRequest.Builder.() -> Unit): UpdateFirewallPolicyResponse = updateFirewallPolicy(UpdateFirewallPolicyRequest.Builder().apply(block).build())

/**
 * Modifies the flag, `ChangeProtection`, which indicates whether it is possible to change the firewall. If the flag is set to `TRUE`, the firewall is protected from changes. This setting helps protect against accidentally changing a firewall that's in use.
 */
public suspend inline fun NetworkFirewallClient.updateFirewallPolicyChangeProtection(crossinline block: UpdateFirewallPolicyChangeProtectionRequest.Builder.() -> Unit): UpdateFirewallPolicyChangeProtectionResponse = updateFirewallPolicyChangeProtection(UpdateFirewallPolicyChangeProtectionRequest.Builder().apply(block).build())

/**
 * Sets the logging configuration for the specified firewall.
 *
 * To change the logging configuration, retrieve the LoggingConfiguration by calling DescribeLoggingConfiguration, then change it and provide the modified object to this update call. You must change the logging configuration one LogDestinationConfig at a time inside the retrieved LoggingConfiguration object.
 *
 * You can perform only one of the following actions in any call to `UpdateLoggingConfiguration`:
 * + Create a new log destination object by adding a single `LogDestinationConfig` array element to `LogDestinationConfigs`.
 * + Delete a log destination object by removing a single `LogDestinationConfig` array element from `LogDestinationConfigs`.
 * + Change the `LogDestination` setting in a single `LogDestinationConfig` array element.
 *
 * You can't change the `LogDestinationType` or `LogType` in a `LogDestinationConfig`. To change these settings, delete the existing `LogDestinationConfig` object and create a new one, using two separate calls to this update operation.
 */
public suspend inline fun NetworkFirewallClient.updateLoggingConfiguration(crossinline block: UpdateLoggingConfigurationRequest.Builder.() -> Unit): UpdateLoggingConfigurationResponse = updateLoggingConfiguration(UpdateLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall policies. When you modify a rule group, you modify all firewall policies that use the rule group.
 *
 * To update a rule group, first call DescribeRuleGroup to retrieve the current RuleGroup object, update the object as needed, and then provide the updated object to this call.
 */
public suspend inline fun NetworkFirewallClient.updateRuleGroup(crossinline block: UpdateRuleGroupRequest.Builder.() -> Unit): UpdateRuleGroupResponse = updateRuleGroup(UpdateRuleGroupRequest.Builder().apply(block).build())

/**
 *
 */
public suspend inline fun NetworkFirewallClient.updateSubnetChangeProtection(crossinline block: UpdateSubnetChangeProtectionRequest.Builder.() -> Unit): UpdateSubnetChangeProtectionResponse = updateSubnetChangeProtection(UpdateSubnetChangeProtectionRequest.Builder().apply(block).build())
