// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.networkfirewall.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.networkfirewall.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.networkfirewall.model.*
import aws.sdk.kotlin.services.networkfirewall.model.AssociateFirewallPolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.AssociateSubnetsRequest
import aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallPolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallRequest
import aws.sdk.kotlin.services.networkfirewall.model.CreateRuleGroupRequest
import aws.sdk.kotlin.services.networkfirewall.model.DeleteFirewallPolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.DeleteFirewallRequest
import aws.sdk.kotlin.services.networkfirewall.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.DeleteRuleGroupRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeFirewallPolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeFirewallRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeLoggingConfigurationRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeResourcePolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeRuleGroupMetadataRequest
import aws.sdk.kotlin.services.networkfirewall.model.DescribeRuleGroupRequest
import aws.sdk.kotlin.services.networkfirewall.model.DisassociateSubnetsRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallPoliciesRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallsRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListRuleGroupsRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.networkfirewall.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.TagResourceRequest
import aws.sdk.kotlin.services.networkfirewall.model.UntagResourceRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallDescriptionRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateLoggingConfigurationRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateRuleGroupRequest
import aws.sdk.kotlin.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest
import aws.sdk.kotlin.services.networkfirewall.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Network Firewall"
public const val ServiceApiVersion: String = "2020-11-12"
public const val SdkVersion: String = "0.20.1-beta"

internal class DefaultNetworkFirewallClient(override val config: NetworkFirewallClient.Config) : NetworkFirewallClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates a FirewallPolicy to a Firewall.
     *
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
     */
    override suspend fun associateFirewallPolicy(input: AssociateFirewallPolicyRequest): AssociateFirewallPolicyResponse {
        val op = SdkHttpOperation.build<AssociateFirewallPolicyRequest, AssociateFirewallPolicyResponse> {
            serializer = AssociateFirewallPolicyOperationSerializer()
            deserializer = AssociateFirewallPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateFirewallPolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AssociateFirewallPolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateFirewallPolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the Availability Zones that the VPC spans.
     *
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the traffic that's coming into and going out of the zone through the firewall endpoint.
     */
    override suspend fun associateSubnets(input: AssociateSubnetsRequest): AssociateSubnetsResponse {
        val op = SdkHttpOperation.build<AssociateSubnetsRequest, AssociateSubnetsResponse> {
            serializer = AssociateSubnetsOperationSerializer()
            deserializer = AssociateSubnetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateSubnets"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AssociateSubnetsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateSubnets-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an Network Firewall Firewall and accompanying FirewallStatus for a VPC.
     *
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall Amazon Web Services resource.
     *
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     *
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example UpdateLoggingConfiguration, AssociateSubnets, and UpdateFirewallDeleteProtection.
     *
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations, ListTagsForResource, TagResource, and UntagResource.
     *
     * To retrieve information about firewalls, use ListFirewalls and DescribeFirewall.
     */
    override suspend fun createFirewall(input: CreateFirewallRequest): CreateFirewallResponse {
        val op = SdkHttpOperation.build<CreateFirewallRequest, CreateFirewallResponse> {
            serializer = CreateFirewallOperationSerializer()
            deserializer = CreateFirewallOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFirewall"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateFirewallRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateFirewall-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates the firewall policy for the firewall according to the specifications.
     *
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful rule groups and other settings. You can use one firewall policy for multiple firewalls.
     */
    override suspend fun createFirewallPolicy(input: CreateFirewallPolicyRequest): CreateFirewallPolicyResponse {
        val op = SdkHttpOperation.build<CreateFirewallPolicyRequest, CreateFirewallPolicyResponse> {
            serializer = CreateFirewallPolicyOperationSerializer()
            deserializer = CreateFirewallPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFirewallPolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateFirewallPolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateFirewallPolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection, a capacity setting, and tags.
     *
     * You provide your rule group specification in your request using either `RuleGroup` or `Rules`.
     */
    override suspend fun createRuleGroup(input: CreateRuleGroupRequest): CreateRuleGroupResponse {
        val op = SdkHttpOperation.build<CreateRuleGroupRequest, CreateRuleGroupResponse> {
            serializer = CreateRuleGroupOperationSerializer()
            deserializer = CreateRuleGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRuleGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateRuleGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateRuleGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified Firewall and its FirewallStatus. This operation requires the firewall's `DeleteProtection` flag to be `FALSE`. You can't revert this operation.
     *
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you have firewall subnet mappings. Retrieve the subnet mappings by calling DescribeFirewall. You define and update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall safely.
     *
     * To delete a firewall, remove the delete protection if you need to using UpdateFirewallDeleteProtection, then delete the firewall by calling DeleteFirewall.
     */
    override suspend fun deleteFirewall(input: DeleteFirewallRequest): DeleteFirewallResponse {
        val op = SdkHttpOperation.build<DeleteFirewallRequest, DeleteFirewallResponse> {
            serializer = DeleteFirewallOperationSerializer()
            deserializer = DeleteFirewallOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFirewall"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteFirewallRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFirewall-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified FirewallPolicy.
     */
    override suspend fun deleteFirewallPolicy(input: DeleteFirewallPolicyRequest): DeleteFirewallPolicyResponse {
        val op = SdkHttpOperation.build<DeleteFirewallPolicyRequest, DeleteFirewallPolicyResponse> {
            serializer = DeleteFirewallPolicyOperationSerializer()
            deserializer = DeleteFirewallPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFirewallPolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteFirewallPolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFirewallPolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a resource policy that you created in a PutResourcePolicy request.
     */
    override suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse {
        val op = SdkHttpOperation.build<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse> {
            serializer = DeleteResourcePolicyOperationSerializer()
            deserializer = DeleteResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteResourcePolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteResourcePolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteResourcePolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified RuleGroup.
     */
    override suspend fun deleteRuleGroup(input: DeleteRuleGroupRequest): DeleteRuleGroupResponse {
        val op = SdkHttpOperation.build<DeleteRuleGroupRequest, DeleteRuleGroupResponse> {
            serializer = DeleteRuleGroupOperationSerializer()
            deserializer = DeleteRuleGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRuleGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteRuleGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteRuleGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the data objects for the specified firewall.
     */
    override suspend fun describeFirewall(input: DescribeFirewallRequest): DescribeFirewallResponse {
        val op = SdkHttpOperation.build<DescribeFirewallRequest, DescribeFirewallResponse> {
            serializer = DescribeFirewallOperationSerializer()
            deserializer = DescribeFirewallOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFirewall"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeFirewallRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeFirewall-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the data objects for the specified firewall policy.
     */
    override suspend fun describeFirewallPolicy(input: DescribeFirewallPolicyRequest): DescribeFirewallPolicyResponse {
        val op = SdkHttpOperation.build<DescribeFirewallPolicyRequest, DescribeFirewallPolicyResponse> {
            serializer = DescribeFirewallPolicyOperationSerializer()
            deserializer = DescribeFirewallPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFirewallPolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeFirewallPolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeFirewallPolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the logging configuration for the specified firewall.
     */
    override suspend fun describeLoggingConfiguration(input: DescribeLoggingConfigurationRequest): DescribeLoggingConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeLoggingConfigurationRequest, DescribeLoggingConfigurationResponse> {
            serializer = DescribeLoggingConfigurationOperationSerializer()
            deserializer = DescribeLoggingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLoggingConfiguration"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeLoggingConfigurationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeLoggingConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a resource policy that you created in a PutResourcePolicy request.
     */
    override suspend fun describeResourcePolicy(input: DescribeResourcePolicyRequest): DescribeResourcePolicyResponse {
        val op = SdkHttpOperation.build<DescribeResourcePolicyRequest, DescribeResourcePolicyResponse> {
            serializer = DescribeResourcePolicyOperationSerializer()
            deserializer = DescribeResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeResourcePolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeResourcePolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeResourcePolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the data objects for the specified rule group.
     */
    override suspend fun describeRuleGroup(input: DescribeRuleGroupRequest): DescribeRuleGroupResponse {
        val op = SdkHttpOperation.build<DescribeRuleGroupRequest, DescribeRuleGroupResponse> {
            serializer = DescribeRuleGroupOperationSerializer()
            deserializer = DescribeRuleGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRuleGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeRuleGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeRuleGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * High-level information about a rule group, returned by operations like create and describe. You can use the information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule group by calling DescribeRuleGroup.
     */
    override suspend fun describeRuleGroupMetadata(input: DescribeRuleGroupMetadataRequest): DescribeRuleGroupMetadataResponse {
        val op = SdkHttpOperation.build<DescribeRuleGroupMetadataRequest, DescribeRuleGroupMetadataResponse> {
            serializer = DescribeRuleGroupMetadataOperationSerializer()
            deserializer = DescribeRuleGroupMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRuleGroupMetadata"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeRuleGroupMetadataRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeRuleGroupMetadata-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets and removes any network filtering protections that the endpoints were providing.
     */
    override suspend fun disassociateSubnets(input: DisassociateSubnetsRequest): DisassociateSubnetsResponse {
        val op = SdkHttpOperation.build<DisassociateSubnetsRequest, DisassociateSubnetsResponse> {
            serializer = DisassociateSubnetsOperationSerializer()
            deserializer = DisassociateSubnetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateSubnets"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DisassociateSubnetsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateSubnets-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results and the number of firewall policies, a single call might not return the full list.
     */
    override suspend fun listFirewallPolicies(input: ListFirewallPoliciesRequest): ListFirewallPoliciesResponse {
        val op = SdkHttpOperation.build<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse> {
            serializer = ListFirewallPoliciesOperationSerializer()
            deserializer = ListFirewallPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFirewallPolicies"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListFirewallPoliciesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListFirewallPolicies-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request, this returns only the firewalls for those VPCs.
     *
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full list.
     */
    override suspend fun listFirewalls(input: ListFirewallsRequest): ListFirewallsResponse {
        val op = SdkHttpOperation.build<ListFirewallsRequest, ListFirewallsResponse> {
            serializer = ListFirewallsOperationSerializer()
            deserializer = ListFirewallsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFirewalls"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListFirewallsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListFirewalls-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and the number of rule groups, a single call might not return the full list.
     */
    override suspend fun listRuleGroups(input: ListRuleGroupsRequest): ListRuleGroupsResponse {
        val op = SdkHttpOperation.build<ListRuleGroupsRequest, ListRuleGroupsResponse> {
            serializer = ListRuleGroupsOperationSerializer()
            deserializer = ListRuleGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRuleGroups"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListRuleGroupsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListRuleGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTagsForResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource Access Manager (RAM) service to manage resource sharing for Network Firewall.
     *
     * Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy, you specify the accounts that you want to share the resource with and the operations that you want the accounts to be able to perform.
     *
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM) operations to access and accept the shared rule group or firewall policy.
     * + [GetResourceShareInvitations](https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html) - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * + [AcceptResourceShareInvitation](https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html) - Accepts the share invitation for a specified resource share.
     *
     * For additional information about resource sharing using RAM, see [Resource Access Manager User Guide](https://docs.aws.amazon.com/ram/latest/userguide/what-is.html).
     */
    override suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse {
        val op = SdkHttpOperation.build<PutResourcePolicyRequest, PutResourcePolicyResponse> {
            serializer = PutResourcePolicyOperationSerializer()
            deserializer = PutResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutResourcePolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutResourcePolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutResourcePolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modifies the flag, `DeleteProtection`, which indicates whether it is possible to delete the firewall. If the flag is set to `TRUE`, the firewall is protected against deletion. This setting helps protect against accidentally deleting a firewall that's in use.
     */
    override suspend fun updateFirewallDeleteProtection(input: UpdateFirewallDeleteProtectionRequest): UpdateFirewallDeleteProtectionResponse {
        val op = SdkHttpOperation.build<UpdateFirewallDeleteProtectionRequest, UpdateFirewallDeleteProtectionResponse> {
            serializer = UpdateFirewallDeleteProtectionOperationSerializer()
            deserializer = UpdateFirewallDeleteProtectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFirewallDeleteProtection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateFirewallDeleteProtectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFirewallDeleteProtection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when you're working with it.
     */
    override suspend fun updateFirewallDescription(input: UpdateFirewallDescriptionRequest): UpdateFirewallDescriptionResponse {
        val op = SdkHttpOperation.build<UpdateFirewallDescriptionRequest, UpdateFirewallDescriptionResponse> {
            serializer = UpdateFirewallDescriptionOperationSerializer()
            deserializer = UpdateFirewallDescriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFirewallDescription"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateFirewallDescriptionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFirewallDescription-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * A complex type that contains settings for encryption of your firewall resources.
     */
    override suspend fun updateFirewallEncryptionConfiguration(input: UpdateFirewallEncryptionConfigurationRequest): UpdateFirewallEncryptionConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateFirewallEncryptionConfigurationRequest, UpdateFirewallEncryptionConfigurationResponse> {
            serializer = UpdateFirewallEncryptionConfigurationOperationSerializer()
            deserializer = UpdateFirewallEncryptionConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFirewallEncryptionConfiguration"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateFirewallEncryptionConfigurationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFirewallEncryptionConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the properties of the specified firewall policy.
     */
    override suspend fun updateFirewallPolicy(input: UpdateFirewallPolicyRequest): UpdateFirewallPolicyResponse {
        val op = SdkHttpOperation.build<UpdateFirewallPolicyRequest, UpdateFirewallPolicyResponse> {
            serializer = UpdateFirewallPolicyOperationSerializer()
            deserializer = UpdateFirewallPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFirewallPolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateFirewallPolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFirewallPolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modifies the flag, `ChangeProtection`, which indicates whether it is possible to change the firewall. If the flag is set to `TRUE`, the firewall is protected from changes. This setting helps protect against accidentally changing a firewall that's in use.
     */
    override suspend fun updateFirewallPolicyChangeProtection(input: UpdateFirewallPolicyChangeProtectionRequest): UpdateFirewallPolicyChangeProtectionResponse {
        val op = SdkHttpOperation.build<UpdateFirewallPolicyChangeProtectionRequest, UpdateFirewallPolicyChangeProtectionResponse> {
            serializer = UpdateFirewallPolicyChangeProtectionOperationSerializer()
            deserializer = UpdateFirewallPolicyChangeProtectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFirewallPolicyChangeProtection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateFirewallPolicyChangeProtectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFirewallPolicyChangeProtection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sets the logging configuration for the specified firewall.
     *
     * To change the logging configuration, retrieve the LoggingConfiguration by calling DescribeLoggingConfiguration, then change it and provide the modified object to this update call. You must change the logging configuration one LogDestinationConfig at a time inside the retrieved LoggingConfiguration object.
     *
     * You can perform only one of the following actions in any call to `UpdateLoggingConfiguration`:
     * + Create a new log destination object by adding a single `LogDestinationConfig` array element to `LogDestinationConfigs`.
     * + Delete a log destination object by removing a single `LogDestinationConfig` array element from `LogDestinationConfigs`.
     * + Change the `LogDestination` setting in a single `LogDestinationConfig` array element.
     *
     * You can't change the `LogDestinationType` or `LogType` in a `LogDestinationConfig`. To change these settings, delete the existing `LogDestinationConfig` object and create a new one, using two separate calls to this update operation.
     */
    override suspend fun updateLoggingConfiguration(input: UpdateLoggingConfigurationRequest): UpdateLoggingConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateLoggingConfigurationRequest, UpdateLoggingConfigurationResponse> {
            serializer = UpdateLoggingConfigurationOperationSerializer()
            deserializer = UpdateLoggingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLoggingConfiguration"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateLoggingConfigurationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateLoggingConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     *
     * To update a rule group, first call DescribeRuleGroup to retrieve the current RuleGroup object, update the object as needed, and then provide the updated object to this call.
     */
    override suspend fun updateRuleGroup(input: UpdateRuleGroupRequest): UpdateRuleGroupResponse {
        val op = SdkHttpOperation.build<UpdateRuleGroupRequest, UpdateRuleGroupResponse> {
            serializer = UpdateRuleGroupOperationSerializer()
            deserializer = UpdateRuleGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRuleGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateRuleGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateRuleGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     *
     */
    override suspend fun updateSubnetChangeProtection(input: UpdateSubnetChangeProtectionRequest): UpdateSubnetChangeProtectionResponse {
        val op = SdkHttpOperation.build<UpdateSubnetChangeProtectionRequest, UpdateSubnetChangeProtectionResponse> {
            serializer = UpdateSubnetChangeProtectionOperationSerializer()
            deserializer = UpdateSubnetChangeProtectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSubnetChangeProtection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateSubnetChangeProtectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("NetworkFirewall_20201112", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "network-firewall"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateSubnetChangeProtection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "network-firewall")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
