// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.networkfirewall.model.NetworkFirewallException
import aws.sdk.kotlin.services.networkfirewall.model.RuleGroupResponse
import aws.sdk.kotlin.services.networkfirewall.model.UpdateRuleGroupResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateRuleGroupOperationDeserializer: HttpDeserialize<UpdateRuleGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateRuleGroupResponse {
        if (!response.status.isSuccess()) {
            throwUpdateRuleGroupError(context, response)
        }
        val builder = UpdateRuleGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateRuleGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateRuleGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw NetworkFirewallException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTokenException" -> InvalidTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> NetworkFirewallException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateRuleGroupOperationBody(builder: UpdateRuleGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RULEGROUPRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RuleGroupResponse"))
    val UPDATETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UpdateToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RULEGROUPRESPONSE_DESCRIPTOR)
        field(UPDATETOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RULEGROUPRESPONSE_DESCRIPTOR.index -> builder.ruleGroupResponse = deserializeRuleGroupResponseDocument(deserializer)
                UPDATETOKEN_DESCRIPTOR.index -> builder.updateToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
