// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * A single stateless rule. This is used in StatelessRulesAndCustomActions.
 */
public class StatelessRule private constructor(builder: Builder) {
    /**
     * Indicates the order in which to run this rule relative to all of the rules that are defined for a stateless rule group. Network Firewall evaluates the rules in a rule group starting with the lowest priority setting. You must ensure that the priority settings are unique for the rule group.
     *
     * Each stateless rule group uses exactly one `StatelessRulesAndCustomActions` object, and each `StatelessRulesAndCustomActions` contains exactly one `StatelessRules` object. To ensure unique priority settings for your rule groups, set unique priorities for the stateless rules that you define inside any single `StatelessRules` object.
     *
     * You can change the priority settings of your rules at any time. To make it easier to insert rules later, number them so there's a wide range in between, for example use 100, 200, and so on.
     */
    public val priority: kotlin.Int = builder.priority
    /**
     * Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the criteria.
     */
    public val ruleDefinition: aws.sdk.kotlin.services.networkfirewall.model.RuleDefinition? = builder.ruleDefinition

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.StatelessRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StatelessRule(")
        append("priority=$priority,")
        append("ruleDefinition=$ruleDefinition)")
    }

    override fun hashCode(): kotlin.Int {
        var result = priority
        result = 31 * result + (ruleDefinition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StatelessRule

        if (priority != other.priority) return false
        if (ruleDefinition != other.ruleDefinition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.StatelessRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates the order in which to run this rule relative to all of the rules that are defined for a stateless rule group. Network Firewall evaluates the rules in a rule group starting with the lowest priority setting. You must ensure that the priority settings are unique for the rule group.
         *
         * Each stateless rule group uses exactly one `StatelessRulesAndCustomActions` object, and each `StatelessRulesAndCustomActions` contains exactly one `StatelessRules` object. To ensure unique priority settings for your rule groups, set unique priorities for the stateless rules that you define inside any single `StatelessRules` object.
         *
         * You can change the priority settings of your rules at any time. To make it easier to insert rules later, number them so there's a wide range in between, for example use 100, 200, and so on.
         */
        public var priority: kotlin.Int = 0
        /**
         * Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the criteria.
         */
        public var ruleDefinition: aws.sdk.kotlin.services.networkfirewall.model.RuleDefinition? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.StatelessRule) : this() {
            this.priority = x.priority
            this.ruleDefinition = x.ruleDefinition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.StatelessRule = StatelessRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.RuleDefinition] inside the given [block]
         */
        public fun ruleDefinition(block: aws.sdk.kotlin.services.networkfirewall.model.RuleDefinition.Builder.() -> kotlin.Unit) {
            this.ruleDefinition = aws.sdk.kotlin.services.networkfirewall.model.RuleDefinition.invoke(block)
        }
    }
}
