// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Stateful inspection criteria for a domain list rule group.
 *
 * For HTTPS traffic, domain filtering is SNI-based. It uses the server name indicator extension of the TLS handshake.
 *
 * By default, Network Firewall domain list inspection only includes traffic coming from the VPC where you deploy the firewall. To inspect traffic from IP addresses outside of the deployment VPC, you set the `HOME_NET` rule variable to include the CIDR range of the deployment VPC plus the other CIDR ranges. For more information, see RuleVariables in this guide and [Stateful domain list rule groups in Network Firewall](https://docs.aws.amazon.com/network-firewall/latest/developerguide/stateful-rule-groups-domain-names.html) in the *Network Firewall Developer Guide*.
 */
public class RulesSourceList private constructor(builder: Builder) {
    /**
     * Whether you want to allow or deny access to the domains in your target list.
     */
    public val generatedRulesType: aws.sdk.kotlin.services.networkfirewall.model.GeneratedRulesType? = builder.generatedRulesType
    /**
     * The protocols you want to inspect. Specify `TLS_SNI` for `HTTPS`. Specify `HTTP_HOST` for `HTTP`. You can specify either or both.
     */
    public val targetTypes: List<TargetType>? = builder.targetTypes
    /**
     * The domains that you want to inspect for in your traffic flows. Valid domain specifications are the following:
     * + Explicit names. For example, `abc.example.com` matches only the domain `abc.example.com`.
     * + Names that use a domain wildcard, which you indicate with an initial '`.`'. For example,`.example.com` matches `example.com` and matches all subdomains of `example.com`, such as `abc.example.com` and `www.example.com`.
     */
    public val targets: List<String>? = builder.targets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.RulesSourceList = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RulesSourceList(")
        append("generatedRulesType=$generatedRulesType,")
        append("targetTypes=$targetTypes,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = generatedRulesType?.hashCode() ?: 0
        result = 31 * result + (targetTypes?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RulesSourceList

        if (generatedRulesType != other.generatedRulesType) return false
        if (targetTypes != other.targetTypes) return false
        if (targets != other.targets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.RulesSourceList = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether you want to allow or deny access to the domains in your target list.
         */
        public var generatedRulesType: aws.sdk.kotlin.services.networkfirewall.model.GeneratedRulesType? = null
        /**
         * The protocols you want to inspect. Specify `TLS_SNI` for `HTTPS`. Specify `HTTP_HOST` for `HTTP`. You can specify either or both.
         */
        public var targetTypes: List<TargetType>? = null
        /**
         * The domains that you want to inspect for in your traffic flows. Valid domain specifications are the following:
         * + Explicit names. For example, `abc.example.com` matches only the domain `abc.example.com`.
         * + Names that use a domain wildcard, which you indicate with an initial '`.`'. For example,`.example.com` matches `example.com` and matches all subdomains of `example.com`, such as `abc.example.com` and `www.example.com`.
         */
        public var targets: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.RulesSourceList) : this() {
            this.generatedRulesType = x.generatedRulesType
            this.targetTypes = x.targetTypes
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.RulesSourceList = RulesSourceList(this)
    }
}
