// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Configures one or more IP set references for a Suricata-compatible rule group. This is used in CreateRuleGroup or UpdateRuleGroup. An IP set reference is a rule variable that references a resource that you create and manage in another Amazon Web Services service, such as an Amazon VPC prefix list. Network Firewall IP set references enable you to dynamically update the contents of your rules. When you create, update, or delete the IP set you are referencing in your rule, Network Firewall automatically updates the rule's content with the changes. For more information about IP set references in Network Firewall, see [Using IP set references](https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references) in the *Network Firewall Developer Guide*.
 *
 *  Network Firewall currently supports only [Amazon VPC prefix lists](https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html) as IP set references.
 */
public class IpSetReference private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
     */
    public val referenceArn: kotlin.String? = builder.referenceArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.IpSetReference = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpSetReference(")
        append("referenceArn=$referenceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = referenceArn?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpSetReference

        if (referenceArn != other.referenceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.IpSetReference = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
         */
        public var referenceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.IpSetReference) : this() {
            this.referenceArn = x.referenceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.IpSetReference = IpSetReference(this)
    }
}
