// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The high-level properties of a firewall policy. This, along with the FirewallPolicy, define the policy. You can retrieve all objects for a firewall policy by calling DescribeFirewallPolicy.
 */
public class FirewallPolicyResponse private constructor(builder: Builder) {
    /**
     * The number of capacity units currently consumed by the policy's stateful rules.
     */
    public val consumedStatefulRuleCapacity: kotlin.Int? = builder.consumedStatefulRuleCapacity
    /**
     * The number of capacity units currently consumed by the policy's stateless rules.
     */
    public val consumedStatelessRuleCapacity: kotlin.Int? = builder.consumedStatelessRuleCapacity
    /**
     * A description of the firewall policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your firewall policy.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The Amazon Resource Name (ARN) of the firewall policy.
     *
     * If this response is for a create request that had `DryRun` set to `TRUE`, then this ARN is a placeholder that isn't attached to a valid resource.
     */
    public val firewallPolicyArn: kotlin.String? = builder.firewallPolicyArn
    /**
     * The unique identifier for the firewall policy.
     */
    public val firewallPolicyId: kotlin.String? = builder.firewallPolicyId
    /**
     * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
     */
    public val firewallPolicyName: kotlin.String? = builder.firewallPolicyName
    /**
     * The current status of the firewall policy. You can retrieve this for a firewall policy by calling DescribeFirewallPolicy and providing the firewall policy's name or ARN.
     */
    public val firewallPolicyStatus: aws.sdk.kotlin.services.networkfirewall.model.ResourceStatus? = builder.firewallPolicyStatus
    /**
     * The last time that the firewall policy was changed.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The number of firewalls that are associated with this firewall policy.
     */
    public val numberOfAssociations: kotlin.Int? = builder.numberOfAssociations
    /**
     * The key:value pairs to associate with the resource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallPolicyResponse(")
        append("consumedStatefulRuleCapacity=$consumedStatefulRuleCapacity,")
        append("consumedStatelessRuleCapacity=$consumedStatelessRuleCapacity,")
        append("description=$description,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("firewallPolicyArn=$firewallPolicyArn,")
        append("firewallPolicyId=$firewallPolicyId,")
        append("firewallPolicyName=$firewallPolicyName,")
        append("firewallPolicyStatus=$firewallPolicyStatus,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("numberOfAssociations=$numberOfAssociations,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumedStatefulRuleCapacity ?: 0
        result = 31 * result + (consumedStatelessRuleCapacity ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyArn?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyId?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyName?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyStatus?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (numberOfAssociations ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallPolicyResponse

        if (consumedStatefulRuleCapacity != other.consumedStatefulRuleCapacity) return false
        if (consumedStatelessRuleCapacity != other.consumedStatelessRuleCapacity) return false
        if (description != other.description) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (firewallPolicyArn != other.firewallPolicyArn) return false
        if (firewallPolicyId != other.firewallPolicyId) return false
        if (firewallPolicyName != other.firewallPolicyName) return false
        if (firewallPolicyStatus != other.firewallPolicyStatus) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (numberOfAssociations != other.numberOfAssociations) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicyResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of capacity units currently consumed by the policy's stateful rules.
         */
        public var consumedStatefulRuleCapacity: kotlin.Int? = null
        /**
         * The number of capacity units currently consumed by the policy's stateless rules.
         */
        public var consumedStatelessRuleCapacity: kotlin.Int? = null
        /**
         * A description of the firewall policy.
         */
        public var description: kotlin.String? = null
        /**
         * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your firewall policy.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the firewall policy.
         *
         * If this response is for a create request that had `DryRun` set to `TRUE`, then this ARN is a placeholder that isn't attached to a valid resource.
         */
        public var firewallPolicyArn: kotlin.String? = null
        /**
         * The unique identifier for the firewall policy.
         */
        public var firewallPolicyId: kotlin.String? = null
        /**
         * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
         */
        public var firewallPolicyName: kotlin.String? = null
        /**
         * The current status of the firewall policy. You can retrieve this for a firewall policy by calling DescribeFirewallPolicy and providing the firewall policy's name or ARN.
         */
        public var firewallPolicyStatus: aws.sdk.kotlin.services.networkfirewall.model.ResourceStatus? = null
        /**
         * The last time that the firewall policy was changed.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of firewalls that are associated with this firewall policy.
         */
        public var numberOfAssociations: kotlin.Int? = null
        /**
         * The key:value pairs to associate with the resource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicyResponse) : this() {
            this.consumedStatefulRuleCapacity = x.consumedStatefulRuleCapacity
            this.consumedStatelessRuleCapacity = x.consumedStatelessRuleCapacity
            this.description = x.description
            this.encryptionConfiguration = x.encryptionConfiguration
            this.firewallPolicyArn = x.firewallPolicyArn
            this.firewallPolicyId = x.firewallPolicyId
            this.firewallPolicyName = x.firewallPolicyName
            this.firewallPolicyStatus = x.firewallPolicyStatus
            this.lastModifiedTime = x.lastModifiedTime
            this.numberOfAssociations = x.numberOfAssociations
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicyResponse = FirewallPolicyResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.invoke(block)
        }
    }
}
