// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * The firewall defines the configuration settings for an Network Firewall firewall. These settings include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall Amazon Web Services resource.
 *
 * The status of the firewall, for example whether it's ready to filter network traffic, is provided in the corresponding FirewallStatus. You can retrieve both objects by calling DescribeFirewall.
 */
public class Firewall private constructor(builder: Builder) {
    /**
     * A flag indicating whether it is possible to delete the firewall. A setting of `TRUE` indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to `TRUE`.
     */
    public val deleteProtection: kotlin.Boolean? = builder.deleteProtection
    /**
     * A description of the firewall.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your firewall.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The Amazon Resource Name (ARN) of the firewall.
     */
    public val firewallArn: kotlin.String? = builder.firewallArn
    /**
     * The unique identifier for the firewall.
     */
    public val firewallId: kotlin.String? = builder.firewallId
    /**
     * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
     */
    public val firewallName: kotlin.String? = builder.firewallName
    /**
     * The Amazon Resource Name (ARN) of the firewall policy.
     *
     * The relationship of firewall to firewall policy is many to one. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
     */
    public val firewallPolicyArn: kotlin.String? = builder.firewallPolicyArn
    /**
     * A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE`.
     */
    public val firewallPolicyChangeProtection: kotlin.Boolean? = builder.firewallPolicyChangeProtection
    /**
     * A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE`.
     */
    public val subnetChangeProtection: kotlin.Boolean? = builder.subnetChangeProtection
    /**
     * The public subnets that Network Firewall is using for the firewall. Each subnet must belong to a different Availability Zone.
     */
    public val subnetMappings: List<SubnetMapping>? = builder.subnetMappings
    /**
     *
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The unique identifier of the VPC where the firewall is in use.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.Firewall = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Firewall(")
        append("deleteProtection=$deleteProtection,")
        append("description=$description,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("firewallArn=$firewallArn,")
        append("firewallId=$firewallId,")
        append("firewallName=$firewallName,")
        append("firewallPolicyArn=$firewallPolicyArn,")
        append("firewallPolicyChangeProtection=$firewallPolicyChangeProtection,")
        append("subnetChangeProtection=$subnetChangeProtection,")
        append("subnetMappings=$subnetMappings,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteProtection?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (firewallArn?.hashCode() ?: 0)
        result = 31 * result + (firewallId?.hashCode() ?: 0)
        result = 31 * result + (firewallName?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyArn?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyChangeProtection?.hashCode() ?: 0)
        result = 31 * result + (subnetChangeProtection?.hashCode() ?: 0)
        result = 31 * result + (subnetMappings?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Firewall

        if (deleteProtection != other.deleteProtection) return false
        if (description != other.description) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (firewallArn != other.firewallArn) return false
        if (firewallId != other.firewallId) return false
        if (firewallName != other.firewallName) return false
        if (firewallPolicyArn != other.firewallPolicyArn) return false
        if (firewallPolicyChangeProtection != other.firewallPolicyChangeProtection) return false
        if (subnetChangeProtection != other.subnetChangeProtection) return false
        if (subnetMappings != other.subnetMappings) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.Firewall = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A flag indicating whether it is possible to delete the firewall. A setting of `TRUE` indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to `TRUE`.
         */
        public var deleteProtection: kotlin.Boolean? = null
        /**
         * A description of the firewall.
         */
        public var description: kotlin.String? = null
        /**
         * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your firewall.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the firewall.
         */
        public var firewallArn: kotlin.String? = null
        /**
         * The unique identifier for the firewall.
         */
        public var firewallId: kotlin.String? = null
        /**
         * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
         */
        public var firewallName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the firewall policy.
         *
         * The relationship of firewall to firewall policy is many to one. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
         */
        public var firewallPolicyArn: kotlin.String? = null
        /**
         * A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE`.
         */
        public var firewallPolicyChangeProtection: kotlin.Boolean? = null
        /**
         * A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE`.
         */
        public var subnetChangeProtection: kotlin.Boolean? = null
        /**
         * The public subnets that Network Firewall is using for the firewall. Each subnet must belong to a different Availability Zone.
         */
        public var subnetMappings: List<SubnetMapping>? = null
        /**
         *
         */
        public var tags: List<Tag>? = null
        /**
         * The unique identifier of the VPC where the firewall is in use.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.Firewall) : this() {
            this.deleteProtection = x.deleteProtection
            this.description = x.description
            this.encryptionConfiguration = x.encryptionConfiguration
            this.firewallArn = x.firewallArn
            this.firewallId = x.firewallId
            this.firewallName = x.firewallName
            this.firewallPolicyArn = x.firewallPolicyArn
            this.firewallPolicyChangeProtection = x.firewallPolicyChangeProtection
            this.subnetChangeProtection = x.subnetChangeProtection
            this.subnetMappings = x.subnetMappings
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.Firewall = Firewall(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.invoke(block)
        }
    }
}
