// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.waiters

import aws.sdk.kotlin.services.neptunegraph.NeptuneGraphClient
import aws.sdk.kotlin.services.neptunegraph.model.GetGraphRequest
import aws.sdk.kotlin.services.neptunegraph.model.GetGraphResponse
import aws.sdk.kotlin.services.neptunegraph.model.GetGraphSnapshotRequest
import aws.sdk.kotlin.services.neptunegraph.model.GetGraphSnapshotResponse
import aws.sdk.kotlin.services.neptunegraph.model.GetImportTaskRequest
import aws.sdk.kotlin.services.neptunegraph.model.GetImportTaskResponse
import aws.sdk.kotlin.services.neptunegraph.model.GetPrivateGraphEndpointRequest
import aws.sdk.kotlin.services.neptunegraph.model.GetPrivateGraphEndpointResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.truthiness
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until Graph is Available
 */
public suspend fun NeptuneGraphClient.waitUntilGraphAvailable(request: GetGraphRequest): Outcome<GetGraphResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 28_800_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetGraphRequest, GetGraphResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "DELETING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "AVAILABLE"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getGraph(request) }
}

/**
 * Wait until Graph is Available
 */
public suspend fun NeptuneGraphClient.waitUntilGraphAvailable(block: GetGraphRequest.Builder.() -> Unit): Outcome<GetGraphResponse> =
    waitUntilGraphAvailable(GetGraphRequest.Builder().apply(block).build())

/**
 * Wait until Graph is Deleted
 */
public suspend fun NeptuneGraphClient.waitUntilGraphDeleted(request: GetGraphRequest): Outcome<GetGraphResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 3_600_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetGraphRequest, GetGraphResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            val string = "DELETING"
            val comparison = if (status == null) null else status.compareTo(string) != 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getGraph(request) }
}

/**
 * Wait until Graph is Deleted
 */
public suspend fun NeptuneGraphClient.waitUntilGraphDeleted(block: GetGraphRequest.Builder.() -> Unit): Outcome<GetGraphResponse> =
    waitUntilGraphDeleted(GetGraphRequest.Builder().apply(block).build())

/**
 * Wait until GraphSnapshot is Available
 */
public suspend fun NeptuneGraphClient.waitUntilGraphSnapshotAvailable(request: GetGraphSnapshotRequest): Outcome<GetGraphSnapshotResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 7_200_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetGraphSnapshotRequest, GetGraphSnapshotResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "DELETING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "AVAILABLE"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getGraphSnapshot(request) }
}

/**
 * Wait until GraphSnapshot is Available
 */
public suspend fun NeptuneGraphClient.waitUntilGraphSnapshotAvailable(block: GetGraphSnapshotRequest.Builder.() -> Unit): Outcome<GetGraphSnapshotResponse> =
    waitUntilGraphSnapshotAvailable(GetGraphSnapshotRequest.Builder().apply(block).build())

/**
 * Wait until GraphSnapshot is Deleted
 */
public suspend fun NeptuneGraphClient.waitUntilGraphSnapshotDeleted(request: GetGraphSnapshotRequest): Outcome<GetGraphSnapshotResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 3_600_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetGraphSnapshotRequest, GetGraphSnapshotResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            val string = "DELETING"
            val comparison = if (status == null) null else status.compareTo(string) != 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getGraphSnapshot(request) }
}

/**
 * Wait until GraphSnapshot is Deleted
 */
public suspend fun NeptuneGraphClient.waitUntilGraphSnapshotDeleted(block: GetGraphSnapshotRequest.Builder.() -> Unit): Outcome<GetGraphSnapshotResponse> =
    waitUntilGraphSnapshotDeleted(GetGraphSnapshotRequest.Builder().apply(block).build())

/**
 * Wait until Import Task is Successful
 */
public suspend fun NeptuneGraphClient.waitUntilImportTaskSuccessful(request: GetImportTaskRequest): Outcome<GetImportTaskResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 28_800_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetImportTaskRequest, GetImportTaskResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "CANCELLING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "CANCELLED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "ROLLING_BACK"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "SUCCEEDED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getImportTask(request) }
}

/**
 * Wait until Import Task is Successful
 */
public suspend fun NeptuneGraphClient.waitUntilImportTaskSuccessful(block: GetImportTaskRequest.Builder.() -> Unit): Outcome<GetImportTaskResponse> =
    waitUntilImportTaskSuccessful(GetImportTaskRequest.Builder().apply(block).build())

/**
 * Wait until Import Task is Cancelled
 */
public suspend fun NeptuneGraphClient.waitUntilImportTaskCancelled(request: GetImportTaskRequest): Outcome<GetImportTaskResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 60_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 3_600_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetImportTaskRequest, GetImportTaskResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            val string = "CANCELLING"
            val comparison = if (status == null) null else status.compareTo(string) != 0
            val comparisonTruthiness = truthiness(comparison)
            val status2 = it.status?.value
            val string2 = "CANCELLED"
            val comparison2 = if (status2 == null) null else status2.compareTo(string2) != 0
            val and = if (comparisonTruthiness) comparison2 else comparison
            and == true
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "CANCELLED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getImportTask(request) }
}

/**
 * Wait until Import Task is Cancelled
 */
public suspend fun NeptuneGraphClient.waitUntilImportTaskCancelled(block: GetImportTaskRequest.Builder.() -> Unit): Outcome<GetImportTaskResponse> =
    waitUntilImportTaskCancelled(GetImportTaskRequest.Builder().apply(block).build())

/**
 * Wait until PrivateGraphEndpoint is Available
 */
public suspend fun NeptuneGraphClient.waitUntilPrivateGraphEndpointAvailable(request: GetPrivateGraphEndpointRequest): Outcome<GetPrivateGraphEndpointResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 10_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 1_800_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetPrivateGraphEndpointRequest, GetPrivateGraphEndpointResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "DELETING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "AVAILABLE"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getPrivateGraphEndpoint(request) }
}

/**
 * Wait until PrivateGraphEndpoint is Available
 */
public suspend fun NeptuneGraphClient.waitUntilPrivateGraphEndpointAvailable(block: GetPrivateGraphEndpointRequest.Builder.() -> Unit): Outcome<GetPrivateGraphEndpointResponse> =
    waitUntilPrivateGraphEndpointAvailable(GetPrivateGraphEndpointRequest.Builder().apply(block).build())

/**
 * Wait until PrivateGraphEndpoint is Deleted
 */
public suspend fun NeptuneGraphClient.waitUntilPrivateGraphEndpointDeleted(request: GetPrivateGraphEndpointRequest): Outcome<GetPrivateGraphEndpointResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 10_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 1_800_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetPrivateGraphEndpointRequest, GetPrivateGraphEndpointResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            val string = "DELETING"
            val comparison = if (status == null) null else status.compareTo(string) != 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getPrivateGraphEndpoint(request) }
}

/**
 * Wait until PrivateGraphEndpoint is Deleted
 */
public suspend fun NeptuneGraphClient.waitUntilPrivateGraphEndpointDeleted(block: GetPrivateGraphEndpointRequest.Builder.() -> Unit): Outcome<GetPrivateGraphEndpointResponse> =
    waitUntilPrivateGraphEndpointDeleted(GetPrivateGraphEndpointRequest.Builder().apply(block).build())
