// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.serde

import aws.sdk.kotlin.services.neptunegraph.model.BlankNodeHandling
import aws.sdk.kotlin.services.neptunegraph.model.Format
import aws.sdk.kotlin.services.neptunegraph.model.ImportOptions
import aws.sdk.kotlin.services.neptunegraph.model.StartImportTaskRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class StartImportTaskOperationSerializer: HttpSerializer.NonStreaming<StartImportTaskRequest> {
    override fun serialize(context: ExecutionContext, input: StartImportTaskRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.graphIdentifier) { "graphIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("graphs"))
                add(PercentEncoding.SmithyLabel.encode(input.graphIdentifier))
                add(PercentEncoding.Path.encode("importtasks"))
            }
        }

        val payload = serializeStartImportTaskOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartImportTaskOperationBody(context: ExecutionContext, input: StartImportTaskRequest): ByteArray {
    val serializer = JsonSerializer()
    val BLANKNODEHANDLING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("blankNodeHandling"))
    val FAILONERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("failOnError"))
    val FORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("format"))
    val IMPORTOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("importOptions"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("source"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLANKNODEHANDLING_DESCRIPTOR)
        field(FAILONERROR_DESCRIPTOR)
        field(FORMAT_DESCRIPTOR)
        field(IMPORTOPTIONS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.blankNodeHandling?.let { field(BLANKNODEHANDLING_DESCRIPTOR, it.value) }
        input.failOnError?.let { field(FAILONERROR_DESCRIPTOR, it) }
        input.format?.let { field(FORMAT_DESCRIPTOR, it.value) }
        input.importOptions?.let { field(IMPORTOPTIONS_DESCRIPTOR, it, ::serializeImportOptionsDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.source?.let { field(SOURCE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
