// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.paginators

import aws.sdk.kotlin.services.neptunegraph.NeptuneGraphClient
import aws.sdk.kotlin.services.neptunegraph.model.GraphSnapshotSummary
import aws.sdk.kotlin.services.neptunegraph.model.GraphSummary
import aws.sdk.kotlin.services.neptunegraph.model.ImportTaskSummary
import aws.sdk.kotlin.services.neptunegraph.model.ListGraphSnapshotsRequest
import aws.sdk.kotlin.services.neptunegraph.model.ListGraphSnapshotsResponse
import aws.sdk.kotlin.services.neptunegraph.model.ListGraphsRequest
import aws.sdk.kotlin.services.neptunegraph.model.ListGraphsResponse
import aws.sdk.kotlin.services.neptunegraph.model.ListImportTasksRequest
import aws.sdk.kotlin.services.neptunegraph.model.ListImportTasksResponse
import aws.sdk.kotlin.services.neptunegraph.model.ListPrivateGraphEndpointsRequest
import aws.sdk.kotlin.services.neptunegraph.model.ListPrivateGraphEndpointsResponse
import aws.sdk.kotlin.services.neptunegraph.model.PrivateGraphEndpointSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListGraphsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGraphsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGraphsResponse]
 */
public fun NeptuneGraphClient.listGraphsPaginated(initialRequest: ListGraphsRequest = ListGraphsRequest { }): Flow<ListGraphsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGraphsPaginated.listGraphs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGraphsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGraphsResponse]
 */
public fun NeptuneGraphClient.listGraphsPaginated(block: ListGraphsRequest.Builder.() -> Unit): Flow<ListGraphsResponse> =
    listGraphsPaginated(ListGraphsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGraphsPaginated]
 * to access the nested member [GraphSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GraphSummary]
 */
@JvmName("listGraphsResponseGraphSummary")
public fun Flow<ListGraphsResponse>.graphs(): Flow<GraphSummary> =
    transform() { response ->
        response.graphs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGraphSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGraphSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGraphSnapshotsResponse]
 */
public fun NeptuneGraphClient.listGraphSnapshotsPaginated(initialRequest: ListGraphSnapshotsRequest = ListGraphSnapshotsRequest { }): Flow<ListGraphSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGraphSnapshotsPaginated.listGraphSnapshots(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGraphSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGraphSnapshotsResponse]
 */
public fun NeptuneGraphClient.listGraphSnapshotsPaginated(block: ListGraphSnapshotsRequest.Builder.() -> Unit): Flow<ListGraphSnapshotsResponse> =
    listGraphSnapshotsPaginated(ListGraphSnapshotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGraphSnapshotsPaginated]
 * to access the nested member [GraphSnapshotSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GraphSnapshotSummary]
 */
@JvmName("listGraphSnapshotsResponseGraphSnapshotSummary")
public fun Flow<ListGraphSnapshotsResponse>.graphSnapshots(): Flow<GraphSnapshotSummary> =
    transform() { response ->
        response.graphSnapshots?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImportTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImportTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportTasksResponse]
 */
public fun NeptuneGraphClient.listImportTasksPaginated(initialRequest: ListImportTasksRequest = ListImportTasksRequest { }): Flow<ListImportTasksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImportTasksPaginated.listImportTasks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImportTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportTasksResponse]
 */
public fun NeptuneGraphClient.listImportTasksPaginated(block: ListImportTasksRequest.Builder.() -> Unit): Flow<ListImportTasksResponse> =
    listImportTasksPaginated(ListImportTasksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImportTasksPaginated]
 * to access the nested member [ImportTaskSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImportTaskSummary]
 */
@JvmName("listImportTasksResponseImportTaskSummary")
public fun Flow<ListImportTasksResponse>.tasks(): Flow<ImportTaskSummary> =
    transform() { response ->
        response.tasks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPrivateGraphEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPrivateGraphEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPrivateGraphEndpointsResponse]
 */
public fun NeptuneGraphClient.listPrivateGraphEndpointsPaginated(initialRequest: ListPrivateGraphEndpointsRequest): Flow<ListPrivateGraphEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPrivateGraphEndpointsPaginated.listPrivateGraphEndpoints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPrivateGraphEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPrivateGraphEndpointsResponse]
 */
public fun NeptuneGraphClient.listPrivateGraphEndpointsPaginated(block: ListPrivateGraphEndpointsRequest.Builder.() -> Unit): Flow<ListPrivateGraphEndpointsResponse> =
    listPrivateGraphEndpointsPaginated(ListPrivateGraphEndpointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPrivateGraphEndpointsPaginated]
 * to access the nested member [PrivateGraphEndpointSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PrivateGraphEndpointSummary]
 */
@JvmName("listPrivateGraphEndpointsResponsePrivateGraphEndpointSummary")
public fun Flow<ListPrivateGraphEndpointsResponse>.privateGraphEndpoints(): Flow<PrivateGraphEndpointSummary> =
    transform() { response ->
        response.privateGraphEndpoints?.forEach {
            emit(it)
        }
    }
