// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about a private graph endpoint.
 */
public class PrivateGraphEndpointSummary private constructor(builder: Builder) {
    /**
     * The status of the private graph endpoint.
     */
    public val status: aws.sdk.kotlin.services.neptunegraph.model.PrivateGraphEndpointStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The subnet IDs associated with the private graph endpoint.
     */
    public val subnetIds: List<String> = requireNotNull(builder.subnetIds) { "A non-null value must be provided for subnetIds" }
    /**
     * The ID of the VPC endpoint.
     */
    public val vpcEndpointId: kotlin.String? = builder.vpcEndpointId
    /**
     * The ID of the VPC in which the private graph endpoint is located.
     */
    public val vpcId: kotlin.String = requireNotNull(builder.vpcId) { "A non-null value must be provided for vpcId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.PrivateGraphEndpointSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PrivateGraphEndpointSummary(")
        append("status=$status,")
        append("subnetIds=$subnetIds,")
        append("vpcEndpointId=$vpcEndpointId,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = status.hashCode()
        result = 31 * result + (subnetIds.hashCode())
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        result = 31 * result + (vpcId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PrivateGraphEndpointSummary

        if (status != other.status) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcEndpointId != other.vpcEndpointId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.PrivateGraphEndpointSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The status of the private graph endpoint.
         */
        public var status: aws.sdk.kotlin.services.neptunegraph.model.PrivateGraphEndpointStatus? = null
        /**
         * The subnet IDs associated with the private graph endpoint.
         */
        public var subnetIds: List<String>? = null
        /**
         * The ID of the VPC endpoint.
         */
        public var vpcEndpointId: kotlin.String? = null
        /**
         * The ID of the VPC in which the private graph endpoint is located.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.PrivateGraphEndpointSummary) : this() {
            this.status = x.status
            this.subnetIds = x.subnetIds
            this.vpcEndpointId = x.vpcEndpointId
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.PrivateGraphEndpointSummary = PrivateGraphEndpointSummary(this)

        internal fun correctErrors(): Builder {
            if (status == null) status = PrivateGraphEndpointStatus.SdkUnknown("no value provided")
            if (subnetIds == null) subnetIds = emptyList()
            if (vpcId == null) vpcId = ""
            return this
        }
    }
}
