// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about an import task.
 */
public class ImportTaskSummary private constructor(builder: Builder) {
    /**
     * Specifies the format of S3 data to be imported. Valid values are `CSV`, which identifies the [Gremlin CSV format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html) or `OPENCYPHER`, which identies the [openCypher load format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html).
     */
    public val format: aws.sdk.kotlin.services.neptunegraph.model.Format? = builder.format
    /**
     * The unique identifier of the Neptune Analytics graph.
     */
    public val graphId: kotlin.String? = builder.graphId
    /**
     * The ARN of the IAM role that will allow access to the data that is to be imported.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * A URL identifying to the location of the data to be imported. This can be an Amazon S3 path, or can point to a Neptune database endpoint or snapshot
     */
    public val source: kotlin.String = requireNotNull(builder.source) { "A non-null value must be provided for source" }
    /**
     * Status of the import task.
     */
    public val status: aws.sdk.kotlin.services.neptunegraph.model.ImportTaskStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The unique identifier of the import task.
     */
    public val taskId: kotlin.String = requireNotNull(builder.taskId) { "A non-null value must be provided for taskId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.ImportTaskSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportTaskSummary(")
        append("format=$format,")
        append("graphId=$graphId,")
        append("roleArn=$roleArn,")
        append("source=$source,")
        append("status=$status,")
        append("taskId=$taskId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = format?.hashCode() ?: 0
        result = 31 * result + (graphId?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (source.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (taskId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportTaskSummary

        if (format != other.format) return false
        if (graphId != other.graphId) return false
        if (roleArn != other.roleArn) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (taskId != other.taskId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.ImportTaskSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the format of S3 data to be imported. Valid values are `CSV`, which identifies the [Gremlin CSV format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html) or `OPENCYPHER`, which identies the [openCypher load format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html).
         */
        public var format: aws.sdk.kotlin.services.neptunegraph.model.Format? = null
        /**
         * The unique identifier of the Neptune Analytics graph.
         */
        public var graphId: kotlin.String? = null
        /**
         * The ARN of the IAM role that will allow access to the data that is to be imported.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A URL identifying to the location of the data to be imported. This can be an Amazon S3 path, or can point to a Neptune database endpoint or snapshot
         */
        public var source: kotlin.String? = null
        /**
         * Status of the import task.
         */
        public var status: aws.sdk.kotlin.services.neptunegraph.model.ImportTaskStatus? = null
        /**
         * The unique identifier of the import task.
         */
        public var taskId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.ImportTaskSummary) : this() {
            this.format = x.format
            this.graphId = x.graphId
            this.roleArn = x.roleArn
            this.source = x.source
            this.status = x.status
            this.taskId = x.taskId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.ImportTaskSummary = ImportTaskSummary(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (source == null) source = ""
            if (status == null) status = ImportTaskStatus.SdkUnknown("no value provided")
            if (taskId == null) taskId = ""
            return this
        }
    }
}
