// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about an import task.
 */
public class ImportTaskDetails private constructor(builder: Builder) {
    /**
     * The number of dictionary entries in the import task.
     */
    public val dictionaryEntryCount: kotlin.Long = requireNotNull(builder.dictionaryEntryCount) { "A non-null value must be provided for dictionaryEntryCount" }
    /**
     * The number of errors encountered so far.
     */
    public val errorCount: kotlin.Int = requireNotNull(builder.errorCount) { "A non-null value must be provided for errorCount" }
    /**
     * Details about the errors that have been encountered.
     */
    public val errorDetails: kotlin.String? = builder.errorDetails
    /**
     * The percentage progress so far.
     */
    public val progressPercentage: kotlin.Int = requireNotNull(builder.progressPercentage) { "A non-null value must be provided for progressPercentage" }
    /**
     * Time at which the import task started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The number of statements in the import task.
     */
    public val statementCount: kotlin.Long = requireNotNull(builder.statementCount) { "A non-null value must be provided for statementCount" }
    /**
     * Status of the import task.
     */
    public val status: kotlin.String = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Seconds elapsed since the import task started.
     */
    public val timeElapsedSeconds: kotlin.Long = requireNotNull(builder.timeElapsedSeconds) { "A non-null value must be provided for timeElapsedSeconds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.ImportTaskDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportTaskDetails(")
        append("dictionaryEntryCount=$dictionaryEntryCount,")
        append("errorCount=$errorCount,")
        append("errorDetails=$errorDetails,")
        append("progressPercentage=$progressPercentage,")
        append("startTime=$startTime,")
        append("statementCount=$statementCount,")
        append("status=$status,")
        append("timeElapsedSeconds=$timeElapsedSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dictionaryEntryCount.hashCode()
        result = 31 * result + (errorCount)
        result = 31 * result + (errorDetails?.hashCode() ?: 0)
        result = 31 * result + (progressPercentage)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (statementCount.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (timeElapsedSeconds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportTaskDetails

        if (dictionaryEntryCount != other.dictionaryEntryCount) return false
        if (errorCount != other.errorCount) return false
        if (errorDetails != other.errorDetails) return false
        if (progressPercentage != other.progressPercentage) return false
        if (startTime != other.startTime) return false
        if (statementCount != other.statementCount) return false
        if (status != other.status) return false
        if (timeElapsedSeconds != other.timeElapsedSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.ImportTaskDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of dictionary entries in the import task.
         */
        public var dictionaryEntryCount: kotlin.Long? = null
        /**
         * The number of errors encountered so far.
         */
        public var errorCount: kotlin.Int? = null
        /**
         * Details about the errors that have been encountered.
         */
        public var errorDetails: kotlin.String? = null
        /**
         * The percentage progress so far.
         */
        public var progressPercentage: kotlin.Int? = null
        /**
         * Time at which the import task started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of statements in the import task.
         */
        public var statementCount: kotlin.Long? = null
        /**
         * Status of the import task.
         */
        public var status: kotlin.String? = null
        /**
         * Seconds elapsed since the import task started.
         */
        public var timeElapsedSeconds: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.ImportTaskDetails) : this() {
            this.dictionaryEntryCount = x.dictionaryEntryCount
            this.errorCount = x.errorCount
            this.errorDetails = x.errorDetails
            this.progressPercentage = x.progressPercentage
            this.startTime = x.startTime
            this.statementCount = x.statementCount
            this.status = x.status
            this.timeElapsedSeconds = x.timeElapsedSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.ImportTaskDetails = ImportTaskDetails(this)

        internal fun correctErrors(): Builder {
            if (dictionaryEntryCount == null) dictionaryEntryCount = 0L
            if (errorCount == null) errorCount = 0
            if (progressPercentage == null) progressPercentage = 0
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (statementCount == null) statementCount = 0L
            if (status == null) status = ""
            if (timeElapsedSeconds == null) timeElapsedSeconds = 0L
            return this
        }
    }
}
