// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetImportTaskResponse private constructor(builder: Builder) {
    /**
     * The number of the current attempt to execute the import task.
     */
    public val attemptNumber: kotlin.Int? = builder.attemptNumber
    /**
     * Specifies the format of S3 data to be imported. Valid values are `CSV`, which identifies the [Gremlin CSV format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html) or `OPENCYPHER`, which identies the [openCypher load format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html).
     */
    public val format: aws.sdk.kotlin.services.neptunegraph.model.Format? = builder.format
    /**
     * The unique identifier of the Neptune Analytics graph.
     */
    public val graphId: kotlin.String? = builder.graphId
    /**
     * Contains options for controlling the import process. For example, if the `failOnError` key is set to `false`, the import skips problem data and attempts to continue (whereas if set to `true`, the default, or if omitted, the import operation halts immediately when an error is encountered.
     */
    public val importOptions: aws.sdk.kotlin.services.neptunegraph.model.ImportOptions? = builder.importOptions
    /**
     * Contains details about the specified import task.
     */
    public val importTaskDetails: aws.sdk.kotlin.services.neptunegraph.model.ImportTaskDetails? = builder.importTaskDetails
    /**
     * The ARN of the IAM role that will allow access to the data that is to be imported.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * A URL identifying to the location of the data to be imported. This can be an Amazon S3 path, or can point to a Neptune database endpoint or snapshot
     */
    public val source: kotlin.String = requireNotNull(builder.source) { "A non-null value must be provided for source" }
    /**
     * The status of the import task:
     * + **INITIALIZING** – The necessary resources needed to create the graph are being prepared.
     * + **ANALYZING_DATA** – The data is being analyzed to determine the optimal infrastructure configuration for the new graph.
     * + **RE_PROVISIONING** – The data did not fit into the provisioned graph, so it is being re-provisioned with more capacity.
     * + **IMPORTING** – The data is being loaded.
     * + **ERROR_ENCOUNTERED** – An error has been encountered while trying to create the graph and import the data.
     * + **ERROR_ENCOUNTERED_ROLLING_BACK** – Because of the error that was encountered, the graph is being rolled back and all its resources released.
     * + **SUCCEEDED** – Graph creation and data loading succeeded.
     * + **FAILED** – Graph creation or data loading failed. When the status is `FAILED`, you can use `get-graphs` to get more information about the state of the graph.
     * + **CANCELLING** – Because you cancelled the import task, cancellation is in progress.
     * + **CANCELLED** – You have successfully cancelled the import task.
     */
    public val status: aws.sdk.kotlin.services.neptunegraph.model.ImportTaskStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The reason that the import task has this status value.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The unique identifier of the import task.
     */
    public val taskId: kotlin.String = requireNotNull(builder.taskId) { "A non-null value must be provided for taskId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.GetImportTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetImportTaskResponse(")
        append("attemptNumber=$attemptNumber,")
        append("format=$format,")
        append("graphId=$graphId,")
        append("importOptions=$importOptions,")
        append("importTaskDetails=$importTaskDetails,")
        append("roleArn=$roleArn,")
        append("source=$source,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("taskId=$taskId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attemptNumber ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (graphId?.hashCode() ?: 0)
        result = 31 * result + (importOptions?.hashCode() ?: 0)
        result = 31 * result + (importTaskDetails?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (source.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (taskId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetImportTaskResponse

        if (attemptNumber != other.attemptNumber) return false
        if (format != other.format) return false
        if (graphId != other.graphId) return false
        if (importOptions != other.importOptions) return false
        if (importTaskDetails != other.importTaskDetails) return false
        if (roleArn != other.roleArn) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (taskId != other.taskId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.GetImportTaskResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of the current attempt to execute the import task.
         */
        public var attemptNumber: kotlin.Int? = null
        /**
         * Specifies the format of S3 data to be imported. Valid values are `CSV`, which identifies the [Gremlin CSV format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html) or `OPENCYPHER`, which identies the [openCypher load format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html).
         */
        public var format: aws.sdk.kotlin.services.neptunegraph.model.Format? = null
        /**
         * The unique identifier of the Neptune Analytics graph.
         */
        public var graphId: kotlin.String? = null
        /**
         * Contains options for controlling the import process. For example, if the `failOnError` key is set to `false`, the import skips problem data and attempts to continue (whereas if set to `true`, the default, or if omitted, the import operation halts immediately when an error is encountered.
         */
        public var importOptions: aws.sdk.kotlin.services.neptunegraph.model.ImportOptions? = null
        /**
         * Contains details about the specified import task.
         */
        public var importTaskDetails: aws.sdk.kotlin.services.neptunegraph.model.ImportTaskDetails? = null
        /**
         * The ARN of the IAM role that will allow access to the data that is to be imported.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A URL identifying to the location of the data to be imported. This can be an Amazon S3 path, or can point to a Neptune database endpoint or snapshot
         */
        public var source: kotlin.String? = null
        /**
         * The status of the import task:
         * + **INITIALIZING** – The necessary resources needed to create the graph are being prepared.
         * + **ANALYZING_DATA** – The data is being analyzed to determine the optimal infrastructure configuration for the new graph.
         * + **RE_PROVISIONING** – The data did not fit into the provisioned graph, so it is being re-provisioned with more capacity.
         * + **IMPORTING** – The data is being loaded.
         * + **ERROR_ENCOUNTERED** – An error has been encountered while trying to create the graph and import the data.
         * + **ERROR_ENCOUNTERED_ROLLING_BACK** – Because of the error that was encountered, the graph is being rolled back and all its resources released.
         * + **SUCCEEDED** – Graph creation and data loading succeeded.
         * + **FAILED** – Graph creation or data loading failed. When the status is `FAILED`, you can use `get-graphs` to get more information about the state of the graph.
         * + **CANCELLING** – Because you cancelled the import task, cancellation is in progress.
         * + **CANCELLED** – You have successfully cancelled the import task.
         */
        public var status: aws.sdk.kotlin.services.neptunegraph.model.ImportTaskStatus? = null
        /**
         * The reason that the import task has this status value.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The unique identifier of the import task.
         */
        public var taskId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.GetImportTaskResponse) : this() {
            this.attemptNumber = x.attemptNumber
            this.format = x.format
            this.graphId = x.graphId
            this.importOptions = x.importOptions
            this.importTaskDetails = x.importTaskDetails
            this.roleArn = x.roleArn
            this.source = x.source
            this.status = x.status
            this.statusReason = x.statusReason
            this.taskId = x.taskId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.GetImportTaskResponse = GetImportTaskResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptunegraph.model.ImportTaskDetails] inside the given [block]
         */
        public fun importTaskDetails(block: aws.sdk.kotlin.services.neptunegraph.model.ImportTaskDetails.Builder.() -> kotlin.Unit) {
            this.importTaskDetails = aws.sdk.kotlin.services.neptunegraph.model.ImportTaskDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (source == null) source = ""
            if (status == null) status = ImportTaskStatus.SdkUnknown("no value provided")
            if (taskId == null) taskId = ""
            return this
        }
    }
}
