// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateGraphUsingImportTaskRequest private constructor(builder: Builder) {
    /**
     * The method to handle blank nodes in the dataset. Currently, only `convertToIri` is supported, meaning blank nodes are converted to unique IRIs at load time. Must be provided when format is `ntriples`. For more information, see [Handling RDF values](https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling).
     */
    public val blankNodeHandling: aws.sdk.kotlin.services.neptunegraph.model.BlankNodeHandling? = builder.blankNodeHandling
    /**
     * Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when deletion protection is enabled. (`true` or `false`).
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * If set to `true`, the task halts when an import error is encountered. If set to `false`, the task skips the data that caused the error and continues if possible.
     */
    public val failOnError: kotlin.Boolean? = builder.failOnError
    /**
     * Specifies the format of S3 data to be imported. Valid values are `CSV`, which identifies the [Gremlin CSV format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html) or `OPENCYPHER`, which identies the [openCypher load format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html).
     */
    public val format: aws.sdk.kotlin.services.neptunegraph.model.Format? = builder.format
    /**
     * A name for the new Neptune Analytics graph to be created.
     *
     * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val graphName: kotlin.String? = builder.graphName
    /**
     * Contains options for controlling the import process. For example, if the `failOnError` key is set to `false`, the import skips problem data and attempts to continue (whereas if set to `true`, the default, or if omitted, the import operation halts immediately when an error is encountered.
     */
    public val importOptions: aws.sdk.kotlin.services.neptunegraph.model.ImportOptions? = builder.importOptions
    /**
     * Specifies a KMS key to use to encrypt data imported into the new graph.
     */
    public val kmsKeyIdentifier: kotlin.String? = builder.kmsKeyIdentifier
    /**
     * The maximum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Default: 1024, or the approved upper limit for your account.
     *
     *  If both the minimum and maximum values are specified, the max of the `min-provisioned-memory` and `max-provisioned memory` is used to create the graph. If neither value is specified 128 m-NCUs are used.
     */
    public val maxProvisionedMemory: kotlin.Int? = builder.maxProvisionedMemory
    /**
     * The minimum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Default: 128
     */
    public val minProvisionedMemory: kotlin.Int? = builder.minProvisionedMemory
    /**
     * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated. (`true` to enable, or `false` to disable).
     */
    public val publicConnectivity: kotlin.Boolean? = builder.publicConnectivity
    /**
     * The number of replicas in other AZs to provision on the new graph after import. Default = 0, Min = 0, Max = 2.
     *
     *  Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
     */
    public val replicaCount: kotlin.Int? = builder.replicaCount
    /**
     * The ARN of the IAM role that will allow access to the data that is to be imported.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A URL identifying to the location of the data to be imported. This can be an Amazon S3 path, or can point to a Neptune database endpoint or snapshot.
     */
    public val source: kotlin.String? = builder.source
    /**
     * Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or used in a Condition statement in an IAM policy.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is specified as `dimension=`value. Max = 65,535
     */
    public val vectorSearchConfiguration: aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration? = builder.vectorSearchConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.CreateGraphUsingImportTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGraphUsingImportTaskRequest(")
        append("blankNodeHandling=$blankNodeHandling,")
        append("deletionProtection=$deletionProtection,")
        append("failOnError=$failOnError,")
        append("format=$format,")
        append("graphName=$graphName,")
        append("importOptions=$importOptions,")
        append("kmsKeyIdentifier=$kmsKeyIdentifier,")
        append("maxProvisionedMemory=$maxProvisionedMemory,")
        append("minProvisionedMemory=$minProvisionedMemory,")
        append("publicConnectivity=$publicConnectivity,")
        append("replicaCount=$replicaCount,")
        append("roleArn=$roleArn,")
        append("source=$source,")
        append("tags=$tags,")
        append("vectorSearchConfiguration=$vectorSearchConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blankNodeHandling?.hashCode() ?: 0
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (failOnError?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (graphName?.hashCode() ?: 0)
        result = 31 * result + (importOptions?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyIdentifier?.hashCode() ?: 0)
        result = 31 * result + (maxProvisionedMemory ?: 0)
        result = 31 * result + (minProvisionedMemory ?: 0)
        result = 31 * result + (publicConnectivity?.hashCode() ?: 0)
        result = 31 * result + (replicaCount ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vectorSearchConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGraphUsingImportTaskRequest

        if (blankNodeHandling != other.blankNodeHandling) return false
        if (deletionProtection != other.deletionProtection) return false
        if (failOnError != other.failOnError) return false
        if (format != other.format) return false
        if (graphName != other.graphName) return false
        if (importOptions != other.importOptions) return false
        if (kmsKeyIdentifier != other.kmsKeyIdentifier) return false
        if (maxProvisionedMemory != other.maxProvisionedMemory) return false
        if (minProvisionedMemory != other.minProvisionedMemory) return false
        if (publicConnectivity != other.publicConnectivity) return false
        if (replicaCount != other.replicaCount) return false
        if (roleArn != other.roleArn) return false
        if (source != other.source) return false
        if (tags != other.tags) return false
        if (vectorSearchConfiguration != other.vectorSearchConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.CreateGraphUsingImportTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The method to handle blank nodes in the dataset. Currently, only `convertToIri` is supported, meaning blank nodes are converted to unique IRIs at load time. Must be provided when format is `ntriples`. For more information, see [Handling RDF values](https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling).
         */
        public var blankNodeHandling: aws.sdk.kotlin.services.neptunegraph.model.BlankNodeHandling? = null
        /**
         * Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when deletion protection is enabled. (`true` or `false`).
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * If set to `true`, the task halts when an import error is encountered. If set to `false`, the task skips the data that caused the error and continues if possible.
         */
        public var failOnError: kotlin.Boolean? = null
        /**
         * Specifies the format of S3 data to be imported. Valid values are `CSV`, which identifies the [Gremlin CSV format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html) or `OPENCYPHER`, which identies the [openCypher load format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html).
         */
        public var format: aws.sdk.kotlin.services.neptunegraph.model.Format? = null
        /**
         * A name for the new Neptune Analytics graph to be created.
         *
         * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var graphName: kotlin.String? = null
        /**
         * Contains options for controlling the import process. For example, if the `failOnError` key is set to `false`, the import skips problem data and attempts to continue (whereas if set to `true`, the default, or if omitted, the import operation halts immediately when an error is encountered.
         */
        public var importOptions: aws.sdk.kotlin.services.neptunegraph.model.ImportOptions? = null
        /**
         * Specifies a KMS key to use to encrypt data imported into the new graph.
         */
        public var kmsKeyIdentifier: kotlin.String? = null
        /**
         * The maximum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Default: 1024, or the approved upper limit for your account.
         *
         *  If both the minimum and maximum values are specified, the max of the `min-provisioned-memory` and `max-provisioned memory` is used to create the graph. If neither value is specified 128 m-NCUs are used.
         */
        public var maxProvisionedMemory: kotlin.Int? = null
        /**
         * The minimum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Default: 128
         */
        public var minProvisionedMemory: kotlin.Int? = null
        /**
         * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated. (`true` to enable, or `false` to disable).
         */
        public var publicConnectivity: kotlin.Boolean? = null
        /**
         * The number of replicas in other AZs to provision on the new graph after import. Default = 0, Min = 0, Max = 2.
         *
         *  Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
         */
        public var replicaCount: kotlin.Int? = null
        /**
         * The ARN of the IAM role that will allow access to the data that is to be imported.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A URL identifying to the location of the data to be imported. This can be an Amazon S3 path, or can point to a Neptune database endpoint or snapshot.
         */
        public var source: kotlin.String? = null
        /**
         * Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or used in a Condition statement in an IAM policy.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is specified as `dimension=`value. Max = 65,535
         */
        public var vectorSearchConfiguration: aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.CreateGraphUsingImportTaskRequest) : this() {
            this.blankNodeHandling = x.blankNodeHandling
            this.deletionProtection = x.deletionProtection
            this.failOnError = x.failOnError
            this.format = x.format
            this.graphName = x.graphName
            this.importOptions = x.importOptions
            this.kmsKeyIdentifier = x.kmsKeyIdentifier
            this.maxProvisionedMemory = x.maxProvisionedMemory
            this.minProvisionedMemory = x.minProvisionedMemory
            this.publicConnectivity = x.publicConnectivity
            this.replicaCount = x.replicaCount
            this.roleArn = x.roleArn
            this.source = x.source
            this.tags = x.tags
            this.vectorSearchConfiguration = x.vectorSearchConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.CreateGraphUsingImportTaskRequest = CreateGraphUsingImportTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration] inside the given [block]
         */
        public fun vectorSearchConfiguration(block: aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration.Builder.() -> kotlin.Unit) {
            this.vectorSearchConfiguration = aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
