// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateGraphResponse private constructor(builder: Builder) {
    /**
     * The ARN of the graph.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The build number of the graph software.
     */
    public val buildNumber: kotlin.String? = builder.buildNumber
    /**
     * The time when the graph was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The graph endpoint.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The ID of the graph.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Specifies the KMS key used to encrypt data in the new graph.
     */
    public val kmsKeyIdentifier: kotlin.String? = builder.kmsKeyIdentifier
    /**
     * The graph name. For example: `my-graph-1`.
     *
     * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
     *
     * Min = 128
     */
    public val provisionedMemory: kotlin.Int? = builder.provisionedMemory
    /**
     * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
     *
     * If enabling public connectivity for the first time, there will be a delay while it is enabled.
     */
    public val publicConnectivity: kotlin.Boolean? = builder.publicConnectivity
    /**
     * The number of replicas in other AZs.
     *
     * Default: If not specified, the default value is 1.
     */
    public val replicaCount: kotlin.Int? = builder.replicaCount
    /**
     * The ID of the source graph.
     */
    public val sourceSnapshotId: kotlin.String? = builder.sourceSnapshotId
    /**
     * The current status of the graph.
     */
    public val status: aws.sdk.kotlin.services.neptunegraph.model.GraphStatus? = builder.status
    /**
     * The reason the status was given.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The vector-search configuration for the graph, which specifies the vector dimension to use in the vector index, if any.
     */
    public val vectorSearchConfiguration: aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration? = builder.vectorSearchConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.CreateGraphResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGraphResponse(")
        append("arn=$arn,")
        append("buildNumber=$buildNumber,")
        append("createTime=$createTime,")
        append("deletionProtection=$deletionProtection,")
        append("endpoint=$endpoint,")
        append("id=$id,")
        append("kmsKeyIdentifier=$kmsKeyIdentifier,")
        append("name=$name,")
        append("provisionedMemory=$provisionedMemory,")
        append("publicConnectivity=$publicConnectivity,")
        append("replicaCount=$replicaCount,")
        append("sourceSnapshotId=$sourceSnapshotId,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("vectorSearchConfiguration=$vectorSearchConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (buildNumber?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (kmsKeyIdentifier?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (provisionedMemory ?: 0)
        result = 31 * result + (publicConnectivity?.hashCode() ?: 0)
        result = 31 * result + (replicaCount ?: 0)
        result = 31 * result + (sourceSnapshotId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (vectorSearchConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGraphResponse

        if (arn != other.arn) return false
        if (buildNumber != other.buildNumber) return false
        if (createTime != other.createTime) return false
        if (deletionProtection != other.deletionProtection) return false
        if (endpoint != other.endpoint) return false
        if (id != other.id) return false
        if (kmsKeyIdentifier != other.kmsKeyIdentifier) return false
        if (name != other.name) return false
        if (provisionedMemory != other.provisionedMemory) return false
        if (publicConnectivity != other.publicConnectivity) return false
        if (replicaCount != other.replicaCount) return false
        if (sourceSnapshotId != other.sourceSnapshotId) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (vectorSearchConfiguration != other.vectorSearchConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.CreateGraphResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the graph.
         */
        public var arn: kotlin.String? = null
        /**
         * The build number of the graph software.
         */
        public var buildNumber: kotlin.String? = null
        /**
         * The time when the graph was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The graph endpoint.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The ID of the graph.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies the KMS key used to encrypt data in the new graph.
         */
        public var kmsKeyIdentifier: kotlin.String? = null
        /**
         * The graph name. For example: `my-graph-1`.
         *
         * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var name: kotlin.String? = null
        /**
         * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
         *
         * Min = 128
         */
        public var provisionedMemory: kotlin.Int? = null
        /**
         * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
         *
         * If enabling public connectivity for the first time, there will be a delay while it is enabled.
         */
        public var publicConnectivity: kotlin.Boolean? = null
        /**
         * The number of replicas in other AZs.
         *
         * Default: If not specified, the default value is 1.
         */
        public var replicaCount: kotlin.Int? = null
        /**
         * The ID of the source graph.
         */
        public var sourceSnapshotId: kotlin.String? = null
        /**
         * The current status of the graph.
         */
        public var status: aws.sdk.kotlin.services.neptunegraph.model.GraphStatus? = null
        /**
         * The reason the status was given.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The vector-search configuration for the graph, which specifies the vector dimension to use in the vector index, if any.
         */
        public var vectorSearchConfiguration: aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.CreateGraphResponse) : this() {
            this.arn = x.arn
            this.buildNumber = x.buildNumber
            this.createTime = x.createTime
            this.deletionProtection = x.deletionProtection
            this.endpoint = x.endpoint
            this.id = x.id
            this.kmsKeyIdentifier = x.kmsKeyIdentifier
            this.name = x.name
            this.provisionedMemory = x.provisionedMemory
            this.publicConnectivity = x.publicConnectivity
            this.replicaCount = x.replicaCount
            this.sourceSnapshotId = x.sourceSnapshotId
            this.status = x.status
            this.statusReason = x.statusReason
            this.vectorSearchConfiguration = x.vectorSearchConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.CreateGraphResponse = CreateGraphResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration] inside the given [block]
         */
        public fun vectorSearchConfiguration(block: aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration.Builder.() -> kotlin.Unit) {
            this.vectorSearchConfiguration = aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
