// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateGraphRequest private constructor(builder: Builder) {
    /**
     * Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when deletion protection is enabled. (`true` or `false`).
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * A name for the new Neptune Analytics graph to be created.
     *
     * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val graphName: kotlin.String? = builder.graphName
    /**
     * Specifies a KMS key to use to encrypt data in the new graph.
     */
    public val kmsKeyIdentifier: kotlin.String? = builder.kmsKeyIdentifier
    /**
     * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Min = 128
     */
    public val provisionedMemory: kotlin.Int? = builder.provisionedMemory
    /**
     * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated. (`true` to enable, or `false` to disable.
     */
    public val publicConnectivity: kotlin.Boolean? = builder.publicConnectivity
    /**
     * The number of replicas in other AZs. Min =0, Max = 2, Default = 1.
     *
     *  Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
     */
    public val replicaCount: kotlin.Int? = builder.replicaCount
    /**
     * Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or used in a Condition statement in an IAM policy.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is specified as `dimension=`value. Max = 65,535
     */
    public val vectorSearchConfiguration: aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration? = builder.vectorSearchConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.CreateGraphRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGraphRequest(")
        append("deletionProtection=$deletionProtection,")
        append("graphName=$graphName,")
        append("kmsKeyIdentifier=$kmsKeyIdentifier,")
        append("provisionedMemory=$provisionedMemory,")
        append("publicConnectivity=$publicConnectivity,")
        append("replicaCount=$replicaCount,")
        append("tags=$tags,")
        append("vectorSearchConfiguration=$vectorSearchConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletionProtection?.hashCode() ?: 0
        result = 31 * result + (graphName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyIdentifier?.hashCode() ?: 0)
        result = 31 * result + (provisionedMemory ?: 0)
        result = 31 * result + (publicConnectivity?.hashCode() ?: 0)
        result = 31 * result + (replicaCount ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vectorSearchConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGraphRequest

        if (deletionProtection != other.deletionProtection) return false
        if (graphName != other.graphName) return false
        if (kmsKeyIdentifier != other.kmsKeyIdentifier) return false
        if (provisionedMemory != other.provisionedMemory) return false
        if (publicConnectivity != other.publicConnectivity) return false
        if (replicaCount != other.replicaCount) return false
        if (tags != other.tags) return false
        if (vectorSearchConfiguration != other.vectorSearchConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.CreateGraphRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when deletion protection is enabled. (`true` or `false`).
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * A name for the new Neptune Analytics graph to be created.
         *
         * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var graphName: kotlin.String? = null
        /**
         * Specifies a KMS key to use to encrypt data in the new graph.
         */
        public var kmsKeyIdentifier: kotlin.String? = null
        /**
         * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Min = 128
         */
        public var provisionedMemory: kotlin.Int? = null
        /**
         * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated. (`true` to enable, or `false` to disable.
         */
        public var publicConnectivity: kotlin.Boolean? = null
        /**
         * The number of replicas in other AZs. Min =0, Max = 2, Default = 1.
         *
         *  Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
         */
        public var replicaCount: kotlin.Int? = null
        /**
         * Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or used in a Condition statement in an IAM policy.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is specified as `dimension=`value. Max = 65,535
         */
        public var vectorSearchConfiguration: aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.CreateGraphRequest) : this() {
            this.deletionProtection = x.deletionProtection
            this.graphName = x.graphName
            this.kmsKeyIdentifier = x.kmsKeyIdentifier
            this.provisionedMemory = x.provisionedMemory
            this.publicConnectivity = x.publicConnectivity
            this.replicaCount = x.replicaCount
            this.tags = x.tags
            this.vectorSearchConfiguration = x.vectorSearchConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.CreateGraphRequest = CreateGraphRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration] inside the given [block]
         */
        public fun vectorSearchConfiguration(block: aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration.Builder.() -> kotlin.Unit) {
            this.vectorSearchConfiguration = aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
