// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.serde

import aws.sdk.kotlin.services.neptunegraph.model.GraphStatus
import aws.sdk.kotlin.services.neptunegraph.model.NeptuneGraphException
import aws.sdk.kotlin.services.neptunegraph.model.RestoreGraphFromSnapshotResponse
import aws.sdk.kotlin.services.neptunegraph.model.VectorSearchConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class RestoreGraphFromSnapshotOperationDeserializer: HttpDeserializer.NonStreaming<RestoreGraphFromSnapshotResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RestoreGraphFromSnapshotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRestoreGraphFromSnapshotError(context, call, payload)
        }
        val builder = RestoreGraphFromSnapshotResponse.Builder()

        if (payload != null) {
            deserializeRestoreGraphFromSnapshotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRestoreGraphFromSnapshotError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NeptuneGraphException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptuneGraphException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreGraphFromSnapshotOperationBody(builder: RestoreGraphFromSnapshotResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val BUILDNUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("buildNumber"))
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createTime"))
    val DELETIONPROTECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("deletionProtection"))
    val ENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("endpoint"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val KMSKEYIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyIdentifier"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PROVISIONEDMEMORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("provisionedMemory"))
    val PUBLICCONNECTIVITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("publicConnectivity"))
    val REPLICACOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("replicaCount"))
    val SOURCESNAPSHOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceSnapshotId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val VECTORSEARCHCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vectorSearchConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(BUILDNUMBER_DESCRIPTOR)
        field(CREATETIME_DESCRIPTOR)
        field(DELETIONPROTECTION_DESCRIPTOR)
        field(ENDPOINT_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(KMSKEYIDENTIFIER_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROVISIONEDMEMORY_DESCRIPTOR)
        field(PUBLICCONNECTIVITY_DESCRIPTOR)
        field(REPLICACOUNT_DESCRIPTOR)
        field(SOURCESNAPSHOTID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(VECTORSEARCHCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                BUILDNUMBER_DESCRIPTOR.index -> builder.buildNumber = deserializeString()
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DELETIONPROTECTION_DESCRIPTOR.index -> builder.deletionProtection = deserializeBoolean()
                ENDPOINT_DESCRIPTOR.index -> builder.endpoint = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                KMSKEYIDENTIFIER_DESCRIPTOR.index -> builder.kmsKeyIdentifier = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PROVISIONEDMEMORY_DESCRIPTOR.index -> builder.provisionedMemory = deserializeInt()
                PUBLICCONNECTIVITY_DESCRIPTOR.index -> builder.publicConnectivity = deserializeBoolean()
                REPLICACOUNT_DESCRIPTOR.index -> builder.replicaCount = deserializeInt()
                SOURCESNAPSHOTID_DESCRIPTOR.index -> builder.sourceSnapshotId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { GraphStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                VECTORSEARCHCONFIGURATION_DESCRIPTOR.index -> builder.vectorSearchConfiguration = deserializeVectorSearchConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
