// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.serde

import aws.sdk.kotlin.services.neptunegraph.model.GetQueryResponse
import aws.sdk.kotlin.services.neptunegraph.model.NeptuneGraphException
import aws.sdk.kotlin.services.neptunegraph.model.QueryState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetQueryOperationDeserializer: HttpDeserializer.NonStreaming<GetQueryResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetQueryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetQueryError(context, call, payload)
        }
        val builder = GetQueryResponse.Builder()

        if (payload != null) {
            deserializeGetQueryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetQueryError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NeptuneGraphException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptuneGraphException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetQueryOperationBody(builder: GetQueryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ELAPSED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("elapsed"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryString"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("state"))
    val WAITED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("waited"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ELAPSED_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(WAITED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ELAPSED_DESCRIPTOR.index -> builder.elapsed = deserializeInt()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                QUERYSTRING_DESCRIPTOR.index -> builder.queryString = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { QueryState.fromValue(it) }
                WAITED_DESCRIPTOR.index -> builder.waited = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
