// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.serde

import aws.sdk.kotlin.services.neptunegraph.model.ExecuteQueryRequest
import aws.sdk.kotlin.services.neptunegraph.model.ExplainMode
import aws.sdk.kotlin.services.neptunegraph.model.PlanCacheType
import aws.sdk.kotlin.services.neptunegraph.model.QueryLanguage
import aws.smithy.kotlin.runtime.content.Document
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ExecuteQueryOperationSerializer: HttpSerializer.NonStreaming<ExecuteQueryRequest> {
    override fun serialize(context: ExecutionContext, input: ExecuteQueryRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/queries"
        }

        builder.headers {
            if (input.graphIdentifier?.isNotEmpty() == true) append("graphIdentifier", input.graphIdentifier)
        }

        val payload = serializeExecuteQueryOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeExecuteQueryOperationBody(context: ExecutionContext, input: ExecuteQueryRequest): ByteArray {
    val serializer = JsonSerializer()
    val EXPLAINMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("explain"))
    val LANGUAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("language"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("parameters"))
    val PLANCACHE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("planCache"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("query"))
    val QUERYTIMEOUTMILLISECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("queryTimeoutMilliseconds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXPLAINMODE_DESCRIPTOR)
        field(LANGUAGE_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(PLANCACHE_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
        field(QUERYTIMEOUTMILLISECONDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.explainMode?.let { field(EXPLAINMODE_DESCRIPTOR, it.value) }
        input.language?.let { field(LANGUAGE_DESCRIPTOR, it.value) }
        if (input.parameters != null) {
            mapField(PARAMETERS_DESCRIPTOR) {
                input.parameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.planCache?.let { field(PLANCACHE_DESCRIPTOR, it.value) }
        input.queryString?.let { field(QUERYSTRING_DESCRIPTOR, it) }
        input.queryTimeoutMilliseconds?.let { field(QUERYTIMEOUTMILLISECONDS_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
