// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.endpoints



/**
 * The set of values necessary for endpoint resolution.
 */
public class NeptuneGraphEndpointParameters private constructor(builder: Builder) {
    /**
     * Parameter to determine whether current API is a control plane or dataplane API
     */
    public val apiType: String? = requireNotNull(builder.apiType) { "endpoint provider parameter #apiType is required" }

    /**
     * Override the endpoint used to send this request
     */
    public val endpoint: String? = builder.endpoint

    /**
     * The AWS region used to dispatch the request.
     */
    public val region: String? = builder.region

    /**
     * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
     */
    public val useDualStack: Boolean? = requireNotNull(builder.useDualStack) { "endpoint provider parameter #useDualStack is required" }

    /**
     * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
     */
    public val useFips: Boolean? = requireNotNull(builder.useFips) { "endpoint provider parameter #useFips is required" }

    public companion object {
        public inline operator fun invoke(block: Builder.() -> Unit): NeptuneGraphEndpointParameters = Builder().apply(block).build()
    }

    public override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is NeptuneGraphEndpointParameters) return false
        if (this.apiType != other.apiType) return false
        if (this.endpoint != other.endpoint) return false
        if (this.region != other.region) return false
        if (this.useDualStack != other.useDualStack) return false
        if (this.useFips != other.useFips) return false
        return true
    }

    public override fun hashCode(): Int {
        var result = apiType?.hashCode() ?: 0
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (useDualStack?.hashCode() ?: 0)
        result = 31 * result + (useFips?.hashCode() ?: 0)
        return result
    }

    public override fun toString(): String = buildString {
        append("NeptuneGraphEndpointParameters(")
        append("apiType=$apiType,")
        append("endpoint=$endpoint,")
        append("region=$region,")
        append("useDualStack=$useDualStack,")
        append("useFips=$useFips)")
    }

    public fun copy(block: Builder.() -> Unit = {}): NeptuneGraphEndpointParameters {
        return Builder().apply {
            apiType = this@NeptuneGraphEndpointParameters.apiType
            endpoint = this@NeptuneGraphEndpointParameters.endpoint
            region = this@NeptuneGraphEndpointParameters.region
            useDualStack = this@NeptuneGraphEndpointParameters.useDualStack
            useFips = this@NeptuneGraphEndpointParameters.useFips
            block()
        }
        .build()
    }

    public class Builder {
        /**
         * Parameter to determine whether current API is a control plane or dataplane API
         */
        public var apiType: String? = null

        /**
         * Override the endpoint used to send this request
         */
        public var endpoint: String? = null

        /**
         * The AWS region used to dispatch the request.
         */
        public var region: String? = null

        /**
         * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
         */
        public var useDualStack: Boolean? = false

        /**
         * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
         */
        public var useFips: Boolean? = false

        public fun build(): NeptuneGraphEndpointParameters = NeptuneGraphEndpointParameters(this)
    }
}
