// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.endpoints

import aws.sdk.kotlin.services.neptunegraph.endpoints.internal.partition
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.url.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultNeptuneGraphEndpointProvider: NeptuneGraphEndpointProvider {
    public override suspend fun resolveEndpoint(params: NeptuneGraphEndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint),
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            if (
                                params.apiType == "ControlPlane"
                            ) {
                                return Endpoint(
                                    Url.parse("https://neptune-graph-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                                )
                            }
                            if (
                                params.apiType == "DataPlane"
                            ) {
                                throw EndpointProviderException("Invalid Configuration: fips endpoint is not supported for this API")
                            }
                            throw EndpointProviderException("Invalid Configuration: Unknown ApiType")
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS
                        ) {
                            if (
                                params.apiType == "ControlPlane"
                            ) {
                                return Endpoint(
                                    Url.parse("https://neptune-graph-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                )
                            }
                            if (
                                params.apiType == "DataPlane"
                            ) {
                                throw EndpointProviderException("Invalid Configuration: fips endpoint is not supported for this API")
                            }
                            throw EndpointProviderException("Invalid Configuration: Unknown ApiType")
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            if (
                                params.apiType == "ControlPlane"
                            ) {
                                return Endpoint(
                                    Url.parse("https://neptune-graph.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                                )
                            }
                            if (
                                params.apiType == "DataPlane"
                            ) {
                                return Endpoint(
                                    Url.parse("https://neptune-graph.${params.region}.on.aws"),
                                )
                            }
                            throw EndpointProviderException("Invalid Configuration: Unknown ApiType")
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    if (
                        params.apiType == "ControlPlane"
                    ) {
                        return Endpoint(
                            Url.parse("https://neptune-graph.${params.region}.${partitionResult?.dnsSuffix}"),
                        )
                    }
                    if (
                        params.apiType == "DataPlane"
                    ) {
                        return Endpoint(
                            Url.parse("https://${params.region}.neptune-graph.${partitionResult?.dnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("Invalid Configuration: Unknown ApiType")
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
