// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.neptunegraph.auth.DefaultNeptuneGraphAuthSchemeProvider
import aws.sdk.kotlin.services.neptunegraph.auth.NeptuneGraphAuthSchemeProvider
import aws.sdk.kotlin.services.neptunegraph.endpoints.DefaultNeptuneGraphEndpointProvider
import aws.sdk.kotlin.services.neptunegraph.endpoints.NeptuneGraphEndpointParameters
import aws.sdk.kotlin.services.neptunegraph.endpoints.NeptuneGraphEndpointProvider
import aws.sdk.kotlin.services.neptunegraph.model.CancelImportTaskRequest
import aws.sdk.kotlin.services.neptunegraph.model.CancelImportTaskResponse
import aws.sdk.kotlin.services.neptunegraph.model.CancelQueryRequest
import aws.sdk.kotlin.services.neptunegraph.model.CancelQueryResponse
import aws.sdk.kotlin.services.neptunegraph.model.CreateGraphRequest
import aws.sdk.kotlin.services.neptunegraph.model.CreateGraphResponse
import aws.sdk.kotlin.services.neptunegraph.model.CreateGraphSnapshotRequest
import aws.sdk.kotlin.services.neptunegraph.model.CreateGraphSnapshotResponse
import aws.sdk.kotlin.services.neptunegraph.model.CreateGraphUsingImportTaskRequest
import aws.sdk.kotlin.services.neptunegraph.model.CreateGraphUsingImportTaskResponse
import aws.sdk.kotlin.services.neptunegraph.model.CreatePrivateGraphEndpointRequest
import aws.sdk.kotlin.services.neptunegraph.model.CreatePrivateGraphEndpointResponse
import aws.sdk.kotlin.services.neptunegraph.model.DeleteGraphRequest
import aws.sdk.kotlin.services.neptunegraph.model.DeleteGraphResponse
import aws.sdk.kotlin.services.neptunegraph.model.DeleteGraphSnapshotRequest
import aws.sdk.kotlin.services.neptunegraph.model.DeleteGraphSnapshotResponse
import aws.sdk.kotlin.services.neptunegraph.model.DeletePrivateGraphEndpointRequest
import aws.sdk.kotlin.services.neptunegraph.model.DeletePrivateGraphEndpointResponse
import aws.sdk.kotlin.services.neptunegraph.model.ExecuteQueryRequest
import aws.sdk.kotlin.services.neptunegraph.model.ExecuteQueryResponse
import aws.sdk.kotlin.services.neptunegraph.model.GetGraphRequest
import aws.sdk.kotlin.services.neptunegraph.model.GetGraphResponse
import aws.sdk.kotlin.services.neptunegraph.model.GetGraphSnapshotRequest
import aws.sdk.kotlin.services.neptunegraph.model.GetGraphSnapshotResponse
import aws.sdk.kotlin.services.neptunegraph.model.GetGraphSummaryRequest
import aws.sdk.kotlin.services.neptunegraph.model.GetGraphSummaryResponse
import aws.sdk.kotlin.services.neptunegraph.model.GetImportTaskRequest
import aws.sdk.kotlin.services.neptunegraph.model.GetImportTaskResponse
import aws.sdk.kotlin.services.neptunegraph.model.GetPrivateGraphEndpointRequest
import aws.sdk.kotlin.services.neptunegraph.model.GetPrivateGraphEndpointResponse
import aws.sdk.kotlin.services.neptunegraph.model.GetQueryRequest
import aws.sdk.kotlin.services.neptunegraph.model.GetQueryResponse
import aws.sdk.kotlin.services.neptunegraph.model.ListGraphSnapshotsRequest
import aws.sdk.kotlin.services.neptunegraph.model.ListGraphSnapshotsResponse
import aws.sdk.kotlin.services.neptunegraph.model.ListGraphsRequest
import aws.sdk.kotlin.services.neptunegraph.model.ListGraphsResponse
import aws.sdk.kotlin.services.neptunegraph.model.ListImportTasksRequest
import aws.sdk.kotlin.services.neptunegraph.model.ListImportTasksResponse
import aws.sdk.kotlin.services.neptunegraph.model.ListPrivateGraphEndpointsRequest
import aws.sdk.kotlin.services.neptunegraph.model.ListPrivateGraphEndpointsResponse
import aws.sdk.kotlin.services.neptunegraph.model.ListQueriesRequest
import aws.sdk.kotlin.services.neptunegraph.model.ListQueriesResponse
import aws.sdk.kotlin.services.neptunegraph.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.neptunegraph.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.neptunegraph.model.ResetGraphRequest
import aws.sdk.kotlin.services.neptunegraph.model.ResetGraphResponse
import aws.sdk.kotlin.services.neptunegraph.model.RestoreGraphFromSnapshotRequest
import aws.sdk.kotlin.services.neptunegraph.model.RestoreGraphFromSnapshotResponse
import aws.sdk.kotlin.services.neptunegraph.model.StartImportTaskRequest
import aws.sdk.kotlin.services.neptunegraph.model.StartImportTaskResponse
import aws.sdk.kotlin.services.neptunegraph.model.TagResourceRequest
import aws.sdk.kotlin.services.neptunegraph.model.TagResourceResponse
import aws.sdk.kotlin.services.neptunegraph.model.UntagResourceRequest
import aws.sdk.kotlin.services.neptunegraph.model.UntagResourceResponse
import aws.sdk.kotlin.services.neptunegraph.model.UpdateGraphRequest
import aws.sdk.kotlin.services.neptunegraph.model.UpdateGraphResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Neptune Graph"
public const val SdkVersion: String = "1.1.13"
public const val ServiceApiVersion: String = "2023-11-29"

/**
 * Neptune Analytics is a new analytics database engine for Amazon Neptune that helps customers get to insights faster by quickly processing large amounts of graph data, invoking popular graph analytic algorithms in low-latency queries, and getting analytics results in seconds.
 */
public interface NeptuneGraphClient : SdkClient {
    /**
     * NeptuneGraphClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, NeptuneGraphClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "NeptuneGraph",
                "NEPTUNE_GRAPH",
                "neptune_graph",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, NeptuneGraphClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): NeptuneGraphClient = DefaultNeptuneGraphClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: NeptuneGraphEndpointProvider = builder.endpointProvider ?: DefaultNeptuneGraphEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: NeptuneGraphAuthSchemeProvider = builder.authSchemeProvider ?: DefaultNeptuneGraphAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Neptune Graph"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: NeptuneGraphEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: NeptuneGraphAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes the specified import task.
     */
    public suspend fun cancelImportTask(input: CancelImportTaskRequest): CancelImportTaskResponse

    /**
     * Cancels a specified query.
     */
    public suspend fun cancelQuery(input: CancelQueryRequest): CancelQueryResponse

    /**
     * Creates a new Neptune Analytics graph.
     */
    public suspend fun createGraph(input: CreateGraphRequest): CreateGraphResponse

    /**
     * Creates a snapshot of the specific graph.
     */
    public suspend fun createGraphSnapshot(input: CreateGraphSnapshotRequest): CreateGraphSnapshotResponse

    /**
     * Creates a new Neptune Analytics graph and imports data into it, either from Amazon Simple Storage Service (S3) or from a Neptune database or a Neptune database snapshot.
     *
     * The data can be loaded from files in S3 that in either the [Gremlin CSV format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html) or the [openCypher load format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html).
     */
    public suspend fun createGraphUsingImportTask(input: CreateGraphUsingImportTaskRequest): CreateGraphUsingImportTaskResponse

    /**
     * Create a private graph endpoint to allow private access from to the graph from within a VPC. You can attach security groups to the private graph endpoint.
     *
     * VPC endpoint charges apply.
     */
    public suspend fun createPrivateGraphEndpoint(input: CreatePrivateGraphEndpointRequest): CreatePrivateGraphEndpointResponse

    /**
     * Deletes the specified graph. Graphs cannot be deleted if delete-protection is enabled.
     */
    public suspend fun deleteGraph(input: DeleteGraphRequest): DeleteGraphResponse

    /**
     * Deletes the specifed graph snapshot.
     */
    public suspend fun deleteGraphSnapshot(input: DeleteGraphSnapshotRequest): DeleteGraphSnapshotResponse

    /**
     * Deletes a private graph endpoint.
     */
    public suspend fun deletePrivateGraphEndpoint(input: DeletePrivateGraphEndpointRequest): DeletePrivateGraphEndpointResponse

    /**
     * Execute an openCypher query.
     *
     *  When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have a policy attached that allows one of the following IAM actions in that cluster, depending on the query:
     * + neptune-graph:ReadDataViaQuery
     * + neptune-graph:WriteDataViaQuery
     * + neptune-graph:DeleteDataViaQuery
     */
    public suspend fun <T> executeQuery(input: ExecuteQueryRequest, block: suspend (ExecuteQueryResponse) -> T): T

    /**
     * Gets information about a specified graph.
     */
    public suspend fun getGraph(input: GetGraphRequest): GetGraphResponse

    /**
     * Retrieves a specified graph snapshot.
     */
    public suspend fun getGraphSnapshot(input: GetGraphSnapshotRequest): GetGraphSnapshotResponse

    /**
     * Gets a graph summary for a property graph.
     */
    public suspend fun getGraphSummary(input: GetGraphSummaryRequest): GetGraphSummaryResponse

    /**
     * Retrieves a specified import task.
     */
    public suspend fun getImportTask(input: GetImportTaskRequest): GetImportTaskResponse

    /**
     * Retrieves information about a specified private endpoint.
     */
    public suspend fun getPrivateGraphEndpoint(input: GetPrivateGraphEndpointRequest): GetPrivateGraphEndpointResponse

    /**
     * Retrieves the status of a specified query.
     *
     *  When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have the `neptune-graph:GetQueryStatus` IAM action attached.
     */
    public suspend fun getQuery(input: GetQueryRequest): GetQueryResponse

    /**
     * Lists available snapshots of a specified Neptune Analytics graph.
     */
    public suspend fun listGraphSnapshots(input: ListGraphSnapshotsRequest = ListGraphSnapshotsRequest { }): ListGraphSnapshotsResponse

    /**
     * Lists available Neptune Analytics graphs.
     */
    public suspend fun listGraphs(input: ListGraphsRequest = ListGraphsRequest { }): ListGraphsResponse

    /**
     * Lists import tasks.
     */
    public suspend fun listImportTasks(input: ListImportTasksRequest = ListImportTasksRequest { }): ListImportTasksResponse

    /**
     * Lists private endpoints for a specified Neptune Analytics graph.
     */
    public suspend fun listPrivateGraphEndpoints(input: ListPrivateGraphEndpointsRequest): ListPrivateGraphEndpointsResponse

    /**
     * Lists active openCypher queries.
     */
    public suspend fun listQueries(input: ListQueriesRequest): ListQueriesResponse

    /**
     * Lists tags associated with a specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Empties the data from a specified Neptune Analytics graph.
     */
    public suspend fun resetGraph(input: ResetGraphRequest): ResetGraphResponse

    /**
     * Restores a graph from a snapshot.
     */
    public suspend fun restoreGraphFromSnapshot(input: RestoreGraphFromSnapshotRequest): RestoreGraphFromSnapshotResponse

    /**
     * Import data into existing Neptune Analytics graph from Amazon Simple Storage Service (S3). The graph needs to be empty and in the AVAILABLE state.
     */
    public suspend fun startImportTask(input: StartImportTaskRequest): StartImportTaskResponse

    /**
     * Adds tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the configuration of a specified Neptune Analytics graph
     */
    public suspend fun updateGraph(input: UpdateGraphRequest): UpdateGraphResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun NeptuneGraphClient.withConfig(block: NeptuneGraphClient.Config.Builder.() -> Unit): NeptuneGraphClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultNeptuneGraphClient(newConfig)
}

/**
 * Deletes the specified import task.
 */
public suspend inline fun NeptuneGraphClient.cancelImportTask(crossinline block: CancelImportTaskRequest.Builder.() -> Unit): CancelImportTaskResponse = cancelImportTask(CancelImportTaskRequest.Builder().apply(block).build())

/**
 * Cancels a specified query.
 */
public suspend inline fun NeptuneGraphClient.cancelQuery(crossinline block: CancelQueryRequest.Builder.() -> Unit): CancelQueryResponse = cancelQuery(CancelQueryRequest.Builder().apply(block).build())

/**
 * Creates a new Neptune Analytics graph.
 */
public suspend inline fun NeptuneGraphClient.createGraph(crossinline block: CreateGraphRequest.Builder.() -> Unit): CreateGraphResponse = createGraph(CreateGraphRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of the specific graph.
 */
public suspend inline fun NeptuneGraphClient.createGraphSnapshot(crossinline block: CreateGraphSnapshotRequest.Builder.() -> Unit): CreateGraphSnapshotResponse = createGraphSnapshot(CreateGraphSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a new Neptune Analytics graph and imports data into it, either from Amazon Simple Storage Service (S3) or from a Neptune database or a Neptune database snapshot.
 *
 * The data can be loaded from files in S3 that in either the [Gremlin CSV format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html) or the [openCypher load format](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html).
 */
public suspend inline fun NeptuneGraphClient.createGraphUsingImportTask(crossinline block: CreateGraphUsingImportTaskRequest.Builder.() -> Unit): CreateGraphUsingImportTaskResponse = createGraphUsingImportTask(CreateGraphUsingImportTaskRequest.Builder().apply(block).build())

/**
 * Create a private graph endpoint to allow private access from to the graph from within a VPC. You can attach security groups to the private graph endpoint.
 *
 * VPC endpoint charges apply.
 */
public suspend inline fun NeptuneGraphClient.createPrivateGraphEndpoint(crossinline block: CreatePrivateGraphEndpointRequest.Builder.() -> Unit): CreatePrivateGraphEndpointResponse = createPrivateGraphEndpoint(CreatePrivateGraphEndpointRequest.Builder().apply(block).build())

/**
 * Deletes the specified graph. Graphs cannot be deleted if delete-protection is enabled.
 */
public suspend inline fun NeptuneGraphClient.deleteGraph(crossinline block: DeleteGraphRequest.Builder.() -> Unit): DeleteGraphResponse = deleteGraph(DeleteGraphRequest.Builder().apply(block).build())

/**
 * Deletes the specifed graph snapshot.
 */
public suspend inline fun NeptuneGraphClient.deleteGraphSnapshot(crossinline block: DeleteGraphSnapshotRequest.Builder.() -> Unit): DeleteGraphSnapshotResponse = deleteGraphSnapshot(DeleteGraphSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes a private graph endpoint.
 */
public suspend inline fun NeptuneGraphClient.deletePrivateGraphEndpoint(crossinline block: DeletePrivateGraphEndpointRequest.Builder.() -> Unit): DeletePrivateGraphEndpointResponse = deletePrivateGraphEndpoint(DeletePrivateGraphEndpointRequest.Builder().apply(block).build())

/**
 * Gets information about a specified graph.
 */
public suspend inline fun NeptuneGraphClient.getGraph(crossinline block: GetGraphRequest.Builder.() -> Unit): GetGraphResponse = getGraph(GetGraphRequest.Builder().apply(block).build())

/**
 * Retrieves a specified graph snapshot.
 */
public suspend inline fun NeptuneGraphClient.getGraphSnapshot(crossinline block: GetGraphSnapshotRequest.Builder.() -> Unit): GetGraphSnapshotResponse = getGraphSnapshot(GetGraphSnapshotRequest.Builder().apply(block).build())

/**
 * Gets a graph summary for a property graph.
 */
public suspend inline fun NeptuneGraphClient.getGraphSummary(crossinline block: GetGraphSummaryRequest.Builder.() -> Unit): GetGraphSummaryResponse = getGraphSummary(GetGraphSummaryRequest.Builder().apply(block).build())

/**
 * Retrieves a specified import task.
 */
public suspend inline fun NeptuneGraphClient.getImportTask(crossinline block: GetImportTaskRequest.Builder.() -> Unit): GetImportTaskResponse = getImportTask(GetImportTaskRequest.Builder().apply(block).build())

/**
 * Retrieves information about a specified private endpoint.
 */
public suspend inline fun NeptuneGraphClient.getPrivateGraphEndpoint(crossinline block: GetPrivateGraphEndpointRequest.Builder.() -> Unit): GetPrivateGraphEndpointResponse = getPrivateGraphEndpoint(GetPrivateGraphEndpointRequest.Builder().apply(block).build())

/**
 * Retrieves the status of a specified query.
 *
 *  When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have the `neptune-graph:GetQueryStatus` IAM action attached.
 */
public suspend inline fun NeptuneGraphClient.getQuery(crossinline block: GetQueryRequest.Builder.() -> Unit): GetQueryResponse = getQuery(GetQueryRequest.Builder().apply(block).build())

/**
 * Lists available snapshots of a specified Neptune Analytics graph.
 */
public suspend inline fun NeptuneGraphClient.listGraphSnapshots(crossinline block: ListGraphSnapshotsRequest.Builder.() -> Unit): ListGraphSnapshotsResponse = listGraphSnapshots(ListGraphSnapshotsRequest.Builder().apply(block).build())

/**
 * Lists available Neptune Analytics graphs.
 */
public suspend inline fun NeptuneGraphClient.listGraphs(crossinline block: ListGraphsRequest.Builder.() -> Unit): ListGraphsResponse = listGraphs(ListGraphsRequest.Builder().apply(block).build())

/**
 * Lists import tasks.
 */
public suspend inline fun NeptuneGraphClient.listImportTasks(crossinline block: ListImportTasksRequest.Builder.() -> Unit): ListImportTasksResponse = listImportTasks(ListImportTasksRequest.Builder().apply(block).build())

/**
 * Lists private endpoints for a specified Neptune Analytics graph.
 */
public suspend inline fun NeptuneGraphClient.listPrivateGraphEndpoints(crossinline block: ListPrivateGraphEndpointsRequest.Builder.() -> Unit): ListPrivateGraphEndpointsResponse = listPrivateGraphEndpoints(ListPrivateGraphEndpointsRequest.Builder().apply(block).build())

/**
 * Lists active openCypher queries.
 */
public suspend inline fun NeptuneGraphClient.listQueries(crossinline block: ListQueriesRequest.Builder.() -> Unit): ListQueriesResponse = listQueries(ListQueriesRequest.Builder().apply(block).build())

/**
 * Lists tags associated with a specified resource.
 */
public suspend inline fun NeptuneGraphClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Empties the data from a specified Neptune Analytics graph.
 */
public suspend inline fun NeptuneGraphClient.resetGraph(crossinline block: ResetGraphRequest.Builder.() -> Unit): ResetGraphResponse = resetGraph(ResetGraphRequest.Builder().apply(block).build())

/**
 * Restores a graph from a snapshot.
 */
public suspend inline fun NeptuneGraphClient.restoreGraphFromSnapshot(crossinline block: RestoreGraphFromSnapshotRequest.Builder.() -> Unit): RestoreGraphFromSnapshotResponse = restoreGraphFromSnapshot(RestoreGraphFromSnapshotRequest.Builder().apply(block).build())

/**
 * Import data into existing Neptune Analytics graph from Amazon Simple Storage Service (S3). The graph needs to be empty and in the AVAILABLE state.
 */
public suspend inline fun NeptuneGraphClient.startImportTask(crossinline block: StartImportTaskRequest.Builder.() -> Unit): StartImportTaskResponse = startImportTask(StartImportTaskRequest.Builder().apply(block).build())

/**
 * Adds tags to the specified resource.
 */
public suspend inline fun NeptuneGraphClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified resource.
 */
public suspend inline fun NeptuneGraphClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the configuration of a specified Neptune Analytics graph
 */
public suspend inline fun NeptuneGraphClient.updateGraph(crossinline block: UpdateGraphRequest.Builder.() -> Unit): UpdateGraphResponse = updateGraph(UpdateGraphRequest.Builder().apply(block).build())
