// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.serde

import aws.sdk.kotlin.services.neptunegraph.model.RestoreGraphFromSnapshotRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class RestoreGraphFromSnapshotOperationSerializer: HttpSerialize<RestoreGraphFromSnapshotRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RestoreGraphFromSnapshotRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.snapshotIdentifier) { "snapshotIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("snapshots"))
                add(PercentEncoding.SmithyLabel.encode("${input.snapshotIdentifier}"))
                add(PercentEncoding.Path.encode("restore"))
            }
        }

        val payload = serializeRestoreGraphFromSnapshotOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeRestoreGraphFromSnapshotOperationBody(context: ExecutionContext, input: RestoreGraphFromSnapshotRequest): ByteArray {
    val serializer = JsonSerializer()
    val DELETIONPROTECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("deletionProtection"))
    val GRAPHNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("graphName"))
    val PROVISIONEDMEMORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("provisionedMemory"))
    val PUBLICCONNECTIVITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("publicConnectivity"))
    val REPLICACOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("replicaCount"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELETIONPROTECTION_DESCRIPTOR)
        field(GRAPHNAME_DESCRIPTOR)
        field(PROVISIONEDMEMORY_DESCRIPTOR)
        field(PUBLICCONNECTIVITY_DESCRIPTOR)
        field(REPLICACOUNT_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.deletionProtection?.let { field(DELETIONPROTECTION_DESCRIPTOR, it) }
        input.graphName?.let { field(GRAPHNAME_DESCRIPTOR, it) }
        input.provisionedMemory?.let { field(PROVISIONEDMEMORY_DESCRIPTOR, it) }
        input.publicConnectivity?.let { field(PUBLICCONNECTIVITY_DESCRIPTOR, it) }
        input.replicaCount?.let { field(REPLICACOUNT_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
