// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.serde

import aws.sdk.kotlin.services.neptunegraph.model.CancelImportTaskResponse
import aws.sdk.kotlin.services.neptunegraph.model.Format
import aws.sdk.kotlin.services.neptunegraph.model.ImportTaskStatus
import aws.sdk.kotlin.services.neptunegraph.model.NeptuneGraphException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CancelImportTaskOperationDeserializer: HttpDeserialize<CancelImportTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CancelImportTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCancelImportTaskError(context, call)
        }
        val builder = CancelImportTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCancelImportTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCancelImportTaskError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NeptuneGraphException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        else -> NeptuneGraphException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCancelImportTaskOperationBody(builder: CancelImportTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("format"))
    val GRAPHID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("graphId"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("source"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TASKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("taskId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FORMAT_DESCRIPTOR)
        field(GRAPHID_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TASKID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FORMAT_DESCRIPTOR.index -> builder.format = deserializeString().let { Format.fromValue(it) }
                GRAPHID_DESCRIPTOR.index -> builder.graphId = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SOURCE_DESCRIPTOR.index -> builder.source = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ImportTaskStatus.fromValue(it) }
                TASKID_DESCRIPTOR.index -> builder.taskId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
