// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model



public class RestoreGraphFromSnapshotRequest private constructor(builder: Builder) {
    /**
     * A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * A name for the new Neptune Analytics graph to be created from the snapshot.
     *
     * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val graphName: kotlin.String? = builder.graphName
    /**
     * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Min = 128
     */
    public val provisionedMemory: kotlin.Int? = builder.provisionedMemory
    /**
     * Specifies whether or not the graph can be reachable over the internet. All access to graphs IAM authenticated. (`true` to enable, or `false` to disable).
     */
    public val publicConnectivity: kotlin.Boolean? = builder.publicConnectivity
    /**
     * The number of replicas in other AZs. Min =0, Max = 2, Default =1
     */
    public val replicaCount: kotlin.Int? = builder.replicaCount
    /**
     * The ID of the snapshot in question.
     */
    public val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier
    /**
     * Adds metadata tags to the snapshot. These tags can also be used with cost allocation reporting, or used in a Condition statement in an IAM policy.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.RestoreGraphFromSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreGraphFromSnapshotRequest(")
        append("deletionProtection=$deletionProtection,")
        append("graphName=$graphName,")
        append("provisionedMemory=$provisionedMemory,")
        append("publicConnectivity=$publicConnectivity,")
        append("replicaCount=$replicaCount,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletionProtection?.hashCode() ?: 0
        result = 31 * result + (graphName?.hashCode() ?: 0)
        result = 31 * result + (provisionedMemory ?: 0)
        result = 31 * result + (publicConnectivity?.hashCode() ?: 0)
        result = 31 * result + (replicaCount ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreGraphFromSnapshotRequest

        if (deletionProtection != other.deletionProtection) return false
        if (graphName != other.graphName) return false
        if (provisionedMemory != other.provisionedMemory) return false
        if (publicConnectivity != other.publicConnectivity) return false
        if (replicaCount != other.replicaCount) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.RestoreGraphFromSnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * A name for the new Neptune Analytics graph to be created from the snapshot.
         *
         * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var graphName: kotlin.String? = null
        /**
         * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Min = 128
         */
        public var provisionedMemory: kotlin.Int? = null
        /**
         * Specifies whether or not the graph can be reachable over the internet. All access to graphs IAM authenticated. (`true` to enable, or `false` to disable).
         */
        public var publicConnectivity: kotlin.Boolean? = null
        /**
         * The number of replicas in other AZs. Min =0, Max = 2, Default =1
         */
        public var replicaCount: kotlin.Int? = null
        /**
         * The ID of the snapshot in question.
         */
        public var snapshotIdentifier: kotlin.String? = null
        /**
         * Adds metadata tags to the snapshot. These tags can also be used with cost allocation reporting, or used in a Condition statement in an IAM policy.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.RestoreGraphFromSnapshotRequest) : this() {
            this.deletionProtection = x.deletionProtection
            this.graphName = x.graphName
            this.provisionedMemory = x.provisionedMemory
            this.publicConnectivity = x.publicConnectivity
            this.replicaCount = x.replicaCount
            this.snapshotIdentifier = x.snapshotIdentifier
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.RestoreGraphFromSnapshotRequest = RestoreGraphFromSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
