// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model



/**
 * Options for how to import Neptune data.
 */
public class NeptuneImportOptions private constructor(builder: Builder) {
    /**
     * Neptune Analytics supports label-less vertices and no labels are assigned unless one is explicitly provided. Neptune assigns default labels when none is explicitly provided. When importing the data into Neptune Analytics, the default vertex labels can be omitted by setting *preserveDefaultVertexLabels* to false. Note that if the vertex only has default labels, and has no other properties or edges, then the vertex will effectively not get imported into Neptune Analytics when preserveDefaultVertexLabels is set to false.
     */
    public val preserveDefaultVertexLabels: kotlin.Boolean? = builder.preserveDefaultVertexLabels
    /**
     * Neptune Analytics currently does not support user defined edge ids. The edge ids are not imported by default. They are imported if *preserveEdgeIds* is set to true, and ids are stored as properties on the relationships with the property name *neptuneEdgeId*.
     */
    public val preserveEdgeIds: kotlin.Boolean? = builder.preserveEdgeIds
    /**
     * The KMS key to use to encrypt data in the S3 bucket where the graph data is exported
     */
    public val s3ExportKmsKeyId: kotlin.String = requireNotNull(builder.s3ExportKmsKeyId) { "A non-null value must be provided for s3ExportKmsKeyId" }
    /**
     * The path to an S3 bucket from which to import data.
     */
    public val s3ExportPath: kotlin.String = requireNotNull(builder.s3ExportPath) { "A non-null value must be provided for s3ExportPath" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.NeptuneImportOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NeptuneImportOptions(")
        append("preserveDefaultVertexLabels=$preserveDefaultVertexLabels,")
        append("preserveEdgeIds=$preserveEdgeIds,")
        append("s3ExportKmsKeyId=$s3ExportKmsKeyId,")
        append("s3ExportPath=$s3ExportPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = preserveDefaultVertexLabels?.hashCode() ?: 0
        result = 31 * result + (preserveEdgeIds?.hashCode() ?: 0)
        result = 31 * result + (s3ExportKmsKeyId.hashCode())
        result = 31 * result + (s3ExportPath.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NeptuneImportOptions

        if (preserveDefaultVertexLabels != other.preserveDefaultVertexLabels) return false
        if (preserveEdgeIds != other.preserveEdgeIds) return false
        if (s3ExportKmsKeyId != other.s3ExportKmsKeyId) return false
        if (s3ExportPath != other.s3ExportPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.NeptuneImportOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Neptune Analytics supports label-less vertices and no labels are assigned unless one is explicitly provided. Neptune assigns default labels when none is explicitly provided. When importing the data into Neptune Analytics, the default vertex labels can be omitted by setting *preserveDefaultVertexLabels* to false. Note that if the vertex only has default labels, and has no other properties or edges, then the vertex will effectively not get imported into Neptune Analytics when preserveDefaultVertexLabels is set to false.
         */
        public var preserveDefaultVertexLabels: kotlin.Boolean? = null
        /**
         * Neptune Analytics currently does not support user defined edge ids. The edge ids are not imported by default. They are imported if *preserveEdgeIds* is set to true, and ids are stored as properties on the relationships with the property name *neptuneEdgeId*.
         */
        public var preserveEdgeIds: kotlin.Boolean? = null
        /**
         * The KMS key to use to encrypt data in the S3 bucket where the graph data is exported
         */
        public var s3ExportKmsKeyId: kotlin.String? = null
        /**
         * The path to an S3 bucket from which to import data.
         */
        public var s3ExportPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.NeptuneImportOptions) : this() {
            this.preserveDefaultVertexLabels = x.preserveDefaultVertexLabels
            this.preserveEdgeIds = x.preserveEdgeIds
            this.s3ExportKmsKeyId = x.s3ExportKmsKeyId
            this.s3ExportPath = x.s3ExportPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.NeptuneImportOptions = NeptuneImportOptions(this)

        internal fun correctErrors(): Builder {
            if (s3ExportKmsKeyId == null) s3ExportKmsKeyId = ""
            if (s3ExportPath == null) s3ExportPath = ""
            return this
        }
    }
}
