// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model



/**
 * Summary details about a graph.
 */
public class GraphSummary private constructor(builder: Builder) {
    /**
     * The ARN associated with the graph.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * If `true`, deletion protection is enabled for the graph.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The graph endpoint.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The unique identifier of the graph.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The ID of the KMS key used to encrypt and decrypt graph data.
     */
    public val kmsKeyIdentifier: kotlin.String? = builder.kmsKeyIdentifier
    /**
     * The name of the graph.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The number of memory-optimized Neptune Capacity Units (m-NCUs) allocated to the graph.
     */
    public val provisionedMemory: kotlin.Int? = builder.provisionedMemory
    /**
     * If `true`, the graph has a public endpoint, otherwise not.
     */
    public val publicConnectivity: kotlin.Boolean? = builder.publicConnectivity
    /**
     * The number of replicas for the graph.
     */
    public val replicaCount: kotlin.Int? = builder.replicaCount
    /**
     * The status of the graph.
     */
    public val status: aws.sdk.kotlin.services.neptunegraph.model.GraphStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.GraphSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GraphSummary(")
        append("arn=$arn,")
        append("deletionProtection=$deletionProtection,")
        append("endpoint=$endpoint,")
        append("id=$id,")
        append("kmsKeyIdentifier=$kmsKeyIdentifier,")
        append("name=$name,")
        append("provisionedMemory=$provisionedMemory,")
        append("publicConnectivity=$publicConnectivity,")
        append("replicaCount=$replicaCount,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (kmsKeyIdentifier?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (provisionedMemory ?: 0)
        result = 31 * result + (publicConnectivity?.hashCode() ?: 0)
        result = 31 * result + (replicaCount ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GraphSummary

        if (arn != other.arn) return false
        if (deletionProtection != other.deletionProtection) return false
        if (endpoint != other.endpoint) return false
        if (id != other.id) return false
        if (kmsKeyIdentifier != other.kmsKeyIdentifier) return false
        if (name != other.name) return false
        if (provisionedMemory != other.provisionedMemory) return false
        if (publicConnectivity != other.publicConnectivity) return false
        if (replicaCount != other.replicaCount) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.GraphSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN associated with the graph.
         */
        public var arn: kotlin.String? = null
        /**
         * If `true`, deletion protection is enabled for the graph.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The graph endpoint.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The unique identifier of the graph.
         */
        public var id: kotlin.String? = null
        /**
         * The ID of the KMS key used to encrypt and decrypt graph data.
         */
        public var kmsKeyIdentifier: kotlin.String? = null
        /**
         * The name of the graph.
         */
        public var name: kotlin.String? = null
        /**
         * The number of memory-optimized Neptune Capacity Units (m-NCUs) allocated to the graph.
         */
        public var provisionedMemory: kotlin.Int? = null
        /**
         * If `true`, the graph has a public endpoint, otherwise not.
         */
        public var publicConnectivity: kotlin.Boolean? = null
        /**
         * The number of replicas for the graph.
         */
        public var replicaCount: kotlin.Int? = null
        /**
         * The status of the graph.
         */
        public var status: aws.sdk.kotlin.services.neptunegraph.model.GraphStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.GraphSummary) : this() {
            this.arn = x.arn
            this.deletionProtection = x.deletionProtection
            this.endpoint = x.endpoint
            this.id = x.id
            this.kmsKeyIdentifier = x.kmsKeyIdentifier
            this.name = x.name
            this.provisionedMemory = x.provisionedMemory
            this.publicConnectivity = x.publicConnectivity
            this.replicaCount = x.replicaCount
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.GraphSummary = GraphSummary(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
