// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model



/**
 * Summary information about the graph.
 */
public class GraphDataSummary private constructor(builder: Builder) {
    /**
     * A list of the edge labels in the graph.
     */
    public val edgeLabels: List<String>? = builder.edgeLabels
    /**
     * A list of the distinct edge properties in the graph, along with the count of edges where each property is used.
     */
    public val edgeProperties: List<Map<String, Long>>? = builder.edgeProperties
    /**
     * This field is only present when the requested mode is DETAILED. It contains a list of edge structures.
     */
    public val edgeStructures: List<EdgeStructure>? = builder.edgeStructures
    /**
     * A list of distinct node labels in the graph.
     */
    public val nodeLabels: List<String>? = builder.nodeLabels
    /**
     * A list of the distinct node properties in the graph, along with the count of nodes where each property is used.
     */
    public val nodeProperties: List<Map<String, Long>>? = builder.nodeProperties
    /**
     * This field is only present when the requested mode is DETAILED. It contains a list of node structures.
     */
    public val nodeStructures: List<NodeStructure>? = builder.nodeStructures
    /**
     * The number of unique edge labels in the graph.
     */
    public val numEdgeLabels: kotlin.Long? = builder.numEdgeLabels
    /**
     * The number of edge properties in the graph.
     */
    public val numEdgeProperties: kotlin.Long? = builder.numEdgeProperties
    /**
     * The number of edges in the graph.
     */
    public val numEdges: kotlin.Long? = builder.numEdges
    /**
     * The number of distinct node labels in the graph.
     */
    public val numNodeLabels: kotlin.Long? = builder.numNodeLabels
    /**
     * The number of distinct node properties in the graph.
     */
    public val numNodeProperties: kotlin.Long? = builder.numNodeProperties
    /**
     * The number of nodes in the graph.
     */
    public val numNodes: kotlin.Long? = builder.numNodes
    /**
     * The total number of usages of all edge properties.
     */
    public val totalEdgePropertyValues: kotlin.Long? = builder.totalEdgePropertyValues
    /**
     * The total number of usages of all node properties.
     */
    public val totalNodePropertyValues: kotlin.Long? = builder.totalNodePropertyValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.GraphDataSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GraphDataSummary(")
        append("edgeLabels=$edgeLabels,")
        append("edgeProperties=$edgeProperties,")
        append("edgeStructures=$edgeStructures,")
        append("nodeLabels=$nodeLabels,")
        append("nodeProperties=$nodeProperties,")
        append("nodeStructures=$nodeStructures,")
        append("numEdgeLabels=$numEdgeLabels,")
        append("numEdgeProperties=$numEdgeProperties,")
        append("numEdges=$numEdges,")
        append("numNodeLabels=$numNodeLabels,")
        append("numNodeProperties=$numNodeProperties,")
        append("numNodes=$numNodes,")
        append("totalEdgePropertyValues=$totalEdgePropertyValues,")
        append("totalNodePropertyValues=$totalNodePropertyValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = edgeLabels?.hashCode() ?: 0
        result = 31 * result + (edgeProperties?.hashCode() ?: 0)
        result = 31 * result + (edgeStructures?.hashCode() ?: 0)
        result = 31 * result + (nodeLabels?.hashCode() ?: 0)
        result = 31 * result + (nodeProperties?.hashCode() ?: 0)
        result = 31 * result + (nodeStructures?.hashCode() ?: 0)
        result = 31 * result + (numEdgeLabels?.hashCode() ?: 0)
        result = 31 * result + (numEdgeProperties?.hashCode() ?: 0)
        result = 31 * result + (numEdges?.hashCode() ?: 0)
        result = 31 * result + (numNodeLabels?.hashCode() ?: 0)
        result = 31 * result + (numNodeProperties?.hashCode() ?: 0)
        result = 31 * result + (numNodes?.hashCode() ?: 0)
        result = 31 * result + (totalEdgePropertyValues?.hashCode() ?: 0)
        result = 31 * result + (totalNodePropertyValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GraphDataSummary

        if (edgeLabels != other.edgeLabels) return false
        if (edgeProperties != other.edgeProperties) return false
        if (edgeStructures != other.edgeStructures) return false
        if (nodeLabels != other.nodeLabels) return false
        if (nodeProperties != other.nodeProperties) return false
        if (nodeStructures != other.nodeStructures) return false
        if (numEdgeLabels != other.numEdgeLabels) return false
        if (numEdgeProperties != other.numEdgeProperties) return false
        if (numEdges != other.numEdges) return false
        if (numNodeLabels != other.numNodeLabels) return false
        if (numNodeProperties != other.numNodeProperties) return false
        if (numNodes != other.numNodes) return false
        if (totalEdgePropertyValues != other.totalEdgePropertyValues) return false
        if (totalNodePropertyValues != other.totalNodePropertyValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.GraphDataSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of the edge labels in the graph.
         */
        public var edgeLabels: List<String>? = null
        /**
         * A list of the distinct edge properties in the graph, along with the count of edges where each property is used.
         */
        public var edgeProperties: List<Map<String, Long>>? = null
        /**
         * This field is only present when the requested mode is DETAILED. It contains a list of edge structures.
         */
        public var edgeStructures: List<EdgeStructure>? = null
        /**
         * A list of distinct node labels in the graph.
         */
        public var nodeLabels: List<String>? = null
        /**
         * A list of the distinct node properties in the graph, along with the count of nodes where each property is used.
         */
        public var nodeProperties: List<Map<String, Long>>? = null
        /**
         * This field is only present when the requested mode is DETAILED. It contains a list of node structures.
         */
        public var nodeStructures: List<NodeStructure>? = null
        /**
         * The number of unique edge labels in the graph.
         */
        public var numEdgeLabels: kotlin.Long? = null
        /**
         * The number of edge properties in the graph.
         */
        public var numEdgeProperties: kotlin.Long? = null
        /**
         * The number of edges in the graph.
         */
        public var numEdges: kotlin.Long? = null
        /**
         * The number of distinct node labels in the graph.
         */
        public var numNodeLabels: kotlin.Long? = null
        /**
         * The number of distinct node properties in the graph.
         */
        public var numNodeProperties: kotlin.Long? = null
        /**
         * The number of nodes in the graph.
         */
        public var numNodes: kotlin.Long? = null
        /**
         * The total number of usages of all edge properties.
         */
        public var totalEdgePropertyValues: kotlin.Long? = null
        /**
         * The total number of usages of all node properties.
         */
        public var totalNodePropertyValues: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.GraphDataSummary) : this() {
            this.edgeLabels = x.edgeLabels
            this.edgeProperties = x.edgeProperties
            this.edgeStructures = x.edgeStructures
            this.nodeLabels = x.nodeLabels
            this.nodeProperties = x.nodeProperties
            this.nodeStructures = x.nodeStructures
            this.numEdgeLabels = x.numEdgeLabels
            this.numEdgeProperties = x.numEdgeProperties
            this.numEdges = x.numEdges
            this.numNodeLabels = x.numNodeLabels
            this.numNodeProperties = x.numNodeProperties
            this.numNodes = x.numNodes
            this.totalEdgePropertyValues = x.totalEdgePropertyValues
            this.totalNodePropertyValues = x.totalNodePropertyValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.GraphDataSummary = GraphDataSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
