// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.model



public class ExecuteQueryRequest private constructor(builder: Builder) {
    /**
     * The explain mode parameter returns a query explain instead of the actual query results. A query explain can be used to gather insights about the query execution such as planning decisions, time spent on each operator, solutions flowing etc.
     */
    public val explainMode: aws.sdk.kotlin.services.neptunegraph.model.ExplainMode? = builder.explainMode
    /**
     * The unique identifier of the Neptune Analytics graph.
     */
    public val graphIdentifier: kotlin.String? = builder.graphIdentifier
    /**
     * The query language the query is written in. Currently only openCypher is supported.
     */
    public val language: aws.sdk.kotlin.services.neptunegraph.model.QueryLanguage? = builder.language
    /**
     * Query plan cache is a feature that saves the query plan and reuses it on successive executions of the same query. This reduces query latency, and works for both `READ` and `UPDATE` queries. The plan cache is an LRU cache with a 5 minute TTL and a capacity of 1000.
     */
    public val planCache: aws.sdk.kotlin.services.neptunegraph.model.PlanCacheType? = builder.planCache
    /**
     * The query string to be executed.
     */
    public val queryString: kotlin.String? = builder.queryString
    /**
     * Specifies the query timeout duration, in milliseconds. (optional)
     */
    public val queryTimeoutMilliseconds: kotlin.Int? = builder.queryTimeoutMilliseconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunegraph.model.ExecuteQueryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecuteQueryRequest(")
        append("explainMode=$explainMode,")
        append("graphIdentifier=$graphIdentifier,")
        append("language=$language,")
        append("planCache=$planCache,")
        append("queryString=$queryString,")
        append("queryTimeoutMilliseconds=$queryTimeoutMilliseconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = explainMode?.hashCode() ?: 0
        result = 31 * result + (graphIdentifier?.hashCode() ?: 0)
        result = 31 * result + (language?.hashCode() ?: 0)
        result = 31 * result + (planCache?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (queryTimeoutMilliseconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecuteQueryRequest

        if (explainMode != other.explainMode) return false
        if (graphIdentifier != other.graphIdentifier) return false
        if (language != other.language) return false
        if (planCache != other.planCache) return false
        if (queryString != other.queryString) return false
        if (queryTimeoutMilliseconds != other.queryTimeoutMilliseconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunegraph.model.ExecuteQueryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The explain mode parameter returns a query explain instead of the actual query results. A query explain can be used to gather insights about the query execution such as planning decisions, time spent on each operator, solutions flowing etc.
         */
        public var explainMode: aws.sdk.kotlin.services.neptunegraph.model.ExplainMode? = null
        /**
         * The unique identifier of the Neptune Analytics graph.
         */
        public var graphIdentifier: kotlin.String? = null
        /**
         * The query language the query is written in. Currently only openCypher is supported.
         */
        public var language: aws.sdk.kotlin.services.neptunegraph.model.QueryLanguage? = null
        /**
         * Query plan cache is a feature that saves the query plan and reuses it on successive executions of the same query. This reduces query latency, and works for both `READ` and `UPDATE` queries. The plan cache is an LRU cache with a 5 minute TTL and a capacity of 1000.
         */
        public var planCache: aws.sdk.kotlin.services.neptunegraph.model.PlanCacheType? = null
        /**
         * The query string to be executed.
         */
        public var queryString: kotlin.String? = null
        /**
         * Specifies the query timeout duration, in milliseconds. (optional)
         */
        public var queryTimeoutMilliseconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunegraph.model.ExecuteQueryRequest) : this() {
            this.explainMode = x.explainMode
            this.graphIdentifier = x.graphIdentifier
            this.language = x.language
            this.planCache = x.planCache
            this.queryString = x.queryString
            this.queryTimeoutMilliseconds = x.queryTimeoutMilliseconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunegraph.model.ExecuteQueryRequest = ExecuteQueryRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
