// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunegraph.endpoints.internal

import aws.sdk.kotlin.services.neptunegraph.NeptuneGraphClient
import aws.sdk.kotlin.services.neptunegraph.endpoints.NeptuneGraphEndpointParameters
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.collections.get
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest

internal class EndpointResolverAdapter(
    private val config: NeptuneGraphClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = resolveEndpointParams(config, request)
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        return endpoint
    }
}

internal fun resolveEndpointParams(config: NeptuneGraphClient.Config, request: ResolveEndpointRequest): NeptuneGraphEndpointParameters {
    return NeptuneGraphEndpointParameters {
        region = config.region
        bindAwsBuiltins(config, request)
        endpoint = config.endpointUrl?.toString()
        val opName = request.context[SdkClientOption.OperationName]
        opContextBindings[opName]?.invoke(this, request)
    }
}
private typealias BindOperationContextParamsFn = (NeptuneGraphEndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
    "CancelImportTask" to ::bindCancelImportTaskEndpointContext,
    "CancelQuery" to ::bindCancelQueryEndpointContext,
    "CreateGraph" to ::bindCreateGraphEndpointContext,
    "CreateGraphSnapshot" to ::bindCreateGraphSnapshotEndpointContext,
    "CreateGraphUsingImportTask" to ::bindCreateGraphUsingImportTaskEndpointContext,
    "CreatePrivateGraphEndpoint" to ::bindCreatePrivateGraphEndpointEndpointContext,
    "DeleteGraph" to ::bindDeleteGraphEndpointContext,
    "DeleteGraphSnapshot" to ::bindDeleteGraphSnapshotEndpointContext,
    "DeletePrivateGraphEndpoint" to ::bindDeletePrivateGraphEndpointEndpointContext,
    "ExecuteQuery" to ::bindExecuteQueryEndpointContext,
    "GetGraph" to ::bindGetGraphEndpointContext,
    "GetGraphSnapshot" to ::bindGetGraphSnapshotEndpointContext,
    "GetGraphSummary" to ::bindGetGraphSummaryEndpointContext,
    "GetImportTask" to ::bindGetImportTaskEndpointContext,
    "GetPrivateGraphEndpoint" to ::bindGetPrivateGraphEndpointEndpointContext,
    "GetQuery" to ::bindGetQueryEndpointContext,
    "ListGraphs" to ::bindListGraphsEndpointContext,
    "ListGraphSnapshots" to ::bindListGraphSnapshotsEndpointContext,
    "ListImportTasks" to ::bindListImportTasksEndpointContext,
    "ListPrivateGraphEndpoints" to ::bindListPrivateGraphEndpointsEndpointContext,
    "ListQueries" to ::bindListQueriesEndpointContext,
    "ListTagsForResource" to ::bindListTagsForResourceEndpointContext,
    "ResetGraph" to ::bindResetGraphEndpointContext,
    "RestoreGraphFromSnapshot" to ::bindRestoreGraphFromSnapshotEndpointContext,
    "TagResource" to ::bindTagResourceEndpointContext,
    "UntagResource" to ::bindUntagResourceEndpointContext,
    "UpdateGraph" to ::bindUpdateGraphEndpointContext,
)

private fun NeptuneGraphEndpointParameters.Builder.bindAwsBuiltins(config: NeptuneGraphClient.Config, request: ResolveEndpointRequest) {
    useFips = config.useFips
    useDualStack = config.useDualStack
}

private fun bindCancelImportTaskEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindCancelQueryEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "DataPlane"
}

private fun bindCreateGraphEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindCreateGraphSnapshotEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindCreateGraphUsingImportTaskEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindCreatePrivateGraphEndpointEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindDeleteGraphEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindDeleteGraphSnapshotEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindDeletePrivateGraphEndpointEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindExecuteQueryEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "DataPlane"
}

private fun bindGetGraphEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindGetGraphSnapshotEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindGetGraphSummaryEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "DataPlane"
}

private fun bindGetImportTaskEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindGetPrivateGraphEndpointEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindGetQueryEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "DataPlane"
}

private fun bindListGraphsEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindListGraphSnapshotsEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindListImportTasksEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindListPrivateGraphEndpointsEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindListQueriesEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "DataPlane"
}

private fun bindListTagsForResourceEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindResetGraphEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindRestoreGraphFromSnapshotEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindTagResourceEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindUntagResourceEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}

private fun bindUpdateGraphEndpointContext(builder: NeptuneGraphEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    builder.apiType = "ControlPlane"
}
