// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata.serde

import aws.sdk.kotlin.services.neptunedata.model.GetPropertygraphStreamResponse
import aws.sdk.kotlin.services.neptunedata.model.NeptunedataException
import aws.sdk.kotlin.services.neptunedata.model.PropertygraphRecord
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetPropertygraphStreamOperationDeserializer: HttpDeserializer.NonStreaming<GetPropertygraphStreamResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetPropertygraphStreamResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPropertygraphStreamError(context, call, payload)
        }
        val builder = GetPropertygraphStreamResponse.Builder()

        if (payload != null) {
            deserializeGetPropertygraphStreamOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetPropertygraphStreamError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NeptunedataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClientTimeoutException" -> ClientTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConstraintViolationException" -> ConstraintViolationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ExpiredStreamException" -> ExpiredStreamExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MemoryLimitExceededException" -> MemoryLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PreconditionsFailedException" -> PreconditionsFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "StreamRecordsNotFoundException" -> StreamRecordsNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptunedataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPropertygraphStreamOperationBody(builder: GetPropertygraphStreamResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("format"))
    val LASTEVENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("lastEventId"))
    val LASTTRXTIMESTAMPINMILLIS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("lastTrxTimestamp"))
    val RECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("records"))
    val TOTALRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("totalRecords"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FORMAT_DESCRIPTOR)
        field(LASTEVENTID_DESCRIPTOR)
        field(LASTTRXTIMESTAMPINMILLIS_DESCRIPTOR)
        field(RECORDS_DESCRIPTOR)
        field(TOTALRECORDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FORMAT_DESCRIPTOR.index -> builder.format = deserializeString()
                LASTEVENTID_DESCRIPTOR.index -> builder.lastEventId =
                    deserializer.deserializeMap(LASTEVENTID_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                LASTTRXTIMESTAMPINMILLIS_DESCRIPTOR.index -> builder.lastTrxTimestampInMillis = deserializeLong()
                RECORDS_DESCRIPTOR.index -> builder.records =
                    deserializer.deserializeList(RECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<PropertygraphRecord>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePropertygraphRecordDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TOTALRECORDS_DESCRIPTOR.index -> builder.totalRecords = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
