// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata.serde

import aws.sdk.kotlin.services.neptunedata.model.GetOpenCypherQueryStatusResponse
import aws.sdk.kotlin.services.neptunedata.model.NeptunedataException
import aws.sdk.kotlin.services.neptunedata.model.QueryEvalStats
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetOpenCypherQueryStatusOperationDeserializer: HttpDeserializer.NonStreaming<GetOpenCypherQueryStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetOpenCypherQueryStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetOpenCypherQueryStatusError(context, call, payload)
        }
        val builder = GetOpenCypherQueryStatusResponse.Builder()

        if (payload != null) {
            deserializeGetOpenCypherQueryStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetOpenCypherQueryStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NeptunedataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ClientTimeoutException" -> ClientTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConstraintViolationException" -> ConstraintViolationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FailureByQueryException" -> FailureByQueryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidNumericDataException" -> InvalidNumericDataExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MissingParameterException" -> MissingParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ParsingException" -> ParsingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PreconditionsFailedException" -> PreconditionsFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ReadOnlyViolationException" -> ReadOnlyViolationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TimeLimitExceededException" -> TimeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptunedataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetOpenCypherQueryStatusOperationBody(builder: GetOpenCypherQueryStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val QUERYEVALSTATS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("queryEvalStats"))
    val QUERYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryId"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryString"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(QUERYEVALSTATS_DESCRIPTOR)
        field(QUERYID_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                QUERYEVALSTATS_DESCRIPTOR.index -> builder.queryEvalStats = deserializeQueryEvalStatsDocument(deserializer)
                QUERYID_DESCRIPTOR.index -> builder.queryId = deserializeString()
                QUERYSTRING_DESCRIPTOR.index -> builder.queryString = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
