// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata.serde

import aws.sdk.kotlin.services.neptunedata.model.GetMlModelTransformJobResponse
import aws.sdk.kotlin.services.neptunedata.model.MlConfigDefinition
import aws.sdk.kotlin.services.neptunedata.model.MlResourceDefinition
import aws.sdk.kotlin.services.neptunedata.model.NeptunedataException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetMLModelTransformJobOperationDeserializer: HttpDeserializer.NonStreaming<GetMlModelTransformJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetMlModelTransformJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMlModelTransformJobError(context, call, payload)
        }
        val builder = GetMlModelTransformJobResponse.Builder()

        if (payload != null) {
            deserializeGetMLModelTransformJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetMlModelTransformJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NeptunedataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ClientTimeoutException" -> ClientTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConstraintViolationException" -> ConstraintViolationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MissingParameterException" -> MissingParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MLResourceNotFoundException" -> MlResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PreconditionsFailedException" -> PreconditionsFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptunedataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMLModelTransformJobOperationBody(builder: GetMlModelTransformJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASEPROCESSINGJOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("baseProcessingJob"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val MODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("models"))
    val REMOTEMODELTRANSFORMJOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("remoteModelTransformJob"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASEPROCESSINGJOB_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(MODELS_DESCRIPTOR)
        field(REMOTEMODELTRANSFORMJOB_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASEPROCESSINGJOB_DESCRIPTOR.index -> builder.baseProcessingJob = deserializeMlResourceDefinitionDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                MODELS_DESCRIPTOR.index -> builder.models =
                    deserializer.deserializeList(MODELS_DESCRIPTOR) {
                        val col0 = mutableListOf<MlConfigDefinition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMlConfigDefinitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REMOTEMODELTRANSFORMJOB_DESCRIPTOR.index -> builder.remoteModelTransformJob = deserializeMlResourceDefinitionDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
