// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata.serde

import aws.sdk.kotlin.services.neptunedata.model.GetEngineStatusResponse
import aws.sdk.kotlin.services.neptunedata.model.NeptunedataException
import aws.sdk.kotlin.services.neptunedata.model.QueryLanguageVersion
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.content.Document
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class GetEngineStatusOperationDeserializer: HttpDeserializer.NonStreaming<GetEngineStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetEngineStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetEngineStatusError(context, call, payload)
        }
        val builder = GetEngineStatusResponse.Builder()

        if (payload != null) {
            deserializeGetEngineStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetEngineStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NeptunedataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClientTimeoutException" -> ClientTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConstraintViolationException" -> ConstraintViolationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PreconditionsFailedException" -> PreconditionsFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptunedataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEngineStatusOperationBody(builder: GetEngineStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DBENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dbEngineVersion"))
    val DFEQUERYENGINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dfeQueryEngine"))
    val FEATURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("features"))
    val GREMLIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("gremlin"))
    val LABMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("labMode"))
    val OPENCYPHER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("opencypher"))
    val ROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("role"))
    val ROLLINGBACKTRXCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("rollingBackTrxCount"))
    val ROLLINGBACKTRXEARLIESTSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("rollingBackTrxEarliestStartTime"))
    val SETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("settings"))
    val SPARQL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sparql"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DBENGINEVERSION_DESCRIPTOR)
        field(DFEQUERYENGINE_DESCRIPTOR)
        field(FEATURES_DESCRIPTOR)
        field(GREMLIN_DESCRIPTOR)
        field(LABMODE_DESCRIPTOR)
        field(OPENCYPHER_DESCRIPTOR)
        field(ROLE_DESCRIPTOR)
        field(ROLLINGBACKTRXCOUNT_DESCRIPTOR)
        field(ROLLINGBACKTRXEARLIESTSTARTTIME_DESCRIPTOR)
        field(SETTINGS_DESCRIPTOR)
        field(SPARQL_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBENGINEVERSION_DESCRIPTOR.index -> builder.dbEngineVersion = deserializeString()
                DFEQUERYENGINE_DESCRIPTOR.index -> builder.dfeQueryEngine = deserializeString()
                FEATURES_DESCRIPTOR.index -> builder.features =
                    deserializer.deserializeMap(FEATURES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Document>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeDocument() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                GREMLIN_DESCRIPTOR.index -> builder.gremlin = deserializeQueryLanguageVersionDocument(deserializer)
                LABMODE_DESCRIPTOR.index -> builder.labMode =
                    deserializer.deserializeMap(LABMODE_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                OPENCYPHER_DESCRIPTOR.index -> builder.opencypher = deserializeQueryLanguageVersionDocument(deserializer)
                ROLE_DESCRIPTOR.index -> builder.role = deserializeString()
                ROLLINGBACKTRXCOUNT_DESCRIPTOR.index -> builder.rollingBackTrxCount = deserializeInt()
                ROLLINGBACKTRXEARLIESTSTARTTIME_DESCRIPTOR.index -> builder.rollingBackTrxEarliestStartTime = deserializeString()
                SETTINGS_DESCRIPTOR.index -> builder.settings =
                    deserializer.deserializeMap(SETTINGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SPARQL_DESCRIPTOR.index -> builder.sparql = deserializeQueryLanguageVersionDocument(deserializer)
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
