// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata.serde

import aws.sdk.kotlin.services.neptunedata.model.ExecuteGremlinProfileQueryResponse
import aws.sdk.kotlin.services.neptunedata.model.NeptunedataException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class ExecuteGremlinProfileQueryOperationDeserializer: HttpDeserializer.NonStreaming<ExecuteGremlinProfileQueryResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ExecuteGremlinProfileQueryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwExecuteGremlinProfileQueryError(context, call, payload)
        }
        val builder = ExecuteGremlinProfileQueryResponse.Builder()

        builder.output = payload

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwExecuteGremlinProfileQueryError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NeptunedataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CancelledByUserException" -> CancelledByUserExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ClientTimeoutException" -> ClientTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConstraintViolationException" -> ConstraintViolationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FailureByQueryException" -> FailureByQueryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MalformedQueryException" -> MalformedQueryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MemoryLimitExceededException" -> MemoryLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MissingParameterException" -> MissingParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ParsingException" -> ParsingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PreconditionsFailedException" -> PreconditionsFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "QueryLimitExceededException" -> QueryLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "QueryLimitException" -> QueryLimitExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "QueryTooLargeException" -> QueryTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TimeLimitExceededException" -> TimeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptunedataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
