// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains statistics information. The DFE engine uses information about the data in your Neptune graph to make effective trade-offs when planning query execution. This information takes the form of statistics that include so-called characteristic sets and predicate statistics that can guide query planning. See [Managing statistics for the Neptune DFE to use](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-dfe-statistics.html).
 */
public class Statistics private constructor(builder: Builder) {
    /**
     * Indicates whether or not DFE statistics generation is enabled at all.
     */
    public val active: kotlin.Boolean? = builder.active
    /**
     * Indicates whether or not automatic statistics generation is enabled.
     */
    public val autoCompute: kotlin.Boolean? = builder.autoCompute
    /**
     * The UTC time at which DFE statistics have most recently been generated.
     */
    public val date: aws.smithy.kotlin.runtime.time.Instant? = builder.date
    /**
     * A note about problems in the case where statistics are invalid.
     */
    public val note: kotlin.String? = builder.note
    /**
     * A StatisticsSummary structure that contains:
     * + `signatureCount` - The total number of signatures across all characteristic sets.
     * + `instanceCount` - The total number of characteristic-set instances.
     * + `predicateCount` - The total number of unique predicates.
     */
    public val signatureInfo: aws.sdk.kotlin.services.neptunedata.model.StatisticsSummary? = builder.signatureInfo
    /**
     * Reports the ID of the current statistics generation run. A value of -1 indicates that no statistics have been generated.
     */
    public val statisticsId: kotlin.String? = builder.statisticsId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunedata.model.Statistics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Statistics(")
        append("active=$active,")
        append("autoCompute=$autoCompute,")
        append("date=$date,")
        append("note=$note,")
        append("signatureInfo=$signatureInfo,")
        append("statisticsId=$statisticsId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = active?.hashCode() ?: 0
        result = 31 * result + (autoCompute?.hashCode() ?: 0)
        result = 31 * result + (date?.hashCode() ?: 0)
        result = 31 * result + (note?.hashCode() ?: 0)
        result = 31 * result + (signatureInfo?.hashCode() ?: 0)
        result = 31 * result + (statisticsId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Statistics

        if (active != other.active) return false
        if (autoCompute != other.autoCompute) return false
        if (date != other.date) return false
        if (note != other.note) return false
        if (signatureInfo != other.signatureInfo) return false
        if (statisticsId != other.statisticsId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunedata.model.Statistics = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether or not DFE statistics generation is enabled at all.
         */
        public var active: kotlin.Boolean? = null
        /**
         * Indicates whether or not automatic statistics generation is enabled.
         */
        public var autoCompute: kotlin.Boolean? = null
        /**
         * The UTC time at which DFE statistics have most recently been generated.
         */
        public var date: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A note about problems in the case where statistics are invalid.
         */
        public var note: kotlin.String? = null
        /**
         * A StatisticsSummary structure that contains:
         * + `signatureCount` - The total number of signatures across all characteristic sets.
         * + `instanceCount` - The total number of characteristic-set instances.
         * + `predicateCount` - The total number of unique predicates.
         */
        public var signatureInfo: aws.sdk.kotlin.services.neptunedata.model.StatisticsSummary? = null
        /**
         * Reports the ID of the current statistics generation run. A value of -1 indicates that no statistics have been generated.
         */
        public var statisticsId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunedata.model.Statistics) : this() {
            this.active = x.active
            this.autoCompute = x.autoCompute
            this.date = x.date
            this.note = x.note
            this.signatureInfo = x.signatureInfo
            this.statisticsId = x.statisticsId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunedata.model.Statistics = Statistics(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptunedata.model.StatisticsSummary] inside the given [block]
         */
        public fun signatureInfo(block: aws.sdk.kotlin.services.neptunedata.model.StatisticsSummary.Builder.() -> kotlin.Unit) {
            this.signatureInfo = aws.sdk.kotlin.services.neptunedata.model.StatisticsSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
