// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartMlModelTransformJobRequest private constructor(builder: Builder) {
    /**
     * The type of ML instance used in preparing and managing training of ML models. This is an ML compute instance chosen based on memory requirements for processing the training data and model.
     */
    public val baseProcessingInstanceType: kotlin.String? = builder.baseProcessingInstanceType
    /**
     * The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the output model are stored on disk, so the volume size must be large enough to hold both data sets. If not specified or 0, Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
     */
    public val baseProcessingInstanceVolumeSizeInGb: kotlin.Int? = builder.baseProcessingInstanceVolumeSizeInGb
    /**
     * Configuration information for a model transform using a custom model. The `customModelTransformParameters` object contains the following fields, which must have values compatible with the saved model parameters from the training job:
     */
    public val customModelTransformParameters: aws.sdk.kotlin.services.neptunedata.model.CustomModelTransformParameters? = builder.customModelTransformParameters
    /**
     * The job ID of a completed data-processing job. You must include either `dataProcessingJobId` and a `mlModelTrainingJobId`, or a `trainingJobName`.
     */
    public val dataProcessingJobId: kotlin.String? = builder.dataProcessingJobId
    /**
     * A unique identifier for the new job. The default is an autogenerated UUID.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The job ID of a completed model-training job. You must include either `dataProcessingJobId` and a `mlModelTrainingJobId`, or a `trainingJobName`.
     */
    public val mlModelTrainingJobId: kotlin.String? = builder.mlModelTrainingJobId
    /**
     * The location in Amazon S3 where the model artifacts are to be stored.
     */
    public val modelTransformOutputS3Location: kotlin.String? = builder.modelTransformOutputS3Location
    /**
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.
     */
    public val neptuneIamRoleArn: kotlin.String? = builder.neptuneIamRoleArn
    /**
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The default is none.
     */
    public val s3OutputEncryptionKmsKey: kotlin.String? = builder.s3OutputEncryptionKmsKey
    /**
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an error will occur.
     */
    public val sagemakerIamRoleArn: kotlin.String? = builder.sagemakerIamRoleArn
    /**
     * The VPC security group IDs. The default is None.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The IDs of the subnets in the Neptune VPC. The default is None.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * The name of a completed SageMaker training job. You must include either `dataProcessingJobId` and a `mlModelTrainingJobId`, or a `trainingJobName`.
     */
    public val trainingJobName: kotlin.String? = builder.trainingJobName
    /**
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instances that run the training job. The default is None.
     */
    public val volumeEncryptionKmsKey: kotlin.String? = builder.volumeEncryptionKmsKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunedata.model.StartMlModelTransformJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartMlModelTransformJobRequest(")
        append("baseProcessingInstanceType=$baseProcessingInstanceType,")
        append("baseProcessingInstanceVolumeSizeInGb=$baseProcessingInstanceVolumeSizeInGb,")
        append("customModelTransformParameters=$customModelTransformParameters,")
        append("dataProcessingJobId=$dataProcessingJobId,")
        append("id=$id,")
        append("mlModelTrainingJobId=$mlModelTrainingJobId,")
        append("modelTransformOutputS3Location=$modelTransformOutputS3Location,")
        append("neptuneIamRoleArn=$neptuneIamRoleArn,")
        append("s3OutputEncryptionKmsKey=$s3OutputEncryptionKmsKey,")
        append("sagemakerIamRoleArn=$sagemakerIamRoleArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnets=$subnets,")
        append("trainingJobName=$trainingJobName,")
        append("volumeEncryptionKmsKey=$volumeEncryptionKmsKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseProcessingInstanceType?.hashCode() ?: 0
        result = 31 * result + (baseProcessingInstanceVolumeSizeInGb ?: 0)
        result = 31 * result + (customModelTransformParameters?.hashCode() ?: 0)
        result = 31 * result + (dataProcessingJobId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (mlModelTrainingJobId?.hashCode() ?: 0)
        result = 31 * result + (modelTransformOutputS3Location?.hashCode() ?: 0)
        result = 31 * result + (neptuneIamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (s3OutputEncryptionKmsKey?.hashCode() ?: 0)
        result = 31 * result + (sagemakerIamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (trainingJobName?.hashCode() ?: 0)
        result = 31 * result + (volumeEncryptionKmsKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartMlModelTransformJobRequest

        if (baseProcessingInstanceType != other.baseProcessingInstanceType) return false
        if (baseProcessingInstanceVolumeSizeInGb != other.baseProcessingInstanceVolumeSizeInGb) return false
        if (customModelTransformParameters != other.customModelTransformParameters) return false
        if (dataProcessingJobId != other.dataProcessingJobId) return false
        if (id != other.id) return false
        if (mlModelTrainingJobId != other.mlModelTrainingJobId) return false
        if (modelTransformOutputS3Location != other.modelTransformOutputS3Location) return false
        if (neptuneIamRoleArn != other.neptuneIamRoleArn) return false
        if (s3OutputEncryptionKmsKey != other.s3OutputEncryptionKmsKey) return false
        if (sagemakerIamRoleArn != other.sagemakerIamRoleArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnets != other.subnets) return false
        if (trainingJobName != other.trainingJobName) return false
        if (volumeEncryptionKmsKey != other.volumeEncryptionKmsKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunedata.model.StartMlModelTransformJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of ML instance used in preparing and managing training of ML models. This is an ML compute instance chosen based on memory requirements for processing the training data and model.
         */
        public var baseProcessingInstanceType: kotlin.String? = null
        /**
         * The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the output model are stored on disk, so the volume size must be large enough to hold both data sets. If not specified or 0, Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
         */
        public var baseProcessingInstanceVolumeSizeInGb: kotlin.Int? = null
        /**
         * Configuration information for a model transform using a custom model. The `customModelTransformParameters` object contains the following fields, which must have values compatible with the saved model parameters from the training job:
         */
        public var customModelTransformParameters: aws.sdk.kotlin.services.neptunedata.model.CustomModelTransformParameters? = null
        /**
         * The job ID of a completed data-processing job. You must include either `dataProcessingJobId` and a `mlModelTrainingJobId`, or a `trainingJobName`.
         */
        public var dataProcessingJobId: kotlin.String? = null
        /**
         * A unique identifier for the new job. The default is an autogenerated UUID.
         */
        public var id: kotlin.String? = null
        /**
         * The job ID of a completed model-training job. You must include either `dataProcessingJobId` and a `mlModelTrainingJobId`, or a `trainingJobName`.
         */
        public var mlModelTrainingJobId: kotlin.String? = null
        /**
         * The location in Amazon S3 where the model artifacts are to be stored.
         */
        public var modelTransformOutputS3Location: kotlin.String? = null
        /**
         * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.
         */
        public var neptuneIamRoleArn: kotlin.String? = null
        /**
         * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The default is none.
         */
        public var s3OutputEncryptionKmsKey: kotlin.String? = null
        /**
         * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an error will occur.
         */
        public var sagemakerIamRoleArn: kotlin.String? = null
        /**
         * The VPC security group IDs. The default is None.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The IDs of the subnets in the Neptune VPC. The default is None.
         */
        public var subnets: List<String>? = null
        /**
         * The name of a completed SageMaker training job. You must include either `dataProcessingJobId` and a `mlModelTrainingJobId`, or a `trainingJobName`.
         */
        public var trainingJobName: kotlin.String? = null
        /**
         * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instances that run the training job. The default is None.
         */
        public var volumeEncryptionKmsKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunedata.model.StartMlModelTransformJobRequest) : this() {
            this.baseProcessingInstanceType = x.baseProcessingInstanceType
            this.baseProcessingInstanceVolumeSizeInGb = x.baseProcessingInstanceVolumeSizeInGb
            this.customModelTransformParameters = x.customModelTransformParameters
            this.dataProcessingJobId = x.dataProcessingJobId
            this.id = x.id
            this.mlModelTrainingJobId = x.mlModelTrainingJobId
            this.modelTransformOutputS3Location = x.modelTransformOutputS3Location
            this.neptuneIamRoleArn = x.neptuneIamRoleArn
            this.s3OutputEncryptionKmsKey = x.s3OutputEncryptionKmsKey
            this.sagemakerIamRoleArn = x.sagemakerIamRoleArn
            this.securityGroupIds = x.securityGroupIds
            this.subnets = x.subnets
            this.trainingJobName = x.trainingJobName
            this.volumeEncryptionKmsKey = x.volumeEncryptionKmsKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunedata.model.StartMlModelTransformJobRequest = StartMlModelTransformJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptunedata.model.CustomModelTransformParameters] inside the given [block]
         */
        public fun customModelTransformParameters(block: aws.sdk.kotlin.services.neptunedata.model.CustomModelTransformParameters.Builder.() -> kotlin.Unit) {
            this.customModelTransformParameters = aws.sdk.kotlin.services.neptunedata.model.CustomModelTransformParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
