// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartMlDataProcessingJobRequest private constructor(builder: Builder) {
    /**
     * A data specification file that describes how to load the exported graph data for training. The file is automatically generated by the Neptune export toolkit. The default is `training-data-configuration.json`.
     */
    public val configFileName: kotlin.String? = builder.configFileName
    /**
     * A unique identifier for the new job. The default is an autogenerated UUID.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data processing job.
     */
    public val inputDataS3Location: kotlin.String? = builder.inputDataS3Location
    /**
     * One of the two model types that Neptune ML currently supports: heterogeneous graph models (`heterogeneous`), and knowledge graph (`kge`). The default is none. If not specified, Neptune ML chooses the model type automatically based on the data.
     */
    public val modelType: kotlin.String? = builder.modelType
    /**
     * The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf. This must be listed in your DB cluster parameter group or an error will occur.
     */
    public val neptuneIamRoleArn: kotlin.String? = builder.neptuneIamRoleArn
    /**
     * The job ID of a completed data processing job run on an earlier version of the data.
     */
    public val previousDataProcessingJobId: kotlin.String? = builder.previousDataProcessingJobId
    /**
     * The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
     */
    public val processedDataS3Location: kotlin.String? = builder.processedDataS3Location
    /**
     * The type of ML instance used during data processing. Its memory should be large enough to hold the processed dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size of the exported graph data on disk.
     */
    public val processingInstanceType: kotlin.String? = builder.processingInstanceType
    /**
     * The disk volume size of the processing instance. Both input data and processed data are stored on disk, so the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML chooses the volume size automatically based on the data size.
     */
    public val processingInstanceVolumeSizeInGb: kotlin.Int? = builder.processingInstanceVolumeSizeInGb
    /**
     * Timeout in seconds for the data processing job. The default is 86,400 (1 day).
     */
    public val processingTimeOutInSeconds: kotlin.Int? = builder.processingTimeOutInSeconds
    /**
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the processing job. The default is none.
     */
    public val s3OutputEncryptionKmsKey: kotlin.String? = builder.s3OutputEncryptionKmsKey
    /**
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an error will occur.
     */
    public val sagemakerIamRoleArn: kotlin.String? = builder.sagemakerIamRoleArn
    /**
     * The VPC security group IDs. The default is None.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The IDs of the subnets in the Neptune VPC. The default is None.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instances that run the training job. The default is None.
     */
    public val volumeEncryptionKmsKey: kotlin.String? = builder.volumeEncryptionKmsKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunedata.model.StartMlDataProcessingJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartMlDataProcessingJobRequest(")
        append("configFileName=$configFileName,")
        append("id=$id,")
        append("inputDataS3Location=$inputDataS3Location,")
        append("modelType=$modelType,")
        append("neptuneIamRoleArn=$neptuneIamRoleArn,")
        append("previousDataProcessingJobId=$previousDataProcessingJobId,")
        append("processedDataS3Location=$processedDataS3Location,")
        append("processingInstanceType=$processingInstanceType,")
        append("processingInstanceVolumeSizeInGb=$processingInstanceVolumeSizeInGb,")
        append("processingTimeOutInSeconds=$processingTimeOutInSeconds,")
        append("s3OutputEncryptionKmsKey=$s3OutputEncryptionKmsKey,")
        append("sagemakerIamRoleArn=$sagemakerIamRoleArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnets=$subnets,")
        append("volumeEncryptionKmsKey=$volumeEncryptionKmsKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configFileName?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (inputDataS3Location?.hashCode() ?: 0)
        result = 31 * result + (modelType?.hashCode() ?: 0)
        result = 31 * result + (neptuneIamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (previousDataProcessingJobId?.hashCode() ?: 0)
        result = 31 * result + (processedDataS3Location?.hashCode() ?: 0)
        result = 31 * result + (processingInstanceType?.hashCode() ?: 0)
        result = 31 * result + (processingInstanceVolumeSizeInGb ?: 0)
        result = 31 * result + (processingTimeOutInSeconds ?: 0)
        result = 31 * result + (s3OutputEncryptionKmsKey?.hashCode() ?: 0)
        result = 31 * result + (sagemakerIamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (volumeEncryptionKmsKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartMlDataProcessingJobRequest

        if (configFileName != other.configFileName) return false
        if (id != other.id) return false
        if (inputDataS3Location != other.inputDataS3Location) return false
        if (modelType != other.modelType) return false
        if (neptuneIamRoleArn != other.neptuneIamRoleArn) return false
        if (previousDataProcessingJobId != other.previousDataProcessingJobId) return false
        if (processedDataS3Location != other.processedDataS3Location) return false
        if (processingInstanceType != other.processingInstanceType) return false
        if (processingInstanceVolumeSizeInGb != other.processingInstanceVolumeSizeInGb) return false
        if (processingTimeOutInSeconds != other.processingTimeOutInSeconds) return false
        if (s3OutputEncryptionKmsKey != other.s3OutputEncryptionKmsKey) return false
        if (sagemakerIamRoleArn != other.sagemakerIamRoleArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnets != other.subnets) return false
        if (volumeEncryptionKmsKey != other.volumeEncryptionKmsKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunedata.model.StartMlDataProcessingJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A data specification file that describes how to load the exported graph data for training. The file is automatically generated by the Neptune export toolkit. The default is `training-data-configuration.json`.
         */
        public var configFileName: kotlin.String? = null
        /**
         * A unique identifier for the new job. The default is an autogenerated UUID.
         */
        public var id: kotlin.String? = null
        /**
         * The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data processing job.
         */
        public var inputDataS3Location: kotlin.String? = null
        /**
         * One of the two model types that Neptune ML currently supports: heterogeneous graph models (`heterogeneous`), and knowledge graph (`kge`). The default is none. If not specified, Neptune ML chooses the model type automatically based on the data.
         */
        public var modelType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf. This must be listed in your DB cluster parameter group or an error will occur.
         */
        public var neptuneIamRoleArn: kotlin.String? = null
        /**
         * The job ID of a completed data processing job run on an earlier version of the data.
         */
        public var previousDataProcessingJobId: kotlin.String? = null
        /**
         * The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.
         */
        public var processedDataS3Location: kotlin.String? = null
        /**
         * The type of ML instance used during data processing. Its memory should be large enough to hold the processed dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size of the exported graph data on disk.
         */
        public var processingInstanceType: kotlin.String? = null
        /**
         * The disk volume size of the processing instance. Both input data and processed data are stored on disk, so the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML chooses the volume size automatically based on the data size.
         */
        public var processingInstanceVolumeSizeInGb: kotlin.Int? = null
        /**
         * Timeout in seconds for the data processing job. The default is 86,400 (1 day).
         */
        public var processingTimeOutInSeconds: kotlin.Int? = null
        /**
         * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the processing job. The default is none.
         */
        public var s3OutputEncryptionKmsKey: kotlin.String? = null
        /**
         * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an error will occur.
         */
        public var sagemakerIamRoleArn: kotlin.String? = null
        /**
         * The VPC security group IDs. The default is None.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The IDs of the subnets in the Neptune VPC. The default is None.
         */
        public var subnets: List<String>? = null
        /**
         * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instances that run the training job. The default is None.
         */
        public var volumeEncryptionKmsKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunedata.model.StartMlDataProcessingJobRequest) : this() {
            this.configFileName = x.configFileName
            this.id = x.id
            this.inputDataS3Location = x.inputDataS3Location
            this.modelType = x.modelType
            this.neptuneIamRoleArn = x.neptuneIamRoleArn
            this.previousDataProcessingJobId = x.previousDataProcessingJobId
            this.processedDataS3Location = x.processedDataS3Location
            this.processingInstanceType = x.processingInstanceType
            this.processingInstanceVolumeSizeInGb = x.processingInstanceVolumeSizeInGb
            this.processingTimeOutInSeconds = x.processingTimeOutInSeconds
            this.s3OutputEncryptionKmsKey = x.s3OutputEncryptionKmsKey
            this.sagemakerIamRoleArn = x.sagemakerIamRoleArn
            this.securityGroupIds = x.securityGroupIds
            this.subnets = x.subnets
            this.volumeEncryptionKmsKey = x.volumeEncryptionKmsKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunedata.model.StartMlDataProcessingJobRequest = StartMlDataProcessingJobRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
