// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The RDF graph summary API returns a read-only list of classes and predicate keys, along with counts of quads, subjects, and predicates.
 */
public class RdfGraphSummary private constructor(builder: Builder) {
    /**
     * A list of the classes in the graph.
     */
    public val classes: List<String>? = builder.classes
    /**
     * The number of classes in the graph.
     */
    public val numClasses: kotlin.Long? = builder.numClasses
    /**
     * The number of distinct predicates in the graph.
     */
    public val numDistinctPredicates: kotlin.Long? = builder.numDistinctPredicates
    /**
     * The number of distinct subjects in the graph.
     */
    public val numDistinctSubjects: kotlin.Long? = builder.numDistinctSubjects
    /**
     * The number of quads in the graph.
     */
    public val numQuads: kotlin.Long? = builder.numQuads
    /**
     * "A list of predicates in the graph, along with the predicate counts.
     */
    public val predicates: List<Map<String, Long>>? = builder.predicates
    /**
     * This field is only present when the request mode is `DETAILED`. It contains a list of subject structures.
     */
    public val subjectStructures: List<SubjectStructure>? = builder.subjectStructures

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunedata.model.RdfGraphSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdfGraphSummary(")
        append("classes=$classes,")
        append("numClasses=$numClasses,")
        append("numDistinctPredicates=$numDistinctPredicates,")
        append("numDistinctSubjects=$numDistinctSubjects,")
        append("numQuads=$numQuads,")
        append("predicates=$predicates,")
        append("subjectStructures=$subjectStructures")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = classes?.hashCode() ?: 0
        result = 31 * result + (numClasses?.hashCode() ?: 0)
        result = 31 * result + (numDistinctPredicates?.hashCode() ?: 0)
        result = 31 * result + (numDistinctSubjects?.hashCode() ?: 0)
        result = 31 * result + (numQuads?.hashCode() ?: 0)
        result = 31 * result + (predicates?.hashCode() ?: 0)
        result = 31 * result + (subjectStructures?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdfGraphSummary

        if (classes != other.classes) return false
        if (numClasses != other.numClasses) return false
        if (numDistinctPredicates != other.numDistinctPredicates) return false
        if (numDistinctSubjects != other.numDistinctSubjects) return false
        if (numQuads != other.numQuads) return false
        if (predicates != other.predicates) return false
        if (subjectStructures != other.subjectStructures) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunedata.model.RdfGraphSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of the classes in the graph.
         */
        public var classes: List<String>? = null
        /**
         * The number of classes in the graph.
         */
        public var numClasses: kotlin.Long? = null
        /**
         * The number of distinct predicates in the graph.
         */
        public var numDistinctPredicates: kotlin.Long? = null
        /**
         * The number of distinct subjects in the graph.
         */
        public var numDistinctSubjects: kotlin.Long? = null
        /**
         * The number of quads in the graph.
         */
        public var numQuads: kotlin.Long? = null
        /**
         * "A list of predicates in the graph, along with the predicate counts.
         */
        public var predicates: List<Map<String, Long>>? = null
        /**
         * This field is only present when the request mode is `DETAILED`. It contains a list of subject structures.
         */
        public var subjectStructures: List<SubjectStructure>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunedata.model.RdfGraphSummary) : this() {
            this.classes = x.classes
            this.numClasses = x.numClasses
            this.numDistinctPredicates = x.numDistinctPredicates
            this.numDistinctSubjects = x.numDistinctSubjects
            this.numQuads = x.numQuads
            this.predicates = x.predicates
            this.subjectStructures = x.subjectStructures
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunedata.model.RdfGraphSummary = RdfGraphSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
