// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains custom model transform parameters. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
 */
public class CustomModelTransformParameters private constructor(builder: Builder) {
    /**
     * The path to the Amazon S3 location where the Python module implementing your model is located. This must point to a valid existing Amazon S3 location that contains, at a minimum, a training script, a transform script, and a `model-hpo-configuration.json` file.
     */
    public val sourceS3DirectoryPath: kotlin.String = requireNotNull(builder.sourceS3DirectoryPath) { "A non-null value must be provided for sourceS3DirectoryPath" }
    /**
     * The name of the entry point in your module of a script that should be run after the best model from the hyperparameter search has been identified, to compute the model artifacts necessary for model deployment. It should be able to run with no command-line arguments. The default is `transform.py`.
     */
    public val transformEntryPointScript: kotlin.String? = builder.transformEntryPointScript

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunedata.model.CustomModelTransformParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomModelTransformParameters(")
        append("sourceS3DirectoryPath=$sourceS3DirectoryPath,")
        append("transformEntryPointScript=$transformEntryPointScript")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceS3DirectoryPath.hashCode()
        result = 31 * result + (transformEntryPointScript?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomModelTransformParameters

        if (sourceS3DirectoryPath != other.sourceS3DirectoryPath) return false
        if (transformEntryPointScript != other.transformEntryPointScript) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunedata.model.CustomModelTransformParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The path to the Amazon S3 location where the Python module implementing your model is located. This must point to a valid existing Amazon S3 location that contains, at a minimum, a training script, a transform script, and a `model-hpo-configuration.json` file.
         */
        public var sourceS3DirectoryPath: kotlin.String? = null
        /**
         * The name of the entry point in your module of a script that should be run after the best model from the hyperparameter search has been identified, to compute the model artifacts necessary for model deployment. It should be able to run with no command-line arguments. The default is `transform.py`.
         */
        public var transformEntryPointScript: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunedata.model.CustomModelTransformParameters) : this() {
            this.sourceS3DirectoryPath = x.sourceS3DirectoryPath
            this.transformEntryPointScript = x.transformEntryPointScript
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunedata.model.CustomModelTransformParameters = CustomModelTransformParameters(this)

        internal fun correctErrors(): Builder {
            if (sourceS3DirectoryPath == null) sourceS3DirectoryPath = ""
            return this
        }
    }
}
