// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateMlEndpointRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the new inference endpoint. The default is an autogenerated timestamped name.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The minimum number of Amazon EC2 instances to deploy to an endpoint for prediction. The default is 1
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The type of Neptune ML instance to use for online servicing. The default is `ml.m5.xlarge`. Choosing the ML instance for an inference endpoint depends on the task type, the graph size, and your budget.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The job Id of the completed model-training job that has created the model that the inference endpoint will point to. You must supply either the `mlModelTrainingJobId` or the `mlModelTransformJobId`.
     */
    public val mlModelTrainingJobId: kotlin.String? = builder.mlModelTrainingJobId
    /**
     * The job Id of the completed model-transform job. You must supply either the `mlModelTrainingJobId` or the `mlModelTransformJobId`.
     */
    public val mlModelTransformJobId: kotlin.String? = builder.mlModelTransformJobId
    /**
     * Model type for training. By default the Neptune ML model is automatically based on the `modelType` used in data processing, but you can specify a different model type here. The default is `rgcn` for heterogeneous graphs and `kge` for knowledge graphs. The only valid value for heterogeneous graphs is `rgcn`. Valid values for knowledge graphs are: `kge`, `transe`, `distmult`, and `rotate`.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will be thrown.
     */
    public val neptuneIamRoleArn: kotlin.String? = builder.neptuneIamRoleArn
    /**
     * If set to `true`, `update` indicates that this is an update request. The default is `false`. You must supply either the `mlModelTrainingJobId` or the `mlModelTransformJobId`.
     */
    public val update: kotlin.Boolean? = builder.update
    /**
     * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instances that run the training job. The default is None.
     */
    public val volumeEncryptionKmsKey: kotlin.String? = builder.volumeEncryptionKmsKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptunedata.model.CreateMlEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMlEndpointRequest(")
        append("id=$id,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("mlModelTrainingJobId=$mlModelTrainingJobId,")
        append("mlModelTransformJobId=$mlModelTransformJobId,")
        append("modelName=$modelName,")
        append("neptuneIamRoleArn=$neptuneIamRoleArn,")
        append("update=$update,")
        append("volumeEncryptionKmsKey=$volumeEncryptionKmsKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (mlModelTrainingJobId?.hashCode() ?: 0)
        result = 31 * result + (mlModelTransformJobId?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (neptuneIamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (update?.hashCode() ?: 0)
        result = 31 * result + (volumeEncryptionKmsKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMlEndpointRequest

        if (id != other.id) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (mlModelTrainingJobId != other.mlModelTrainingJobId) return false
        if (mlModelTransformJobId != other.mlModelTransformJobId) return false
        if (modelName != other.modelName) return false
        if (neptuneIamRoleArn != other.neptuneIamRoleArn) return false
        if (update != other.update) return false
        if (volumeEncryptionKmsKey != other.volumeEncryptionKmsKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptunedata.model.CreateMlEndpointRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier for the new inference endpoint. The default is an autogenerated timestamped name.
         */
        public var id: kotlin.String? = null
        /**
         * The minimum number of Amazon EC2 instances to deploy to an endpoint for prediction. The default is 1
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * The type of Neptune ML instance to use for online servicing. The default is `ml.m5.xlarge`. Choosing the ML instance for an inference endpoint depends on the task type, the graph size, and your budget.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The job Id of the completed model-training job that has created the model that the inference endpoint will point to. You must supply either the `mlModelTrainingJobId` or the `mlModelTransformJobId`.
         */
        public var mlModelTrainingJobId: kotlin.String? = null
        /**
         * The job Id of the completed model-transform job. You must supply either the `mlModelTrainingJobId` or the `mlModelTransformJobId`.
         */
        public var mlModelTransformJobId: kotlin.String? = null
        /**
         * Model type for training. By default the Neptune ML model is automatically based on the `modelType` used in data processing, but you can specify a different model type here. The default is `rgcn` for heterogeneous graphs and `kge` for knowledge graphs. The only valid value for heterogeneous graphs is `rgcn`. Valid values for knowledge graphs are: `kge`, `transe`, `distmult`, and `rotate`.
         */
        public var modelName: kotlin.String? = null
        /**
         * The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will be thrown.
         */
        public var neptuneIamRoleArn: kotlin.String? = null
        /**
         * If set to `true`, `update` indicates that this is an update request. The default is `false`. You must supply either the `mlModelTrainingJobId` or the `mlModelTransformJobId`.
         */
        public var update: kotlin.Boolean? = null
        /**
         * The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instances that run the training job. The default is None.
         */
        public var volumeEncryptionKmsKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptunedata.model.CreateMlEndpointRequest) : this() {
            this.id = x.id
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.mlModelTrainingJobId = x.mlModelTrainingJobId
            this.mlModelTransformJobId = x.mlModelTransformJobId
            this.modelName = x.modelName
            this.neptuneIamRoleArn = x.neptuneIamRoleArn
            this.update = x.update
            this.volumeEncryptionKmsKey = x.volumeEncryptionKmsKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptunedata.model.CreateMlEndpointRequest = CreateMlEndpointRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
