// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptunedata

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.neptunedata.auth.DefaultNeptunedataAuthSchemeProvider
import aws.sdk.kotlin.services.neptunedata.auth.NeptunedataAuthSchemeProvider
import aws.sdk.kotlin.services.neptunedata.endpoints.DefaultNeptunedataEndpointProvider
import aws.sdk.kotlin.services.neptunedata.endpoints.NeptunedataEndpointParameters
import aws.sdk.kotlin.services.neptunedata.endpoints.NeptunedataEndpointProvider
import aws.sdk.kotlin.services.neptunedata.model.CancelGremlinQueryRequest
import aws.sdk.kotlin.services.neptunedata.model.CancelGremlinQueryResponse
import aws.sdk.kotlin.services.neptunedata.model.CancelLoaderJobRequest
import aws.sdk.kotlin.services.neptunedata.model.CancelLoaderJobResponse
import aws.sdk.kotlin.services.neptunedata.model.CancelMlDataProcessingJobRequest
import aws.sdk.kotlin.services.neptunedata.model.CancelMlDataProcessingJobResponse
import aws.sdk.kotlin.services.neptunedata.model.CancelMlModelTrainingJobRequest
import aws.sdk.kotlin.services.neptunedata.model.CancelMlModelTrainingJobResponse
import aws.sdk.kotlin.services.neptunedata.model.CancelMlModelTransformJobRequest
import aws.sdk.kotlin.services.neptunedata.model.CancelMlModelTransformJobResponse
import aws.sdk.kotlin.services.neptunedata.model.CancelOpenCypherQueryRequest
import aws.sdk.kotlin.services.neptunedata.model.CancelOpenCypherQueryResponse
import aws.sdk.kotlin.services.neptunedata.model.CreateMlEndpointRequest
import aws.sdk.kotlin.services.neptunedata.model.CreateMlEndpointResponse
import aws.sdk.kotlin.services.neptunedata.model.DeleteMlEndpointRequest
import aws.sdk.kotlin.services.neptunedata.model.DeleteMlEndpointResponse
import aws.sdk.kotlin.services.neptunedata.model.DeletePropertygraphStatisticsRequest
import aws.sdk.kotlin.services.neptunedata.model.DeletePropertygraphStatisticsResponse
import aws.sdk.kotlin.services.neptunedata.model.DeleteSparqlStatisticsRequest
import aws.sdk.kotlin.services.neptunedata.model.DeleteSparqlStatisticsResponse
import aws.sdk.kotlin.services.neptunedata.model.ExecuteFastResetRequest
import aws.sdk.kotlin.services.neptunedata.model.ExecuteFastResetResponse
import aws.sdk.kotlin.services.neptunedata.model.ExecuteGremlinExplainQueryRequest
import aws.sdk.kotlin.services.neptunedata.model.ExecuteGremlinExplainQueryResponse
import aws.sdk.kotlin.services.neptunedata.model.ExecuteGremlinProfileQueryRequest
import aws.sdk.kotlin.services.neptunedata.model.ExecuteGremlinProfileQueryResponse
import aws.sdk.kotlin.services.neptunedata.model.ExecuteGremlinQueryRequest
import aws.sdk.kotlin.services.neptunedata.model.ExecuteGremlinQueryResponse
import aws.sdk.kotlin.services.neptunedata.model.ExecuteOpenCypherExplainQueryRequest
import aws.sdk.kotlin.services.neptunedata.model.ExecuteOpenCypherExplainQueryResponse
import aws.sdk.kotlin.services.neptunedata.model.ExecuteOpenCypherQueryRequest
import aws.sdk.kotlin.services.neptunedata.model.ExecuteOpenCypherQueryResponse
import aws.sdk.kotlin.services.neptunedata.model.GetEngineStatusRequest
import aws.sdk.kotlin.services.neptunedata.model.GetEngineStatusResponse
import aws.sdk.kotlin.services.neptunedata.model.GetGremlinQueryStatusRequest
import aws.sdk.kotlin.services.neptunedata.model.GetGremlinQueryStatusResponse
import aws.sdk.kotlin.services.neptunedata.model.GetLoaderJobStatusRequest
import aws.sdk.kotlin.services.neptunedata.model.GetLoaderJobStatusResponse
import aws.sdk.kotlin.services.neptunedata.model.GetMlDataProcessingJobRequest
import aws.sdk.kotlin.services.neptunedata.model.GetMlDataProcessingJobResponse
import aws.sdk.kotlin.services.neptunedata.model.GetMlEndpointRequest
import aws.sdk.kotlin.services.neptunedata.model.GetMlEndpointResponse
import aws.sdk.kotlin.services.neptunedata.model.GetMlModelTrainingJobRequest
import aws.sdk.kotlin.services.neptunedata.model.GetMlModelTrainingJobResponse
import aws.sdk.kotlin.services.neptunedata.model.GetMlModelTransformJobRequest
import aws.sdk.kotlin.services.neptunedata.model.GetMlModelTransformJobResponse
import aws.sdk.kotlin.services.neptunedata.model.GetOpenCypherQueryStatusRequest
import aws.sdk.kotlin.services.neptunedata.model.GetOpenCypherQueryStatusResponse
import aws.sdk.kotlin.services.neptunedata.model.GetPropertygraphStatisticsRequest
import aws.sdk.kotlin.services.neptunedata.model.GetPropertygraphStatisticsResponse
import aws.sdk.kotlin.services.neptunedata.model.GetPropertygraphStreamRequest
import aws.sdk.kotlin.services.neptunedata.model.GetPropertygraphStreamResponse
import aws.sdk.kotlin.services.neptunedata.model.GetPropertygraphSummaryRequest
import aws.sdk.kotlin.services.neptunedata.model.GetPropertygraphSummaryResponse
import aws.sdk.kotlin.services.neptunedata.model.GetRdfGraphSummaryRequest
import aws.sdk.kotlin.services.neptunedata.model.GetRdfGraphSummaryResponse
import aws.sdk.kotlin.services.neptunedata.model.GetSparqlStatisticsRequest
import aws.sdk.kotlin.services.neptunedata.model.GetSparqlStatisticsResponse
import aws.sdk.kotlin.services.neptunedata.model.GetSparqlStreamRequest
import aws.sdk.kotlin.services.neptunedata.model.GetSparqlStreamResponse
import aws.sdk.kotlin.services.neptunedata.model.ListGremlinQueriesRequest
import aws.sdk.kotlin.services.neptunedata.model.ListGremlinQueriesResponse
import aws.sdk.kotlin.services.neptunedata.model.ListLoaderJobsRequest
import aws.sdk.kotlin.services.neptunedata.model.ListLoaderJobsResponse
import aws.sdk.kotlin.services.neptunedata.model.ListMlDataProcessingJobsRequest
import aws.sdk.kotlin.services.neptunedata.model.ListMlDataProcessingJobsResponse
import aws.sdk.kotlin.services.neptunedata.model.ListMlEndpointsRequest
import aws.sdk.kotlin.services.neptunedata.model.ListMlEndpointsResponse
import aws.sdk.kotlin.services.neptunedata.model.ListMlModelTrainingJobsRequest
import aws.sdk.kotlin.services.neptunedata.model.ListMlModelTrainingJobsResponse
import aws.sdk.kotlin.services.neptunedata.model.ListMlModelTransformJobsRequest
import aws.sdk.kotlin.services.neptunedata.model.ListMlModelTransformJobsResponse
import aws.sdk.kotlin.services.neptunedata.model.ListOpenCypherQueriesRequest
import aws.sdk.kotlin.services.neptunedata.model.ListOpenCypherQueriesResponse
import aws.sdk.kotlin.services.neptunedata.model.ManagePropertygraphStatisticsRequest
import aws.sdk.kotlin.services.neptunedata.model.ManagePropertygraphStatisticsResponse
import aws.sdk.kotlin.services.neptunedata.model.ManageSparqlStatisticsRequest
import aws.sdk.kotlin.services.neptunedata.model.ManageSparqlStatisticsResponse
import aws.sdk.kotlin.services.neptunedata.model.StartLoaderJobRequest
import aws.sdk.kotlin.services.neptunedata.model.StartLoaderJobResponse
import aws.sdk.kotlin.services.neptunedata.model.StartMlDataProcessingJobRequest
import aws.sdk.kotlin.services.neptunedata.model.StartMlDataProcessingJobResponse
import aws.sdk.kotlin.services.neptunedata.model.StartMlModelTrainingJobRequest
import aws.sdk.kotlin.services.neptunedata.model.StartMlModelTrainingJobResponse
import aws.sdk.kotlin.services.neptunedata.model.StartMlModelTransformJobRequest
import aws.sdk.kotlin.services.neptunedata.model.StartMlModelTransformJobResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "neptunedata"
public const val SdkVersion: String = "1.5.13"
public const val ServiceApiVersion: String = "2023-08-01"

/**
 * # Neptune Data API
 * The Amazon Neptune data API provides SDK support for more than 40 of Neptune's data operations, including data loading, query execution, data inquiry, and machine learning. It supports the Gremlin and openCypher query languages, and is available in all SDK languages. It automatically signs API requests and greatly simplifies integrating Neptune into your applications.
 */
public interface NeptunedataClient : SdkClient {
    /**
     * NeptunedataClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, NeptunedataClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Neptunedata",
                "NEPTUNEDATA",
                "neptunedata",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, NeptunedataClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): NeptunedataClient = DefaultNeptunedataClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: NeptunedataEndpointProvider = builder.endpointProvider ?: DefaultNeptunedataEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: NeptunedataAuthSchemeProvider = builder.authSchemeProvider ?: DefaultNeptunedataAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "neptunedata"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: NeptunedataEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: NeptunedataAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels a Gremlin query. See [Gremlin query cancellation](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status-cancel.html) for more information.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery) IAM action in that cluster.
     */
    public suspend fun cancelGremlinQuery(input: CancelGremlinQueryRequest): CancelGremlinQueryResponse

    /**
     * Cancels a specified load job. This is an HTTP `DELETE` request. See [Neptune Loader Get-Status API](https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm) for more information.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelLoaderJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelloaderjob) IAM action in that cluster..
     */
    public suspend fun cancelLoaderJob(input: CancelLoaderJobRequest): CancelLoaderJobResponse

    /**
     * Cancels a Neptune ML data processing job. See `dataprocessing`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelMLDataProcessingJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmldataprocessingjob) IAM action in that cluster.
     */
    public suspend fun cancelMlDataProcessingJob(input: CancelMlDataProcessingJobRequest): CancelMlDataProcessingJobResponse

    /**
     * Cancels a Neptune ML model training job. See `modeltraining`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelMLModelTrainingJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltrainingjob) IAM action in that cluster.
     */
    public suspend fun cancelMlModelTrainingJob(input: CancelMlModelTrainingJobRequest): CancelMlModelTrainingJobResponse

    /**
     * Cancels a specified model transform job. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelMLModelTransformJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltransformjob) IAM action in that cluster.
     */
    public suspend fun cancelMlModelTransformJob(input: CancelMlModelTransformJobRequest): CancelMlModelTransformJobResponse

    /**
     * Cancels a specified openCypher query. See [Neptune openCypher status endpoint](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html) for more information.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery) IAM action in that cluster.
     */
    public suspend fun cancelOpenCypherQuery(input: CancelOpenCypherQueryRequest): CancelOpenCypherQueryResponse

    /**
     * Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training process constructed. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CreateMLEndpoint](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#createmlendpoint) IAM action in that cluster.
     */
    public suspend fun createMlEndpoint(input: CreateMlEndpointRequest = CreateMlEndpointRequest { }): CreateMlEndpointResponse

    /**
     * Cancels the creation of a Neptune ML inference endpoint. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:DeleteMLEndpoint](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletemlendpoint) IAM action in that cluster.
     */
    public suspend fun deleteMlEndpoint(input: DeleteMlEndpointRequest): DeleteMlEndpointResponse

    /**
     * Deletes statistics for Gremlin and openCypher (property graph) data.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:DeleteStatistics](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics) IAM action in that cluster.
     */
    public suspend fun deletePropertygraphStatistics(input: DeletePropertygraphStatisticsRequest = DeletePropertygraphStatisticsRequest { }): DeletePropertygraphStatisticsResponse

    /**
     * Deletes SPARQL statistics
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:DeleteStatistics](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics) IAM action in that cluster.
     */
    public suspend fun deleteSparqlStatistics(input: DeleteSparqlStatisticsRequest = DeleteSparqlStatisticsRequest { }): DeleteSparqlStatisticsResponse

    /**
     * The fast reset REST API lets you reset a Neptune graph quicky and easily, removing all of its data.
     *
     * Neptune fast reset is a two-step process. First you call `ExecuteFastReset` with `action` set to `initiateDatabaseReset`. This returns a UUID token which you then include when calling `ExecuteFastReset` again with `action` set to `performDatabaseReset`. See [Empty an Amazon Neptune DB cluster using the fast reset API](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-fast-reset.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ResetDatabase](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase) IAM action in that cluster.
     */
    public suspend fun executeFastReset(input: ExecuteFastResetRequest): ExecuteFastResetResponse

    /**
     * Executes a Gremlin Explain query.
     *
     * Amazon Neptune has added a Gremlin feature named `explain` that provides is a self-service tool for understanding the execution approach being taken by the Neptune engine for the query. You invoke it by adding an `explain` parameter to an HTTP call that submits a Gremlin query.
     *
     * The explain feature provides information about the logical structure of query execution plans. You can use this information to identify potential evaluation and execution bottlenecks and to tune your query, as explained in [Tuning Gremlin queries](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html). You can also use query hints to improve query execution plans.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows one of the following IAM actions in that cluster, depending on the query:
     * + [neptune-db:ReadDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery)
     * + [neptune-db:WriteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery)
     * + [neptune-db:DeleteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery)
     *
     * Note that the [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
     */
    public suspend fun executeGremlinExplainQuery(input: ExecuteGremlinExplainQueryRequest): ExecuteGremlinExplainQueryResponse

    /**
     * Executes a Gremlin Profile query, which runs a specified traversal, collects various metrics about the run, and produces a profile report as output. See [Gremlin profile API in Neptune](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html) for details.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ReadDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery) IAM action in that cluster.
     *
     * Note that the [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
     */
    public suspend fun executeGremlinProfileQuery(input: ExecuteGremlinProfileQueryRequest): ExecuteGremlinProfileQueryResponse

    /**
     * This commands executes a Gremlin query. Amazon Neptune is compatible with Apache TinkerPop3 and Gremlin, so you can use the Gremlin traversal language to query the graph, as described under [The Graph](https://tinkerpop.apache.org/docs/current/reference/#graph) in the Apache TinkerPop3 documentation. More details can also be found in [Accessing a Neptune graph with Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that enables one of the following IAM actions in that cluster, depending on the query:
     * + [neptune-db:ReadDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery)
     * + [neptune-db:WriteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery)
     * + [neptune-db:DeleteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery)
     *
     * Note that the [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
     */
    public suspend fun executeGremlinQuery(input: ExecuteGremlinQueryRequest): ExecuteGremlinQueryResponse

    /**
     * Executes an openCypher `explain` request. See [The openCypher explain feature](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-explain.html) for more information.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ReadDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery) IAM action in that cluster.
     *
     * Note that the [neptune-db:QueryLanguage:OpenCypher](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of openCypher queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
     */
    public suspend fun executeOpenCypherExplainQuery(input: ExecuteOpenCypherExplainQueryRequest): ExecuteOpenCypherExplainQueryResponse

    /**
     * Executes an openCypher query. See [Accessing the Neptune Graph with openCypher](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher.html) for more information.
     *
     * Neptune supports building graph applications using openCypher, which is currently one of the most popular query languages among developers working with graph databases. Developers, business analysts, and data scientists like openCypher's declarative, SQL-inspired syntax because it provides a familiar structure in which to querying property graphs.
     *
     * The openCypher language was originally developed by Neo4j, then open-sourced in 2015 and contributed to the [openCypher project](https://opencypher.org/) under an Apache 2 open-source license.
     *
     * Note that when invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows one of the following IAM actions in that cluster, depending on the query:
     * + [neptune-db:ReadDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery)
     * + [neptune-db:WriteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery)
     * + [neptune-db:DeleteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery)
     *
     * Note also that the [neptune-db:QueryLanguage:OpenCypher](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of openCypher queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
     */
    public suspend fun executeOpenCypherQuery(input: ExecuteOpenCypherQueryRequest): ExecuteOpenCypherQueryResponse

    /**
     * Retrieves the status of the graph database on the host.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetEngineStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getenginestatus) IAM action in that cluster.
     */
    public suspend fun getEngineStatus(input: GetEngineStatusRequest = GetEngineStatusRequest { }): GetEngineStatusResponse

    /**
     * Gets the status of a specified Gremlin query.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetQueryStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus) IAM action in that cluster.
     *
     * Note that the [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
     */
    public suspend fun getGremlinQueryStatus(input: GetGremlinQueryStatusRequest): GetGremlinQueryStatusResponse

    /**
     * Gets status information about a specified load job. Neptune keeps track of the most recent 1,024 bulk load jobs, and stores the last 10,000 error details per job.
     *
     * See [Neptune Loader Get-Status API](https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm) for more information.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetLoaderJobStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getloaderjobstatus) IAM action in that cluster..
     */
    public suspend fun getLoaderJobStatus(input: GetLoaderJobStatusRequest): GetLoaderJobStatusResponse

    /**
     * Retrieves information about a specified data processing job. See `dataprocessing`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:neptune-db:GetMLDataProcessingJobStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmldataprocessingjobstatus) IAM action in that cluster.
     */
    public suspend fun getMlDataProcessingJob(input: GetMlDataProcessingJobRequest): GetMlDataProcessingJobResponse

    /**
     * Retrieves details about an inference endpoint. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetMLEndpointStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlendpointstatus) IAM action in that cluster.
     */
    public suspend fun getMlEndpoint(input: GetMlEndpointRequest): GetMlEndpointResponse

    /**
     * Retrieves information about a Neptune ML model training job. See `modeltraining`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetMLModelTrainingJobStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltrainingjobstatus) IAM action in that cluster.
     */
    public suspend fun getMlModelTrainingJob(input: GetMlModelTrainingJobRequest): GetMlModelTrainingJobResponse

    /**
     * Gets information about a specified model transform job. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetMLModelTransformJobStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltransformjobstatus) IAM action in that cluster.
     */
    public suspend fun getMlModelTransformJob(input: GetMlModelTransformJobRequest): GetMlModelTransformJobResponse

    /**
     * Retrieves the status of a specified openCypher query.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetQueryStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus) IAM action in that cluster.
     *
     * Note that the [neptune-db:QueryLanguage:OpenCypher](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of openCypher queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
     */
    public suspend fun getOpenCypherQueryStatus(input: GetOpenCypherQueryStatusRequest): GetOpenCypherQueryStatusResponse

    /**
     * Gets property graph statistics (Gremlin and openCypher).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetStatisticsStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus) IAM action in that cluster.
     */
    public suspend fun getPropertygraphStatistics(input: GetPropertygraphStatisticsRequest = GetPropertygraphStatisticsRequest { }): GetPropertygraphStatisticsResponse

    /**
     * Gets a stream for a property graph.
     *
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every change made to your graph data as it happens. `GetPropertygraphStream` lets you collect these change-log entries for a property graph.
     *
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the [neptune_streams](https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams) DB cluster parameter to `1`.
     *
     * See [Capturing graph changes in real time using Neptune streams](https://docs.aws.amazon.com/neptune/latest/userguide/streams.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetStreamRecords](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords) IAM action in that cluster.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that enables one of the following IAM actions, depending on the query:
     *
     * Note that you can restrict property-graph queries using the following IAM context keys:
     * + [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys)
     * + [neptune-db:QueryLanguage:OpenCypher](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys)
     *
     * See [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
     */
    public suspend fun getPropertygraphStream(input: GetPropertygraphStreamRequest = GetPropertygraphStreamRequest { }): GetPropertygraphStreamResponse

    /**
     * Gets a graph summary for a property graph.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetGraphSummary](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary) IAM action in that cluster.
     */
    public suspend fun getPropertygraphSummary(input: GetPropertygraphSummaryRequest = GetPropertygraphSummaryRequest { }): GetPropertygraphSummaryResponse

    /**
     * Gets a graph summary for an RDF graph.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetGraphSummary](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary) IAM action in that cluster.
     */
    public suspend fun getRdfGraphSummary(input: GetRdfGraphSummaryRequest = GetRdfGraphSummaryRequest { }): GetRdfGraphSummaryResponse

    /**
     * Gets RDF statistics (SPARQL).
     */
    public suspend fun getSparqlStatistics(input: GetSparqlStatisticsRequest = GetSparqlStatisticsRequest { }): GetSparqlStatisticsResponse

    /**
     * Gets a stream for an RDF graph.
     *
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every change made to your graph data as it happens. `GetSparqlStream` lets you collect these change-log entries for an RDF graph.
     *
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the [neptune_streams](https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams) DB cluster parameter to `1`.
     *
     * See [Capturing graph changes in real time using Neptune streams](https://docs.aws.amazon.com/neptune/latest/userguide/streams.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetStreamRecords](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords) IAM action in that cluster.
     *
     * Note that the [neptune-db:QueryLanguage:Sparql](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of SPARQL queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
     */
    public suspend fun getSparqlStream(input: GetSparqlStreamRequest = GetSparqlStreamRequest { }): GetSparqlStreamResponse

    /**
     * Lists active Gremlin queries. See [Gremlin query status API](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html) for details about the output.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetQueryStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus) IAM action in that cluster.
     *
     * Note that the [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
     */
    public suspend fun listGremlinQueries(input: ListGremlinQueriesRequest = ListGremlinQueriesRequest { }): ListGremlinQueriesResponse

    /**
     * Retrieves a list of the `loadIds` for all active loader jobs.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ListLoaderJobs](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listloaderjobs) IAM action in that cluster..
     */
    public suspend fun listLoaderJobs(input: ListLoaderJobsRequest = ListLoaderJobsRequest { }): ListLoaderJobsResponse

    /**
     * Returns a list of Neptune ML data processing jobs. See [Listing active data-processing jobs using the Neptune ML dataprocessing command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html#machine-learning-api-dataprocessing-list-jobs).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ListMLDataProcessingJobs](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmldataprocessingjobs) IAM action in that cluster.
     */
    public suspend fun listMlDataProcessingJobs(input: ListMlDataProcessingJobsRequest = ListMlDataProcessingJobsRequest { }): ListMlDataProcessingJobsResponse

    /**
     * Lists existing inference endpoints. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ListMLEndpoints](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlendpoints) IAM action in that cluster.
     */
    public suspend fun listMlEndpoints(input: ListMlEndpointsRequest = ListMlEndpointsRequest { }): ListMlEndpointsResponse

    /**
     * Lists Neptune ML model-training jobs. See `modeltraining`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:neptune-db:ListMLModelTrainingJobs](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#neptune-db:listmlmodeltrainingjobs) IAM action in that cluster.
     */
    public suspend fun listMlModelTrainingJobs(input: ListMlModelTrainingJobsRequest = ListMlModelTrainingJobsRequest { }): ListMlModelTrainingJobsResponse

    /**
     * Returns a list of model transform job IDs. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ListMLModelTransformJobs](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltransformjobs) IAM action in that cluster.
     */
    public suspend fun listMlModelTransformJobs(input: ListMlModelTransformJobsRequest = ListMlModelTransformJobsRequest { }): ListMlModelTransformJobsResponse

    /**
     * Lists active openCypher queries. See [Neptune openCypher status endpoint](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html) for more information.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetQueryStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus) IAM action in that cluster.
     *
     * Note that the [neptune-db:QueryLanguage:OpenCypher](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of openCypher queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
     */
    public suspend fun listOpenCypherQueries(input: ListOpenCypherQueriesRequest = ListOpenCypherQueriesRequest { }): ListOpenCypherQueriesResponse

    /**
     * Manages the generation and use of property graph statistics.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ManageStatistics](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics) IAM action in that cluster.
     */
    public suspend fun managePropertygraphStatistics(input: ManagePropertygraphStatisticsRequest = ManagePropertygraphStatisticsRequest { }): ManagePropertygraphStatisticsResponse

    /**
     * Manages the generation and use of RDF graph statistics.
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ManageStatistics](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics) IAM action in that cluster.
     */
    public suspend fun manageSparqlStatistics(input: ManageSparqlStatisticsRequest = ManageSparqlStatisticsRequest { }): ManageSparqlStatisticsResponse

    /**
     * Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into a Neptune DB instance. See [Using the Amazon Neptune Bulk Loader to Ingest Data](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:StartLoaderJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startloaderjob) IAM action in that cluster.
     */
    public suspend fun startLoaderJob(input: StartLoaderJobRequest): StartLoaderJobResponse

    /**
     * Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training. See `dataprocessing`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:StartMLModelDataProcessingJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeldataprocessingjob) IAM action in that cluster.
     */
    public suspend fun startMlDataProcessingJob(input: StartMlDataProcessingJobRequest): StartMlDataProcessingJobResponse

    /**
     * Creates a new Neptune ML model training job. See `modeltraining`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:StartMLModelTrainingJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltrainingjob) IAM action in that cluster.
     */
    public suspend fun startMlModelTrainingJob(input: StartMlModelTrainingJobRequest): StartMlModelTrainingJobResponse

    /**
     * Creates a new model transform job. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
     *
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:StartMLModelTransformJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltransformjob) IAM action in that cluster.
     */
    public suspend fun startMlModelTransformJob(input: StartMlModelTransformJobRequest): StartMlModelTransformJobResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun NeptunedataClient.withConfig(block: NeptunedataClient.Config.Builder.() -> Unit): NeptunedataClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultNeptunedataClient(newConfig)
}

/**
 * Cancels a Gremlin query. See [Gremlin query cancellation](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status-cancel.html) for more information.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.cancelGremlinQuery(crossinline block: CancelGremlinQueryRequest.Builder.() -> Unit): CancelGremlinQueryResponse = cancelGremlinQuery(CancelGremlinQueryRequest.Builder().apply(block).build())

/**
 * Cancels a specified load job. This is an HTTP `DELETE` request. See [Neptune Loader Get-Status API](https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm) for more information.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelLoaderJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelloaderjob) IAM action in that cluster..
 */
public suspend inline fun NeptunedataClient.cancelLoaderJob(crossinline block: CancelLoaderJobRequest.Builder.() -> Unit): CancelLoaderJobResponse = cancelLoaderJob(CancelLoaderJobRequest.Builder().apply(block).build())

/**
 * Cancels a Neptune ML data processing job. See `dataprocessing`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelMLDataProcessingJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmldataprocessingjob) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.cancelMlDataProcessingJob(crossinline block: CancelMlDataProcessingJobRequest.Builder.() -> Unit): CancelMlDataProcessingJobResponse = cancelMlDataProcessingJob(CancelMlDataProcessingJobRequest.Builder().apply(block).build())

/**
 * Cancels a Neptune ML model training job. See `modeltraining`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelMLModelTrainingJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltrainingjob) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.cancelMlModelTrainingJob(crossinline block: CancelMlModelTrainingJobRequest.Builder.() -> Unit): CancelMlModelTrainingJobResponse = cancelMlModelTrainingJob(CancelMlModelTrainingJobRequest.Builder().apply(block).build())

/**
 * Cancels a specified model transform job. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelMLModelTransformJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltransformjob) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.cancelMlModelTransformJob(crossinline block: CancelMlModelTransformJobRequest.Builder.() -> Unit): CancelMlModelTransformJobResponse = cancelMlModelTransformJob(CancelMlModelTransformJobRequest.Builder().apply(block).build())

/**
 * Cancels a specified openCypher query. See [Neptune openCypher status endpoint](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html) for more information.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CancelQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.cancelOpenCypherQuery(crossinline block: CancelOpenCypherQueryRequest.Builder.() -> Unit): CancelOpenCypherQueryResponse = cancelOpenCypherQuery(CancelOpenCypherQueryRequest.Builder().apply(block).build())

/**
 * Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training process constructed. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:CreateMLEndpoint](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#createmlendpoint) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.createMlEndpoint(crossinline block: CreateMlEndpointRequest.Builder.() -> Unit): CreateMlEndpointResponse = createMlEndpoint(CreateMlEndpointRequest.Builder().apply(block).build())

/**
 * Cancels the creation of a Neptune ML inference endpoint. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:DeleteMLEndpoint](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletemlendpoint) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.deleteMlEndpoint(crossinline block: DeleteMlEndpointRequest.Builder.() -> Unit): DeleteMlEndpointResponse = deleteMlEndpoint(DeleteMlEndpointRequest.Builder().apply(block).build())

/**
 * Deletes statistics for Gremlin and openCypher (property graph) data.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:DeleteStatistics](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.deletePropertygraphStatistics(crossinline block: DeletePropertygraphStatisticsRequest.Builder.() -> Unit): DeletePropertygraphStatisticsResponse = deletePropertygraphStatistics(DeletePropertygraphStatisticsRequest.Builder().apply(block).build())

/**
 * Deletes SPARQL statistics
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:DeleteStatistics](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.deleteSparqlStatistics(crossinline block: DeleteSparqlStatisticsRequest.Builder.() -> Unit): DeleteSparqlStatisticsResponse = deleteSparqlStatistics(DeleteSparqlStatisticsRequest.Builder().apply(block).build())

/**
 * The fast reset REST API lets you reset a Neptune graph quicky and easily, removing all of its data.
 *
 * Neptune fast reset is a two-step process. First you call `ExecuteFastReset` with `action` set to `initiateDatabaseReset`. This returns a UUID token which you then include when calling `ExecuteFastReset` again with `action` set to `performDatabaseReset`. See [Empty an Amazon Neptune DB cluster using the fast reset API](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-fast-reset.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ResetDatabase](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.executeFastReset(crossinline block: ExecuteFastResetRequest.Builder.() -> Unit): ExecuteFastResetResponse = executeFastReset(ExecuteFastResetRequest.Builder().apply(block).build())

/**
 * Executes a Gremlin Explain query.
 *
 * Amazon Neptune has added a Gremlin feature named `explain` that provides is a self-service tool for understanding the execution approach being taken by the Neptune engine for the query. You invoke it by adding an `explain` parameter to an HTTP call that submits a Gremlin query.
 *
 * The explain feature provides information about the logical structure of query execution plans. You can use this information to identify potential evaluation and execution bottlenecks and to tune your query, as explained in [Tuning Gremlin queries](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html). You can also use query hints to improve query execution plans.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows one of the following IAM actions in that cluster, depending on the query:
 * + [neptune-db:ReadDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery)
 * + [neptune-db:WriteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery)
 * + [neptune-db:DeleteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery)
 *
 * Note that the [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
 */
public suspend inline fun NeptunedataClient.executeGremlinExplainQuery(crossinline block: ExecuteGremlinExplainQueryRequest.Builder.() -> Unit): ExecuteGremlinExplainQueryResponse = executeGremlinExplainQuery(ExecuteGremlinExplainQueryRequest.Builder().apply(block).build())

/**
 * Executes a Gremlin Profile query, which runs a specified traversal, collects various metrics about the run, and produces a profile report as output. See [Gremlin profile API in Neptune](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html) for details.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ReadDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery) IAM action in that cluster.
 *
 * Note that the [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
 */
public suspend inline fun NeptunedataClient.executeGremlinProfileQuery(crossinline block: ExecuteGremlinProfileQueryRequest.Builder.() -> Unit): ExecuteGremlinProfileQueryResponse = executeGremlinProfileQuery(ExecuteGremlinProfileQueryRequest.Builder().apply(block).build())

/**
 * This commands executes a Gremlin query. Amazon Neptune is compatible with Apache TinkerPop3 and Gremlin, so you can use the Gremlin traversal language to query the graph, as described under [The Graph](https://tinkerpop.apache.org/docs/current/reference/#graph) in the Apache TinkerPop3 documentation. More details can also be found in [Accessing a Neptune graph with Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that enables one of the following IAM actions in that cluster, depending on the query:
 * + [neptune-db:ReadDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery)
 * + [neptune-db:WriteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery)
 * + [neptune-db:DeleteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery)
 *
 * Note that the [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
 */
public suspend inline fun NeptunedataClient.executeGremlinQuery(crossinline block: ExecuteGremlinQueryRequest.Builder.() -> Unit): ExecuteGremlinQueryResponse = executeGremlinQuery(ExecuteGremlinQueryRequest.Builder().apply(block).build())

/**
 * Executes an openCypher `explain` request. See [The openCypher explain feature](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-explain.html) for more information.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ReadDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery) IAM action in that cluster.
 *
 * Note that the [neptune-db:QueryLanguage:OpenCypher](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of openCypher queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
 */
public suspend inline fun NeptunedataClient.executeOpenCypherExplainQuery(crossinline block: ExecuteOpenCypherExplainQueryRequest.Builder.() -> Unit): ExecuteOpenCypherExplainQueryResponse = executeOpenCypherExplainQuery(ExecuteOpenCypherExplainQueryRequest.Builder().apply(block).build())

/**
 * Executes an openCypher query. See [Accessing the Neptune Graph with openCypher](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher.html) for more information.
 *
 * Neptune supports building graph applications using openCypher, which is currently one of the most popular query languages among developers working with graph databases. Developers, business analysts, and data scientists like openCypher's declarative, SQL-inspired syntax because it provides a familiar structure in which to querying property graphs.
 *
 * The openCypher language was originally developed by Neo4j, then open-sourced in 2015 and contributed to the [openCypher project](https://opencypher.org/) under an Apache 2 open-source license.
 *
 * Note that when invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows one of the following IAM actions in that cluster, depending on the query:
 * + [neptune-db:ReadDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery)
 * + [neptune-db:WriteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery)
 * + [neptune-db:DeleteDataViaQuery](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery)
 *
 * Note also that the [neptune-db:QueryLanguage:OpenCypher](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of openCypher queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
 */
public suspend inline fun NeptunedataClient.executeOpenCypherQuery(crossinline block: ExecuteOpenCypherQueryRequest.Builder.() -> Unit): ExecuteOpenCypherQueryResponse = executeOpenCypherQuery(ExecuteOpenCypherQueryRequest.Builder().apply(block).build())

/**
 * Retrieves the status of the graph database on the host.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetEngineStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getenginestatus) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.getEngineStatus(crossinline block: GetEngineStatusRequest.Builder.() -> Unit): GetEngineStatusResponse = getEngineStatus(GetEngineStatusRequest.Builder().apply(block).build())

/**
 * Gets the status of a specified Gremlin query.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetQueryStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus) IAM action in that cluster.
 *
 * Note that the [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
 */
public suspend inline fun NeptunedataClient.getGremlinQueryStatus(crossinline block: GetGremlinQueryStatusRequest.Builder.() -> Unit): GetGremlinQueryStatusResponse = getGremlinQueryStatus(GetGremlinQueryStatusRequest.Builder().apply(block).build())

/**
 * Gets status information about a specified load job. Neptune keeps track of the most recent 1,024 bulk load jobs, and stores the last 10,000 error details per job.
 *
 * See [Neptune Loader Get-Status API](https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm) for more information.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetLoaderJobStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getloaderjobstatus) IAM action in that cluster..
 */
public suspend inline fun NeptunedataClient.getLoaderJobStatus(crossinline block: GetLoaderJobStatusRequest.Builder.() -> Unit): GetLoaderJobStatusResponse = getLoaderJobStatus(GetLoaderJobStatusRequest.Builder().apply(block).build())

/**
 * Retrieves information about a specified data processing job. See `dataprocessing`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:neptune-db:GetMLDataProcessingJobStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmldataprocessingjobstatus) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.getMlDataProcessingJob(crossinline block: GetMlDataProcessingJobRequest.Builder.() -> Unit): GetMlDataProcessingJobResponse = getMlDataProcessingJob(GetMlDataProcessingJobRequest.Builder().apply(block).build())

/**
 * Retrieves details about an inference endpoint. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetMLEndpointStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlendpointstatus) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.getMlEndpoint(crossinline block: GetMlEndpointRequest.Builder.() -> Unit): GetMlEndpointResponse = getMlEndpoint(GetMlEndpointRequest.Builder().apply(block).build())

/**
 * Retrieves information about a Neptune ML model training job. See `modeltraining`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetMLModelTrainingJobStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltrainingjobstatus) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.getMlModelTrainingJob(crossinline block: GetMlModelTrainingJobRequest.Builder.() -> Unit): GetMlModelTrainingJobResponse = getMlModelTrainingJob(GetMlModelTrainingJobRequest.Builder().apply(block).build())

/**
 * Gets information about a specified model transform job. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetMLModelTransformJobStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltransformjobstatus) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.getMlModelTransformJob(crossinline block: GetMlModelTransformJobRequest.Builder.() -> Unit): GetMlModelTransformJobResponse = getMlModelTransformJob(GetMlModelTransformJobRequest.Builder().apply(block).build())

/**
 * Retrieves the status of a specified openCypher query.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetQueryStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus) IAM action in that cluster.
 *
 * Note that the [neptune-db:QueryLanguage:OpenCypher](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of openCypher queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
 */
public suspend inline fun NeptunedataClient.getOpenCypherQueryStatus(crossinline block: GetOpenCypherQueryStatusRequest.Builder.() -> Unit): GetOpenCypherQueryStatusResponse = getOpenCypherQueryStatus(GetOpenCypherQueryStatusRequest.Builder().apply(block).build())

/**
 * Gets property graph statistics (Gremlin and openCypher).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetStatisticsStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.getPropertygraphStatistics(crossinline block: GetPropertygraphStatisticsRequest.Builder.() -> Unit): GetPropertygraphStatisticsResponse = getPropertygraphStatistics(GetPropertygraphStatisticsRequest.Builder().apply(block).build())

/**
 * Gets a stream for a property graph.
 *
 * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every change made to your graph data as it happens. `GetPropertygraphStream` lets you collect these change-log entries for a property graph.
 *
 * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the [neptune_streams](https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams) DB cluster parameter to `1`.
 *
 * See [Capturing graph changes in real time using Neptune streams](https://docs.aws.amazon.com/neptune/latest/userguide/streams.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetStreamRecords](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords) IAM action in that cluster.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that enables one of the following IAM actions, depending on the query:
 *
 * Note that you can restrict property-graph queries using the following IAM context keys:
 * + [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys)
 * + [neptune-db:QueryLanguage:OpenCypher](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys)
 *
 * See [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
 */
public suspend inline fun NeptunedataClient.getPropertygraphStream(crossinline block: GetPropertygraphStreamRequest.Builder.() -> Unit): GetPropertygraphStreamResponse = getPropertygraphStream(GetPropertygraphStreamRequest.Builder().apply(block).build())

/**
 * Gets a graph summary for a property graph.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetGraphSummary](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.getPropertygraphSummary(crossinline block: GetPropertygraphSummaryRequest.Builder.() -> Unit): GetPropertygraphSummaryResponse = getPropertygraphSummary(GetPropertygraphSummaryRequest.Builder().apply(block).build())

/**
 * Gets a graph summary for an RDF graph.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetGraphSummary](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.getRdfGraphSummary(crossinline block: GetRdfGraphSummaryRequest.Builder.() -> Unit): GetRdfGraphSummaryResponse = getRdfGraphSummary(GetRdfGraphSummaryRequest.Builder().apply(block).build())

/**
 * Gets RDF statistics (SPARQL).
 */
public suspend inline fun NeptunedataClient.getSparqlStatistics(crossinline block: GetSparqlStatisticsRequest.Builder.() -> Unit): GetSparqlStatisticsResponse = getSparqlStatistics(GetSparqlStatisticsRequest.Builder().apply(block).build())

/**
 * Gets a stream for an RDF graph.
 *
 * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every change made to your graph data as it happens. `GetSparqlStream` lets you collect these change-log entries for an RDF graph.
 *
 * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the [neptune_streams](https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams) DB cluster parameter to `1`.
 *
 * See [Capturing graph changes in real time using Neptune streams](https://docs.aws.amazon.com/neptune/latest/userguide/streams.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetStreamRecords](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords) IAM action in that cluster.
 *
 * Note that the [neptune-db:QueryLanguage:Sparql](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of SPARQL queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
 */
public suspend inline fun NeptunedataClient.getSparqlStream(crossinline block: GetSparqlStreamRequest.Builder.() -> Unit): GetSparqlStreamResponse = getSparqlStream(GetSparqlStreamRequest.Builder().apply(block).build())

/**
 * Lists active Gremlin queries. See [Gremlin query status API](https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html) for details about the output.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetQueryStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus) IAM action in that cluster.
 *
 * Note that the [neptune-db:QueryLanguage:Gremlin](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
 */
public suspend inline fun NeptunedataClient.listGremlinQueries(crossinline block: ListGremlinQueriesRequest.Builder.() -> Unit): ListGremlinQueriesResponse = listGremlinQueries(ListGremlinQueriesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of the `loadIds` for all active loader jobs.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ListLoaderJobs](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listloaderjobs) IAM action in that cluster..
 */
public suspend inline fun NeptunedataClient.listLoaderJobs(crossinline block: ListLoaderJobsRequest.Builder.() -> Unit): ListLoaderJobsResponse = listLoaderJobs(ListLoaderJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of Neptune ML data processing jobs. See [Listing active data-processing jobs using the Neptune ML dataprocessing command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html#machine-learning-api-dataprocessing-list-jobs).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ListMLDataProcessingJobs](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmldataprocessingjobs) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.listMlDataProcessingJobs(crossinline block: ListMlDataProcessingJobsRequest.Builder.() -> Unit): ListMlDataProcessingJobsResponse = listMlDataProcessingJobs(ListMlDataProcessingJobsRequest.Builder().apply(block).build())

/**
 * Lists existing inference endpoints. See [Managing inference endpoints using the endpoints command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ListMLEndpoints](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlendpoints) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.listMlEndpoints(crossinline block: ListMlEndpointsRequest.Builder.() -> Unit): ListMlEndpointsResponse = listMlEndpoints(ListMlEndpointsRequest.Builder().apply(block).build())

/**
 * Lists Neptune ML model-training jobs. See `modeltraining`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:neptune-db:ListMLModelTrainingJobs](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#neptune-db:listmlmodeltrainingjobs) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.listMlModelTrainingJobs(crossinline block: ListMlModelTrainingJobsRequest.Builder.() -> Unit): ListMlModelTrainingJobsResponse = listMlModelTrainingJobs(ListMlModelTrainingJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of model transform job IDs. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ListMLModelTransformJobs](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltransformjobs) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.listMlModelTransformJobs(crossinline block: ListMlModelTransformJobsRequest.Builder.() -> Unit): ListMlModelTransformJobsResponse = listMlModelTransformJobs(ListMlModelTransformJobsRequest.Builder().apply(block).build())

/**
 * Lists active openCypher queries. See [Neptune openCypher status endpoint](https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html) for more information.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:GetQueryStatus](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus) IAM action in that cluster.
 *
 * Note that the [neptune-db:QueryLanguage:OpenCypher](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys) IAM condition key can be used in the policy document to restrict the use of openCypher queries (see [Condition keys available in Neptune IAM data-access policy statements](https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html)).
 */
public suspend inline fun NeptunedataClient.listOpenCypherQueries(crossinline block: ListOpenCypherQueriesRequest.Builder.() -> Unit): ListOpenCypherQueriesResponse = listOpenCypherQueries(ListOpenCypherQueriesRequest.Builder().apply(block).build())

/**
 * Manages the generation and use of property graph statistics.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ManageStatistics](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.managePropertygraphStatistics(crossinline block: ManagePropertygraphStatisticsRequest.Builder.() -> Unit): ManagePropertygraphStatisticsResponse = managePropertygraphStatistics(ManagePropertygraphStatisticsRequest.Builder().apply(block).build())

/**
 * Manages the generation and use of RDF graph statistics.
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:ManageStatistics](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.manageSparqlStatistics(crossinline block: ManageSparqlStatisticsRequest.Builder.() -> Unit): ManageSparqlStatisticsResponse = manageSparqlStatistics(ManageSparqlStatisticsRequest.Builder().apply(block).build())

/**
 * Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into a Neptune DB instance. See [Using the Amazon Neptune Bulk Loader to Ingest Data](https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:StartLoaderJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startloaderjob) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.startLoaderJob(crossinline block: StartLoaderJobRequest.Builder.() -> Unit): StartLoaderJobResponse = startLoaderJob(StartLoaderJobRequest.Builder().apply(block).build())

/**
 * Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training. See `dataprocessing`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:StartMLModelDataProcessingJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeldataprocessingjob) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.startMlDataProcessingJob(crossinline block: StartMlDataProcessingJobRequest.Builder.() -> Unit): StartMlDataProcessingJobResponse = startMlDataProcessingJob(StartMlDataProcessingJobRequest.Builder().apply(block).build())

/**
 * Creates a new Neptune ML model training job. See `modeltraining`[ command](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:StartMLModelTrainingJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltrainingjob) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.startMlModelTrainingJob(crossinline block: StartMlModelTrainingJobRequest.Builder.() -> Unit): StartMlModelTrainingJobResponse = startMlModelTrainingJob(StartMlModelTrainingJobRequest.Builder().apply(block).build())

/**
 * Creates a new model transform job. See [Use a trained model to generate new model artifacts](https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html).
 *
 * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the [neptune-db:StartMLModelTransformJob](https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltransformjob) IAM action in that cluster.
 */
public suspend inline fun NeptunedataClient.startMlModelTransformJob(crossinline block: StartMlModelTransformJobRequest.Builder.() -> Unit): StartMlModelTransformJobResponse = startMlModelTransformJob(StartMlModelTransformJobRequest.Builder().apply(block).build())
