// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.waiters

import aws.sdk.kotlin.services.neptune.NeptuneClient
import aws.sdk.kotlin.services.neptune.model.DescribeDbInstancesRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbInstancesResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


public suspend fun NeptuneClient.waitUntilDBInstanceAvailable(request: DescribeDbInstancesRequest = DescribeDbInstancesRequest { }): Outcome<DescribeDbInstancesResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeDbInstancesRequest, DescribeDbInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "incompatible-restore" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "incompatible-parameters" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbInstances(request) }
}

public suspend fun NeptuneClient.waitUntilDBInstanceAvailable(block: DescribeDbInstancesRequest.Builder.() -> Unit): Outcome<DescribeDbInstancesResponse> =
    waitUntilDBInstanceAvailable(DescribeDbInstancesRequest.Builder().apply(block).build())

public suspend fun NeptuneClient.waitUntilDBInstanceDeleted(request: DescribeDbInstancesRequest = DescribeDbInstancesRequest { }): Outcome<DescribeDbInstancesResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeDbInstancesRequest, DescribeDbInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "deleted" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "DBInstanceNotFound"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "rebooting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "resetting-master-credentials" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbInstances(request) }
}

public suspend fun NeptuneClient.waitUntilDBInstanceDeleted(block: DescribeDbInstancesRequest.Builder.() -> Unit): Outcome<DescribeDbInstancesResponse> =
    waitUntilDBInstanceDeleted(DescribeDbInstancesRequest.Builder().apply(block).build())
