// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DbCluster
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.sdk.kotlin.services.neptune.model.RestoreDbClusterToPointInTimeResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class RestoreDBClusterToPointInTimeOperationDeserializer: HttpDeserializer.NonStreaming<RestoreDbClusterToPointInTimeResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RestoreDbClusterToPointInTimeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRestoreDbClusterToPointInTimeError(context, call, payload)
        }
        val builder = RestoreDbClusterToPointInTimeResponse.Builder()

        if (payload != null) {
            deserializeRestoreDBClusterToPointInTimeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRestoreDbClusterToPointInTimeError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientDBClusterCapacityFault" -> InsufficientDbClusterCapacityFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientStorageClusterCapacity" -> InsufficientStorageClusterCapacityFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBSnapshotState" -> InvalidDbSnapshotStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall, payload)
        "StorageQuotaExceeded" -> StorageQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterSnapshotNotFoundFault" -> DbClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "OptionGroupNotFoundFault" -> OptionGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterParameterGroupNotFound" -> DbClusterParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBClusterSnapshotStateFault" -> InvalidDbClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterAlreadyExistsFault" -> DbClusterAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRestoreFault" -> InvalidRestoreFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterQuotaExceededFault" -> DbClusterQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreDBClusterToPointInTimeOperationBody(builder: RestoreDbClusterToPointInTimeResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "RestoreDBClusterToPointInTime")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBCluster com.amazonaws.neptune#RestoreDBClusterToPointInTimeResult$DBCluster
            "DBCluster" -> builder.dbCluster = deserializeDbClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
