// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DbClusterSnapshotAttributesResult
import aws.sdk.kotlin.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyDBClusterSnapshotAttributeOperationDeserializer: HttpDeserializer.NonStreaming<ModifyDbClusterSnapshotAttributeResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifyDbClusterSnapshotAttributeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyDbClusterSnapshotAttributeError(context, call, payload)
        }
        val builder = ModifyDbClusterSnapshotAttributeResponse.Builder()

        if (payload != null) {
            deserializeModifyDBClusterSnapshotAttributeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifyDbClusterSnapshotAttributeError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDBClusterSnapshotStateFault" -> InvalidDbClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SharedSnapshotQuotaExceeded" -> SharedSnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterSnapshotNotFoundFault" -> DbClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyDBClusterSnapshotAttributeOperationBody(builder: ModifyDbClusterSnapshotAttributeResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyDBClusterSnapshotAttribute")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBClusterSnapshotAttributesResult com.amazonaws.neptune#ModifyDBClusterSnapshotAttributeResult$DBClusterSnapshotAttributesResult
            "DBClusterSnapshotAttributesResult" -> builder.dbClusterSnapshotAttributesResult = deserializeDbClusterSnapshotAttributesResultDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
