// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.Event
import aws.sdk.kotlin.services.neptune.model.SourceType
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeEventDocument(reader: XmlTagReader): Event {
    val builder = Event.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // SourceIdentifier com.amazonaws.neptune#Event$SourceIdentifier
            "SourceIdentifier" -> builder.sourceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // SourceType com.amazonaws.neptune#Event$SourceType
            "SourceType" -> builder.sourceType = curr.tryData()
                .parse { SourceType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.neptune#SourceType`)" }
            // Message com.amazonaws.neptune#Event$Message
            "Message" -> builder.message = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // EventCategories com.amazonaws.neptune#Event$EventCategories
            "EventCategories" -> builder.eventCategories = deserializeEventCategoriesListShape(curr)
            // Date com.amazonaws.neptune#Event$Date
            "Date" -> builder.date = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.neptune#TStamp`)" }
            // SourceArn com.amazonaws.neptune#Event$SourceArn
            "SourceArn" -> builder.sourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
