// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DbSubnetGroup
import aws.sdk.kotlin.services.neptune.model.DescribeDbSubnetGroupsResponse
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeDBSubnetGroupsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDbSubnetGroupsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDbSubnetGroupsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDbSubnetGroupsError(context, call, payload)
        }
        val builder = DescribeDbSubnetGroupsResponse.Builder()

        if (payload != null) {
            deserializeDescribeDBSubnetGroupsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDbSubnetGroupsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDBSubnetGroupsOperationBody(builder: DescribeDbSubnetGroupsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeDBSubnetGroups")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBSubnetGroups com.amazonaws.neptune#DBSubnetGroupMessage$DBSubnetGroups
            "DBSubnetGroups" -> builder.dbSubnetGroups = deserializeDBSubnetGroupsShape(curr)
            // Marker com.amazonaws.neptune#DBSubnetGroupMessage$Marker
            "Marker" -> builder.marker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
