// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DbInstance
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbInstanceDocument(reader: XmlTagReader): DbInstance {
    val builder = DbInstance.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBInstanceIdentifier com.amazonaws.neptune#DBInstance$DBInstanceIdentifier
            "DBInstanceIdentifier" -> builder.dbInstanceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBInstanceClass com.amazonaws.neptune#DBInstance$DBInstanceClass
            "DBInstanceClass" -> builder.dbInstanceClass = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // Engine com.amazonaws.neptune#DBInstance$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBInstanceStatus com.amazonaws.neptune#DBInstance$DBInstanceStatus
            "DBInstanceStatus" -> builder.dbInstanceStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // MasterUsername com.amazonaws.neptune#DBInstance$MasterUsername
            "MasterUsername" -> builder.masterUsername = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBName com.amazonaws.neptune#DBInstance$DBName
            "DBName" -> builder.dbName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // Endpoint com.amazonaws.neptune#DBInstance$Endpoint
            "Endpoint" -> builder.endpoint = deserializeEndpointDocument(curr)
            // AllocatedStorage com.amazonaws.neptune#DBInstance$AllocatedStorage
            "AllocatedStorage" -> builder.allocatedStorage = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#Integer`)" }
            // InstanceCreateTime com.amazonaws.neptune#DBInstance$InstanceCreateTime
            "InstanceCreateTime" -> builder.instanceCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.neptune#TStamp`)" }
            // PreferredBackupWindow com.amazonaws.neptune#DBInstance$PreferredBackupWindow
            "PreferredBackupWindow" -> builder.preferredBackupWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // BackupRetentionPeriod com.amazonaws.neptune#DBInstance$BackupRetentionPeriod
            "BackupRetentionPeriod" -> builder.backupRetentionPeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#Integer`)" }
            // DBSecurityGroups com.amazonaws.neptune#DBInstance$DBSecurityGroups
            "DBSecurityGroups" -> builder.dbSecurityGroups = deserializeDBSecurityGroupMembershipListShape(curr)
            // VpcSecurityGroups com.amazonaws.neptune#DBInstance$VpcSecurityGroups
            "VpcSecurityGroups" -> builder.vpcSecurityGroups = deserializeVpcSecurityGroupMembershipListShape(curr)
            // DBParameterGroups com.amazonaws.neptune#DBInstance$DBParameterGroups
            "DBParameterGroups" -> builder.dbParameterGroups = deserializeDBParameterGroupStatusListShape(curr)
            // AvailabilityZone com.amazonaws.neptune#DBInstance$AvailabilityZone
            "AvailabilityZone" -> builder.availabilityZone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBSubnetGroup com.amazonaws.neptune#DBInstance$DBSubnetGroup
            "DBSubnetGroup" -> builder.dbSubnetGroup = deserializeDbSubnetGroupDocument(curr)
            // PreferredMaintenanceWindow com.amazonaws.neptune#DBInstance$PreferredMaintenanceWindow
            "PreferredMaintenanceWindow" -> builder.preferredMaintenanceWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // PendingModifiedValues com.amazonaws.neptune#DBInstance$PendingModifiedValues
            "PendingModifiedValues" -> builder.pendingModifiedValues = deserializePendingModifiedValuesDocument(curr)
            // LatestRestorableTime com.amazonaws.neptune#DBInstance$LatestRestorableTime
            "LatestRestorableTime" -> builder.latestRestorableTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.neptune#TStamp`)" }
            // MultiAZ com.amazonaws.neptune#DBInstance$MultiAZ
            "MultiAZ" -> builder.multiAz = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#Boolean`)" }
            // EngineVersion com.amazonaws.neptune#DBInstance$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // AutoMinorVersionUpgrade com.amazonaws.neptune#DBInstance$AutoMinorVersionUpgrade
            "AutoMinorVersionUpgrade" -> builder.autoMinorVersionUpgrade = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#Boolean`)" }
            // ReadReplicaSourceDBInstanceIdentifier com.amazonaws.neptune#DBInstance$ReadReplicaSourceDBInstanceIdentifier
            "ReadReplicaSourceDBInstanceIdentifier" -> builder.readReplicaSourceDbInstanceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // ReadReplicaDBInstanceIdentifiers com.amazonaws.neptune#DBInstance$ReadReplicaDBInstanceIdentifiers
            "ReadReplicaDBInstanceIdentifiers" -> builder.readReplicaDbInstanceIdentifiers = deserializeReadReplicaDBInstanceIdentifierListShape(curr)
            // ReadReplicaDBClusterIdentifiers com.amazonaws.neptune#DBInstance$ReadReplicaDBClusterIdentifiers
            "ReadReplicaDBClusterIdentifiers" -> builder.readReplicaDbClusterIdentifiers = deserializeReadReplicaDBClusterIdentifierListShape(curr)
            // LicenseModel com.amazonaws.neptune#DBInstance$LicenseModel
            "LicenseModel" -> builder.licenseModel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // Iops com.amazonaws.neptune#DBInstance$Iops
            "Iops" -> builder.iops = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#IntegerOptional`)" }
            // OptionGroupMemberships com.amazonaws.neptune#DBInstance$OptionGroupMemberships
            "OptionGroupMemberships" -> builder.optionGroupMemberships = deserializeOptionGroupMembershipListShape(curr)
            // CharacterSetName com.amazonaws.neptune#DBInstance$CharacterSetName
            "CharacterSetName" -> builder.characterSetName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // SecondaryAvailabilityZone com.amazonaws.neptune#DBInstance$SecondaryAvailabilityZone
            "SecondaryAvailabilityZone" -> builder.secondaryAvailabilityZone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // PubliclyAccessible com.amazonaws.neptune#DBInstance$PubliclyAccessible
            "PubliclyAccessible" -> builder.publiclyAccessible = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#Boolean`)" }
            // StatusInfos com.amazonaws.neptune#DBInstance$StatusInfos
            "StatusInfos" -> builder.statusInfos = deserializeDBInstanceStatusInfoListShape(curr)
            // StorageType com.amazonaws.neptune#DBInstance$StorageType
            "StorageType" -> builder.storageType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // TdeCredentialArn com.amazonaws.neptune#DBInstance$TdeCredentialArn
            "TdeCredentialArn" -> builder.tdeCredentialArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DbInstancePort com.amazonaws.neptune#DBInstance$DbInstancePort
            "DbInstancePort" -> builder.dbInstancePort = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#Integer`)" }
            // DBClusterIdentifier com.amazonaws.neptune#DBInstance$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // StorageEncrypted com.amazonaws.neptune#DBInstance$StorageEncrypted
            "StorageEncrypted" -> builder.storageEncrypted = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#Boolean`)" }
            // KmsKeyId com.amazonaws.neptune#DBInstance$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DbiResourceId com.amazonaws.neptune#DBInstance$DbiResourceId
            "DbiResourceId" -> builder.dbiResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // CACertificateIdentifier com.amazonaws.neptune#DBInstance$CACertificateIdentifier
            "CACertificateIdentifier" -> builder.caCertificateIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DomainMemberships com.amazonaws.neptune#DBInstance$DomainMemberships
            "DomainMemberships" -> builder.domainMemberships = deserializeDomainMembershipListShape(curr)
            // CopyTagsToSnapshot com.amazonaws.neptune#DBInstance$CopyTagsToSnapshot
            "CopyTagsToSnapshot" -> builder.copyTagsToSnapshot = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#Boolean`)" }
            // MonitoringInterval com.amazonaws.neptune#DBInstance$MonitoringInterval
            "MonitoringInterval" -> builder.monitoringInterval = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#IntegerOptional`)" }
            // EnhancedMonitoringResourceArn com.amazonaws.neptune#DBInstance$EnhancedMonitoringResourceArn
            "EnhancedMonitoringResourceArn" -> builder.enhancedMonitoringResourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // MonitoringRoleArn com.amazonaws.neptune#DBInstance$MonitoringRoleArn
            "MonitoringRoleArn" -> builder.monitoringRoleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // PromotionTier com.amazonaws.neptune#DBInstance$PromotionTier
            "PromotionTier" -> builder.promotionTier = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#IntegerOptional`)" }
            // DBInstanceArn com.amazonaws.neptune#DBInstance$DBInstanceArn
            "DBInstanceArn" -> builder.dbInstanceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // Timezone com.amazonaws.neptune#DBInstance$Timezone
            "Timezone" -> builder.timezone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // IAMDatabaseAuthenticationEnabled com.amazonaws.neptune#DBInstance$IAMDatabaseAuthenticationEnabled
            "IAMDatabaseAuthenticationEnabled" -> builder.iamDatabaseAuthenticationEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#Boolean`)" }
            // PerformanceInsightsEnabled com.amazonaws.neptune#DBInstance$PerformanceInsightsEnabled
            "PerformanceInsightsEnabled" -> builder.performanceInsightsEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#BooleanOptional`)" }
            // PerformanceInsightsKMSKeyId com.amazonaws.neptune#DBInstance$PerformanceInsightsKMSKeyId
            "PerformanceInsightsKMSKeyId" -> builder.performanceInsightsKmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // EnabledCloudwatchLogsExports com.amazonaws.neptune#DBInstance$EnabledCloudwatchLogsExports
            "EnabledCloudwatchLogsExports" -> builder.enabledCloudwatchLogsExports = deserializeLogTypeListShape(curr)
            // DeletionProtection com.amazonaws.neptune#DBInstance$DeletionProtection
            "DeletionProtection" -> builder.deletionProtection = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#BooleanOptional`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
